/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.util.StackTraces;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceError
extends TracedError {
    private final StackTraceElement[] stackTrace;
    private final String message;
    private final String exceptionClass;

    public StackTraceError(String frontendMetricName, String message, String exceptionClass, StackTraceElement[] stackTrace, String requestPath, Map errorParameters) {
        super(frontendMetricName, requestPath, errorParameters, System.currentTimeMillis());
        this.stackTrace = stackTrace;
        this.message = message;
        this.exceptionClass = exceptionClass;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public String getExceptionClass() {
        return this.exceptionClass;
    }

    @Override
    public Collection<String> stackTrace() {
        return StackTraces.stackTracesToStrings(this.stackTrace);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stackTrace == null ? 0 : this.stackTrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StackTraceError other = (StackTraceError)obj;
        return !(this.stackTrace == null ? other.stackTrace != null : !this.stackTrace.equals(other.stackTrace));
    }
}

