/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.errors.TracedError;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTracedError
extends TracedError {
    private final int responseStatus;
    private final String errorMessage;

    public HttpTracedError(String frontendMetricName, int responseStatus, String errorMessage, String requestPath, Map errorParameters, long timestamp) {
        super(frontendMetricName, requestPath, errorParameters, timestamp);
        this.responseStatus = responseStatus;
        this.errorMessage = errorMessage == null ? (responseStatus >= 400 && responseStatus < 500 ? "HttpClientError " + responseStatus : "HttpServerError " + responseStatus) : errorMessage;
    }

    @Override
    public Collection<String> stackTrace() {
        return null;
    }

    @Override
    public String getExceptionClass() {
        return this.getMessage();
    }

    @Override
    public String getMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return MessageFormat.format("{0} ({1})", this.getMessage(), this.responseStatus);
    }
}

