/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.instrumentation.classmatchers.ClassMatcher;
import com.newrelic.agent.instrumentation.classmatchers.ExactClassMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.ExactMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InstanceMethodMatcher;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.methodmatchers.MethodMatcher;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import com.newrelic.org.objectweb.asm.Type;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionHandlerSignature
implements JSONStreamAware {
    private final String className;
    private final String methodName;
    private final String methodDescription;

    public ExceptionHandlerSignature(String className, String methodName, String methodDescription) throws InvalidMethodDescriptor {
        this.className = className;
        this.methodName = methodName;
        this.methodDescription = methodDescription;
        new ExactMethodMatcher(methodName, methodDescription).validate();
    }

    public ExceptionHandlerSignature(ClassMethodSignature sig) throws InvalidMethodDescriptor {
        this.className = sig.getClassName();
        this.methodName = sig.getMethodName();
        this.methodDescription = sig.getMethodDesc();
        new ExactMethodMatcher(this.methodName, this.methodDescription).validate();
    }

    private static Collection<String> getExceptionClassNames() {
        List<Class> classes = Arrays.asList(Throwable.class, Error.class, Exception.class);
        ArrayList<String> classNames = new ArrayList<String>();
        for (Class clazz : classes) {
            classNames.add(clazz.getName());
        }
        classNames.add("javax.servlet.ServletException");
        return classNames;
    }

    public int getExceptionArgumentIndex() {
        Type[] types = Type.getArgumentTypes(this.methodDescription);
        Collection<String> exceptionClassNames = ExceptionHandlerSignature.getExceptionClassNames();
        for (int i = 0; i < types.length; ++i) {
            if (!exceptionClassNames.contains(types[i].getClassName())) continue;
            return i;
        }
        return -1;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getMethodDescription() {
        return this.methodDescription;
    }

    public ClassMatcher getClassMatcher() {
        return new ExactClassMatcher(this.className);
    }

    public MethodMatcher getMethodMatcher() {
        return new InstanceMethodMatcher(new ExactMethodMatcher(this.methodName, this.methodDescription));
    }

    @Override
    public void writeJSONString(Writer out) throws IOException {
        JSONArray.writeJSONString(Arrays.asList(this.className, this.methodName, this.methodDescription), out);
    }

    public String toString() {
        return this.className.replace('/', '.') + '.' + this.methodName + this.methodDescription;
    }
}

