/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.errors;

import com.newrelic.agent.Agent;
import com.newrelic.agent.RPMService;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.TransactionListener;
import com.newrelic.agent.TransactionService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.errors.ExceptionHandlerPointCut;
import com.newrelic.agent.errors.ExceptionHandlerSignature;
import com.newrelic.agent.errors.HttpTracedError;
import com.newrelic.agent.errors.ThrowableError;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.instrumentation.PointCut;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.instrumentation.yaml.PointCutFactory;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.tracers.ClassMethodSignature;
import com.newrelic.agent.util.FixedSizeSet;
import com.newrelic.agent.util.StackTraces;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorService {
    private final int ERROR_LIMIT_PER_REPORTING_PERIOD = 20;
    private int errorCount = 0;
    private int countForErrorMetric = 0;
    private final Set<TracedError> tracedErrors;
    private final ErrorCollectorConfig errorCollectorConfig;
    private boolean errorCollectorEnabled;
    private boolean computeErrorMetric;
    private final String appName;

    public ErrorService(String appName) {
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.errorCollectorConfig = config.getErrorCollectorConfig();
        this.errorCollectorEnabled = this.errorCollectorConfig.isEnabled();
        this.tracedErrors = this.errorCollectorEnabled ? new FixedSizeSet(20) : Collections.EMPTY_SET;
        TransactionService txService = ServiceManagerFactory.getServiceManager().getTransactionService();
        txService.addTransactionListener(new MyTransactionListener());
        this.computeErrorMetric = !Boolean.getBoolean("com.newrelic.agent.errors.no_error_metric");
        this.appName = appName;
    }

    Config getConfig() {
        return this.errorCollectorConfig;
    }

    public synchronized void reportError(TracedError error) {
        ++this.errorCount;
        if (error == null) {
            return;
        }
        if (error.incrementsErrorMetric()) {
            ++this.countForErrorMetric;
        }
        if (this.errorCollectorEnabled && this.tracedErrors.size() < 20) {
            this.tracedErrors.add(error);
        }
    }

    public synchronized void reportErrors(TracedError ... errors) {
        for (TracedError error : errors) {
            this.reportError(error);
        }
    }

    public synchronized int getErrorCount() {
        return this.errorCount;
    }

    public synchronized void clear() {
        this.errorCount = 0;
        this.countForErrorMetric = 0;
        this.tracedErrors.clear();
    }

    public synchronized Collection<TracedError> getTracedErrors() {
        return new ArrayList<TracedError>(this.tracedErrors);
    }

    public void setEnabled(boolean enabled) {
        this.errorCollectorEnabled = this.errorCollectorEnabled && enabled;
    }

    public boolean isEnabled() {
        return this.errorCollectorEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TracedError> harvest(RPMService rpmService) {
        List<TracedError> errors;
        int errorCount;
        if (!this.errorCollectorEnabled) {
            return Collections.emptyList();
        }
        Object object = this;
        synchronized (object) {
            errorCount = this.countForErrorMetric;
            if (rpmService.isConnected()) {
                errors = this.getTracedErrors();
                this.clear();
            } else {
                errors = Collections.emptyList();
                this.countForErrorMetric = 0;
            }
        }
        if (this.computeErrorMetric) {
            object = rpmService.getStatsEngine().getHarvestLock();
            synchronized (object) {
                Stats errorsStats = rpmService.getStatsEngine().getStats("Errors/all");
                errorsStats.incrementCallCount(errorCount);
            }
        }
        return errors;
    }

    private void noticeTransaction(TransactionData transactionData) {
        if (transactionData.getApplicationName() != this.appName) {
            return;
        }
        if (transactionData.getResponseStatus() >= 400) {
            if (!this.errorCollectorEnabled || this.tracedErrors.size() > 20) {
                this.reportError(null);
                return;
            }
            if (this.isIgnoredError(transactionData)) {
                if (Agent.LOG.isLoggable(Level.FINER)) {
                    String msg = MessageFormat.format("Ignoring error {0} for {1} ({2})", transactionData.getRequestUri(), this.appName, transactionData.getResponseStatus());
                    Agent.LOG.finer(msg);
                }
                return;
            }
            Throwable throwable = transactionData.getThrowable();
            TracedError error = throwable != null ? new ThrowableError(transactionData.getBlameOrRootMetricName(), throwable, transactionData.getRequestUri(), transactionData.getParameters(), transactionData.getStartTime()) : new HttpTracedError(transactionData.getBlameOrRootMetricName(), transactionData.getResponseStatus(), transactionData.getStatusMessage(), transactionData.getRequestUri(), transactionData.getParameters(), transactionData.getRootTracer().getStartTime());
            if (Agent.LOG.isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Recording error for {0} : {1}", this.appName, error);
                Agent.LOG.finer(msg);
            }
            this.reportError(error);
            return;
        }
    }

    public boolean isIgnoredError(TransactionData transactionData) {
        if (this.errorCollectorConfig.getIgnoreStatusCodes().contains(transactionData.getResponseStatus())) {
            return true;
        }
        Throwable throwable = transactionData.getThrowable();
        if (throwable != null) {
            throwable = StackTraces.getRootCause(throwable);
            if (this.errorCollectorConfig.getIgnoreErrors().contains(throwable.getClass().getName())) {
                return true;
            }
        }
        return false;
    }

    public static Collection<? extends PointCut> getErrorHandlerPointCuts() {
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        Object exceptionHandlers = config.getErrorCollectorConfig().getProperty("exception_handlers");
        if (exceptionHandlers == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ExceptionHandlerPointCut> pointcuts = new ArrayList<ExceptionHandlerPointCut>();
        if (exceptionHandlers instanceof Collection) {
            for (Object sigObject : (Collection)exceptionHandlers) {
                ExceptionHandlerPointCut pc;
                if (sigObject instanceof ExceptionHandlerSignature) {
                    ExceptionHandlerSignature exHandlerSig = (ExceptionHandlerSignature)sigObject;
                    String msg = MessageFormat.format("Instrumenting exception handler signature {0}", exHandlerSig.toString());
                    Agent.LOG.finer(msg);
                    Agent.LOG.log(Level.INFO, "Instrumenting exception handler signature {0}", exHandlerSig.toString());
                    pc = new ExceptionHandlerPointCut(exHandlerSig);
                    pointcuts.add(pc);
                    continue;
                }
                if (sigObject instanceof String) {
                    ClassMethodSignature signature = PointCutFactory.parseClassMethodSignature(sigObject.toString());
                    try {
                        ExceptionHandlerSignature exHandlerSig = new ExceptionHandlerSignature(signature);
                        Agent.LOG.log(Level.INFO, "Instrumenting exception handler signature {0}", exHandlerSig.toString());
                        pc = new ExceptionHandlerPointCut(exHandlerSig);
                        pointcuts.add(pc);
                    }
                    catch (InvalidMethodDescriptor e) {
                        Agent.LOG.log(Level.SEVERE, "Unable to instrument exception handler {0} : {1}", new Object[]{sigObject.toString(), e.toString()});
                    }
                    continue;
                }
                if (!(sigObject instanceof Exception)) continue;
                Agent.LOG.log(Level.SEVERE, "Unable to instrument exception handler : {0}", sigObject.toString());
            }
        }
        return pointcuts;
    }

    private class MyTransactionListener
    implements TransactionListener {
        private MyTransactionListener() {
        }

        public void dispatcherTransactionFinished(TransactionData transactionData) {
            ErrorService.this.noticeTransaction(transactionData);
        }
    }
}

