/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.config.ConfigServiceImpl;
import com.newrelic.agent.config.ConfigurationException;
import java.io.File;
import java.text.MessageFormat;

public class ConfigServiceFactory {
    public static ConfigService createConfigService(AgentConfig config) {
        return new ConfigServiceImpl(config, null);
    }

    public static ConfigService createConfigService() throws ConfigurationException {
        File configFile = ConfigServiceFactory.getConfigFile();
        AgentConfig config = ConfigServiceFactory.createAgentConfig(configFile);
        ConfigServiceFactory.validateConfig(config);
        return new ConfigServiceImpl(config, configFile);
    }

    private static AgentConfig createAgentConfig(File configFile) throws ConfigurationException {
        try {
            return new AgentConfig(configFile);
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred reading the New Relic configuration file {0}: {1}", configFile.getAbsolutePath(), e.toString());
            throw new ConfigurationException(msg, e);
        }
    }

    private static File getConfigFile() throws ConfigurationException {
        File configFile = ConfigFileHelper.findConfigFile();
        if (configFile == null) {
            throw new ConfigurationException("Failed to find New Relic configuration file");
        }
        return configFile;
    }

    private static void validateConfig(AgentConfig config) throws ConfigurationException {
        if (config.getApplicationName() == null) {
            throw new ConfigurationException("The agent requires an application name.  Check the app_name setting in newrelic.yml");
        }
    }
}

