/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.org.json.simple.parser.JSONParser;
import com.newrelic.org.json.simple.parser.ParseException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private final Map props;
    private final String systemPropertyRoot;

    public Config(Map props, String systemPropertyRoot) {
        if (props == null) {
            Agent.LOG.finer("Config object was initialized with null properties");
            props = Collections.emptyMap();
        }
        this.props = Collections.unmodifiableMap(props);
        this.systemPropertyRoot = systemPropertyRoot;
    }

    public Config(Map props) {
        this(props, null);
    }

    public Map getProperties() {
        return this.props;
    }

    private Object getPropertyFromSystemProperties(String name, Object defaultVal) {
        if (this.systemPropertyRoot == null) {
            return null;
        }
        try {
            String key = this.systemPropertyRoot + '.' + name;
            String val = System.getProperty(key);
            if (val != null) {
                return Config.castValue(key, val, defaultVal);
            }
            return val;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object castValue(String name, String val, Object defaultVal) {
        if (defaultVal instanceof String) {
            return val.toString();
        }
        try {
            return new JSONParser().parse(val);
        }
        catch (ParseException e) {
            Agent.LOG.log(Level.FINEST, "Unable to parse system property {0} with value {1} : {2}.", new Object[]{name, val, e.toString()});
            return val.toString();
        }
    }

    public <T> T getProperty(String key, T defaultVal) {
        Object override = this.getPropertyFromSystemProperties(key, defaultVal);
        if (override != null) {
            return (T)override;
        }
        try {
            Object val = this.props.get(key);
            if (val == null) {
                return defaultVal;
            }
            if (val instanceof String) {
                return (T)((String)val).trim();
            }
            return (T)val;
        }
        catch (ClassCastException e) {
            Agent.LOG.log(Level.SEVERE, "Unable to parse configuration key/value: {0}/{1}", new Object[]{key, this.props.get(key)});
            return defaultVal;
        }
    }

    public <T> T getProperty(String key) {
        return this.getProperty(key, null);
    }

    public Config getConfig(String key) {
        Map props = (Map)this.getProperty(key);
        if (props == null) {
            props = Collections.emptyMap();
        }
        return new Config(props);
    }
}

