/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.config;

import com.newrelic.agent.Agent;
import com.newrelic.agent.config.AgentJarHelper;
import com.newrelic.agent.config.ClassTransformerConfig;
import com.newrelic.agent.config.Config;
import com.newrelic.agent.config.ConfigFileHelper;
import com.newrelic.agent.config.ErrorCollectorConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.errors.ExceptionHandlerSignature;
import com.newrelic.agent.instrumentation.methodmatchers.InvalidMethodDescriptor;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.Strings;
import com.newrelic.org.json.simple.JSONObject;
import com.newrelic.org.json.simple.JSONStreamAware;
import com.newrelic.org.yaml.snakeyaml.Loader;
import com.newrelic.org.yaml.snakeyaml.Yaml;
import com.newrelic.org.yaml.snakeyaml.constructor.Construct;
import com.newrelic.org.yaml.snakeyaml.constructor.Constructor;
import com.newrelic.org.yaml.snakeyaml.nodes.Node;
import com.newrelic.org.yaml.snakeyaml.nodes.SequenceNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentConfig
extends Config
implements JSONStreamAware {
    public static final String GENERIC_JDBC_SUPPORT = "generic";
    public static final String MYSQL_JDBC_SUPPORT = "mysql";
    public static final String MAX_PENDING_TRANSACTIONS = "max_pending_transactions";
    public static final String STALL_THRESHOLD = "stall_threshold";
    public static final String ENABLE_AUTO_APP_NAMING = "enable_auto_app_naming";
    public static final String SYNC_STARTUP = "sync_startup";
    public static final String APP_RENAMING = "app_renaming";
    public static final String APP_NAME = "app_name";
    public static final String DEFAULT_HOST = "collector.newrelic.com";
    public static final int DEFAULT_PORT = 80;
    public static final int DEFAULT_SSL_PORT = 443;
    public static final String NEWRELIC_ENVIRONMENT_SYSTEM_PROPERTY = "newrelic.environment";
    public static final String NEWRELIC_YAML_FILENAME = "newrelic.yml";
    private final Config profilerConfig;
    private final boolean debug;
    private final boolean captureParams;
    private final TransactionTracerConfig transactionTraceConfig;
    private final Map<String, TransactionTracerConfig> transactionTraceBuckets;
    private final int maxStackTraceLines;
    private final Set<String> ignoredParams;
    private ErrorCollectorConfig errorCollectorConfig;
    private final boolean traceDataCalls;
    private final boolean threadCpuTimeEnabled;
    private final boolean reportSqlParserErrors;
    private final Set<String> jdbcSupport;
    private final boolean genericJdbcSupportEnabled;
    private final int transactionSizeLimit;
    private final Config supportabilityConfig;
    private ClassTransformerConfig classTransformerConfig;
    private final List<String> appNames;
    private final boolean customTracingEnabled;
    private final boolean autoAppNamingEnabled = this.getProperty("enable_auto_app_naming", false);
    private final Map<String, String> appRenaming;
    private final String appName;
    private final boolean waitForRPMConnect = this.getProperty("wait_for_rpm_connect", true);

    public AgentConfig(File configFile) throws Exception {
        this(new FileInputStream(configFile), AgentConfig.getEnvironment());
    }

    public AgentConfig(File configFile, AgentConfig oldConfig) throws Exception {
        this(new FileInputStream(configFile), AgentConfig.getEnvironment());
    }

    public AgentConfig(Map config) {
        super(new HashMap(config), "newrelic.config");
        this.appNames = Collections.unmodifiableList(this.initalizeAppNames());
        this.appName = this.appNames.isEmpty() ? null : this.appNames.get(0);
        this.debug = Boolean.getBoolean("newrelic.debug");
        this.customTracingEnabled = this.getProperty("enable_custom_tracing", true);
        this.reportSqlParserErrors = this.getProperty("report_sql_parser_errors", false);
        this.captureParams = this.getProperty("capture_params", false);
        this.traceDataCalls = this.getProperty("trace_data_calls", false);
        this.ignoredParams = Collections.unmodifiableSet(this.initializeIgnoredParams());
        this.threadCpuTimeEnabled = this.initThreadCPUEnabled();
        this.appRenaming = this.nestedProps(APP_RENAMING);
        Map profiler = this.nestedProps("thread_profiler");
        this.profilerConfig = new Config(profiler == null ? Collections.emptyMap() : profiler, "newrelic.config.thread_profiler");
        Map supportability = this.nestedProps("supportability");
        this.supportabilityConfig = new Config(supportability == null ? Collections.emptyMap() : supportability, "newrelic.config.supportability");
        this.transactionTraceConfig = new TransactionTracerConfig(this, this.nestedProps("transaction_tracer"));
        this.transactionTraceBuckets = this.initializeTransactionTraceBuckets(this.transactionTraceConfig);
        this.errorCollectorConfig = new ErrorCollectorConfig(this, this.nestedProps("error_collector"));
        this.maxStackTraceLines = this.getProperty("max_stack_trace_lines", 30);
        String[] jdbcSupport = this.getProperty("jdbc_support", GENERIC_JDBC_SUPPORT).split(",");
        this.jdbcSupport = new HashSet<String>(Arrays.asList(jdbcSupport));
        this.genericJdbcSupportEnabled = this.jdbcSupport.contains(GENERIC_JDBC_SUPPORT);
        this.transactionSizeLimit = this.getProperty("transaction_size_limit", 2000) * 1024;
        Map props = this.nestedProps("class_transformer");
        this.classTransformerConfig = new ClassTransformerConfig(this.isCustomTracingEnabled(), props == null ? Collections.emptyMap() : props);
    }

    private Map nestedProps(String key) {
        Object value = this.getProperties().get(key);
        if (value != null && !Map.class.isInstance(value)) {
            throw new RuntimeException("Agent configuration expected nested configuration values for " + key + ", got " + value);
        }
        return (Map)value;
    }

    private List<String> initalizeAppNames() {
        Object appName = this.getProperty(APP_NAME);
        if (appName instanceof List) {
            return (List)appName;
        }
        if (appName instanceof String) {
            return new ArrayList<String>(Strings.trim(Arrays.asList(appName.toString().split(";"))));
        }
        return Collections.emptyList();
    }

    private Set<String> initializeIgnoredParams() {
        Object ignoredParamsString = this.getProperty("ignored_params");
        if (ignoredParamsString instanceof String) {
            return new HashSet<String>(Strings.trim(Arrays.asList(ignoredParamsString.toString().split(","))));
        }
        if (ignoredParamsString instanceof Collection) {
            return new HashSet<String>((Collection)ignoredParamsString);
        }
        return Collections.emptySet();
    }

    private Map<String, TransactionTracerConfig> initializeTransactionTraceBuckets(TransactionTracerConfig rootConfig) {
        HashMap<String, TransactionTracerConfig> buckets = new HashMap<String, TransactionTracerConfig>();
        buckets.put("request", rootConfig);
        buckets.put("background", rootConfig);
        Object category = rootConfig.getProperty("category");
        if (category instanceof Collection) {
            for (Map cat : (Collection)category) {
                Object name = cat.get("name");
                if (!(name instanceof String)) continue;
                TransactionTracerConfig config = new TransactionTracerConfig(this, cat, rootConfig, "newrelic.config.transaction_tracer.category." + name);
                buckets.put(name.toString(), config);
            }
        }
        return buckets;
    }

    public AgentConfig(InputStream iStream, String env) throws Exception {
        this(AgentConfig.parseConfiguration(iStream, env));
    }

    private boolean initThreadCPUEnabled() {
        String vendor = System.getProperty("java.vendor");
        boolean defaultVal = !"IBM Corporation".equals(vendor);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        try {
            return this.getProperty("thread_cpu_time_enabled", defaultVal) != false && threadMXBean.isThreadCpuTimeEnabled();
        }
        catch (UnsupportedOperationException e) {
            Agent.LOG.finer("Thread CPU time measurement is not supported by the current JVM");
            return false;
        }
    }

    private static Yaml createYaml() {
        ExtensionConstructor constructor = new ExtensionConstructor();
        Loader loader = new Loader(constructor);
        return new Yaml(loader);
    }

    private static Map parseConfiguration(InputStream iStream, String env) throws Exception {
        try {
            Map allConfig = (Map)AgentConfig.createYaml().load(iStream);
            if (allConfig == null) {
                Agent.LOG.info("The newrelic.yml configuration file was empty");
                return Collections.emptyMap();
            }
            Map props = (Map)allConfig.get(env);
            if (props == null) {
                props = (Map)allConfig.get("common");
            }
            if (props == null) {
                throw new RuntimeException(MessageFormat.format("Unable to find configuration named {0}", env));
            }
            return props;
        }
        catch (Exception e) {
            Agent.LOG.log(Level.SEVERE, MessageFormat.format("Unable to parse configuration file: {0}", e.toString()), e);
            throw e;
        }
    }

    private static String getEnvironment() {
        String env = System.getProperty(NEWRELIC_ENVIRONMENT_SYSTEM_PROPERTY);
        env = env == null ? System.getenv("JAVA_ENV") : env;
        return env == null ? "production" : env;
    }

    public List<String> getApplicationNames() {
        return this.appNames;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public Map<String, String> getAppRenaming() {
        return this.appRenaming;
    }

    public String getLanguage() {
        return this.getProperty("language", "java");
    }

    public String getLicenseKey() {
        return (String)this.getProperty("license_key");
    }

    public String getHost() {
        return this.getProperty("host", DEFAULT_HOST);
    }

    public String getProxyHost() {
        return (String)this.getProperty("proxy_host");
    }

    public String getApiHost() {
        return this.getProperty("api_host", "rpm.newrelic.com");
    }

    public int getApiPort() {
        return this.getProperty("api_port", this.getPort());
    }

    public int getPort() {
        return this.getProperty("port", this.isSSL() ? 443 : 80);
    }

    public Integer getProxyPort() {
        return this.getProperty("proxy_port", 8080);
    }

    public boolean isCaptureParams() {
        return this.captureParams;
    }

    public boolean isReportSqlParserErrors() {
        return this.reportSqlParserErrors;
    }

    public Set<String> getIgnoredParams() {
        return this.ignoredParams;
    }

    public boolean isAgentEnabled() {
        return this.getProperty("enabled", true) != false && this.getProperty("agent_enabled", true) != false;
    }

    public boolean isSSL() {
        boolean ssl = this.getProperty("ssl", false);
        return ssl;
    }

    public boolean isCustomTracingEnabled() {
        return this.customTracingEnabled;
    }

    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    public boolean waitForRPMConnect() {
        return this.waitForRPMConnect;
    }

    public boolean isEjbTracingEnabled() {
        boolean enabled = this.getProperty("enable_ejb_tracing", false);
        return enabled;
    }

    public boolean isBootstrapClassInstrumentationEnabled() {
        boolean enabled = this.getProperty("enable_bootstrap_class_instrumentation", true);
        return enabled;
    }

    public boolean isSessionCountTrackingEnabled() {
        boolean enabled = this.getProperty("enable_session_count_tracking", false);
        return enabled;
    }

    public int getMaxStackTraceLines() {
        return this.maxStackTraceLines;
    }

    public File getCustomExtensionsDirectory() {
        File configDir;
        String configDirName = (String)this.getProperty("extensions.dir");
        if (configDirName == null) {
            configDirName = ConfigFileHelper.getNewRelicDirectory() + File.separator + "extensions";
        }
        if (!(configDir = new File(configDirName)).isDirectory()) {
            configDir = null;
        }
        return configDir;
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.transactionTraceConfig;
    }

    public TransactionTracerConfig getTransactionTracerConfig(String category) {
        TransactionTracerConfig config = this.transactionTraceBuckets.get(category);
        if (config == null) {
            return this.transactionTraceConfig;
        }
        return config;
    }

    public Map<String, TransactionTracerConfig> getTransactionTracerConfigCategories() {
        return this.transactionTraceBuckets;
    }

    public ErrorCollectorConfig getErrorCollectorConfig() {
        return this.errorCollectorConfig;
    }

    public Config getSupportabilityConfig() {
        return this.supportabilityConfig;
    }

    public Config getProfilerConfig() {
        return this.profilerConfig;
    }

    public ClassTransformerConfig getClassTransformerConfig() {
        return this.classTransformerConfig;
    }

    public Config getInstrumentationConfig() {
        return this.getConfig("instrumentation");
    }

    public Level getLogLevel() {
        Object logLevel = this.getProperty("log_level");
        if (logLevel instanceof Boolean) {
            if (((Boolean)logLevel).booleanValue()) {
                return Level.INFO;
            }
            return Level.OFF;
        }
        return AgentConfig.getLogLevel((String)logLevel);
    }

    public static Level getLogLevel(String logLevel) {
        if (logLevel == null) {
            return Level.INFO;
        }
        HashMap<String, Level> levelMap = new HashMap<String, Level>(){
            {
                this.put("info", Level.INFO);
                this.put("debug", Level.FINE);
                this.put("fine", Level.FINE);
                this.put("finer", Level.FINER);
                this.put("trace", Level.FINEST);
                this.put("finest", Level.FINEST);
                this.put("warn", Level.WARNING);
                this.put("warning", Level.WARNING);
                this.put("error", Level.SEVERE);
                this.put("severe", Level.SEVERE);
                this.put("off", Level.OFF);
            }
        };
        Level level = (Level)levelMap.get(logLevel);
        return level == null ? Level.INFO : level;
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public boolean isTraceDataCallsEnabled() {
        return this.traceDataCalls;
    }

    private Map<String, String> getNRSystemProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : new HashMap<Object, Object>(System.getProperties()).entrySet()) {
            if (!entry.getKey().toString().startsWith("newrelic.")) continue;
            props.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return props;
    }

    @Override
    public void writeJSONString(Writer writer) throws IOException {
        String buildDate;
        HashMap<String, Object> props = new HashMap<String, Object>(this.getProperties());
        Map<String, String> systemProps = this.getNRSystemProperties();
        if (!systemProps.isEmpty()) {
            props.put("system", systemProps);
        }
        if ((buildDate = AgentJarHelper.getBuildDate()) != null) {
            props.put("build_date", buildDate);
        }
        props.put("services", ServiceManagerFactory.getServiceManager().getServicesConfiguration());
        JSONObject.writeJSONString(props, writer);
    }

    public boolean isCPUSamplingEnabled() {
        return this.getProperty("cpu_sampling_enabled", true);
    }

    public boolean isThreadCPUTimeEnabled() {
        return this.threadCpuTimeEnabled;
    }

    public boolean isProfilingEnabled() {
        return this.getProfilerConfig().getProperty("enabled", false);
    }

    public Set<String> getJDBCSupport() {
        return this.jdbcSupport;
    }

    public boolean isGenericJDBCSupportEnabled() {
        return this.genericJdbcSupportEnabled;
    }

    public int getTransactionSizeLimit() {
        return this.transactionSizeLimit;
    }

    public boolean isSyncStartup() {
        return this.getProperty(SYNC_STARTUP, false);
    }

    public boolean isSendDataOnExit() {
        return this.getProperty("send_data_on_exit", false);
    }

    public int getSendDataOnExitThreshold() {
        return this.getProperty("send_data_on_exit_threshold", 60);
    }

    private static class ExtensionConstructor
    extends Constructor {
        public ExtensionConstructor() {
            this.yamlConstructors.put("!exception_handler", new Construct(){

                public Object construct(Node node) {
                    List args = ExtensionConstructor.this.constructSequence((SequenceNode)node);
                    try {
                        return new ExceptionHandlerSignature((String)args.get(0), (String)args.get(1), (String)args.get(2));
                    }
                    catch (InvalidMethodDescriptor e) {
                        return e;
                    }
                }
            });
        }
    }
}

