/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.Tracer;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionData {
    private final Collection<Tracer> tracers;
    private final Tracer rootTracer;
    private final int opcode;
    private final String requestUri;
    private final Map<String, Object> parameters;
    private final String blameMetricName;
    private final Throwable throwable;
    private final boolean traceDisabled;
    private final int responseStatus;
    private final String statusMessage;
    private final int transactionSize;
    private final long threadId;
    private final String appName;
    private final long transactionThreshold;
    private final long startTime;

    public TransactionData(Tracer tracer, int opcode, Throwable throwable, String requestUri, String frontendMetricName, Map<String, Object> parameters, Collection<Tracer> tracers, boolean traceDisabled, int responseStatus, String statusMessage, int transactionSize, long threadId, String appName, long transactionThreshold, long startTime) {
        this.tracers = tracers;
        this.throwable = throwable;
        this.rootTracer = tracer;
        this.opcode = opcode;
        this.requestUri = requestUri;
        this.blameMetricName = frontendMetricName;
        this.parameters = parameters;
        this.traceDisabled = traceDisabled;
        this.responseStatus = responseStatus;
        this.statusMessage = statusMessage;
        this.transactionSize = transactionSize;
        this.threadId = threadId;
        this.appName = appName;
        this.transactionThreshold = transactionThreshold;
        this.startTime = startTime;
    }

    public Collection<Tracer> getTracers() {
        return this.tracers;
    }

    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public final long getThreadId() {
        return this.threadId;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public long getTransactionThreshold() {
        return this.transactionThreshold;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getBlameMetricName() {
        return this.blameMetricName;
    }

    public String getBlameOrRootMetricName() {
        return this.blameMetricName == null ? this.rootTracer.getMetricName() : this.blameMetricName;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected final int getTransactionSize() {
        return this.transactionSize;
    }

    public long getDuration() {
        return this.rootTracer.getDurationInMilliseconds();
    }

    public String getFrontendApdexMetricName() {
        if (this.blameMetricName != null && this.blameMetricName.indexOf("WebTransaction") == 0) {
            return "Apdex" + this.blameMetricName.substring("WebTransaction".length());
        }
        return null;
    }

    public boolean isTraceDisabled() {
        return this.traceDisabled;
    }

    public String toString() {
        String name = this.requestUri == null ? this.rootTracer.getMetricName() : this.requestUri;
        StringBuilder builder = new StringBuilder(name == null ? "" : name).append(' ').append(this.getDuration()).append("ms");
        if (this.throwable != null) {
            builder.append(' ').append(this.throwable.getMessage());
        }
        return builder.toString();
    }

    public boolean isWebTransaction() {
        return this.rootTracer instanceof RequestDispatcherTracer;
    }
}

