/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreRequestException;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.TransactionData;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.TransactionTracerConfig;
import com.newrelic.agent.errors.StackTraceError;
import com.newrelic.agent.normalization.URLNormalizer;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.trace.TransactionTraceService;
import com.newrelic.agent.tracers.DispatcherTracer;
import com.newrelic.agent.tracers.IOTracer;
import com.newrelic.agent.tracers.OtherDispatcherTracer;
import com.newrelic.agent.tracers.RequestDispatcherTracer;
import com.newrelic.agent.tracers.SkipTracer;
import com.newrelic.agent.tracers.Tracer;
import com.newrelic.agent.util.StackTraces;
import com.newrelic.org.apache.commons.collections.ArrayStack;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Transaction {
    private static final String SOLR_CACHE = "SOLR_CACHE";
    public static final String SIZE_LIMIT_PARAMETER_NAME = "size_limit";
    private static final int INITIAL_PARAMETER_MAP_SIZE = 8;
    private static final int INITIAL_OBJECT_MAP_SIZE = 4;
    public static final String CPU_TIME_PARAMETER_NAME = "cpu_time";
    public static final String GC_TIME_PARAMETER_NAME = "gc_time";
    private static final ThreadLocal<Transaction> transactionHolder = new ThreadLocal<Transaction>(){

        @Override
        public Transaction get() {
            Transaction tx = (Transaction)super.get();
            return tx;
        }

        @Override
        protected Transaction initialValue() {
            Transaction tx = new Transaction();
            ServiceManagerFactory.getServiceManager().getTransactionService().addTransaction(tx);
            return tx;
        }

        @Override
        public void remove() {
            ServiceManagerFactory.getServiceManager().getTransactionService().removeTransaction();
            super.remove();
        }

        @Override
        public void set(Transaction value) {
            super.set(value);
            ServiceManagerFactory.getServiceManager().getTransactionService().addTransaction(value);
        }
    };
    private final ArrayStack<Tracer> callStack;
    private List<Tracer> tracers;
    private final Map<String, Object> parameters;
    private final Map<String, Map> objectMaps;
    private String applicationName;
    private final long threadId;
    private final long startTime;
    private final long cpuStartTimeInNanos;
    private final long startGCTimeInMillis;
    private volatile boolean reportedStall = false;
    private boolean traceDisabled = false;
    private String normalizedUri;
    private Throwable throwable;
    private int stackTraceCount;
    private int explainPlanCount;
    private int transactionSize = 0;
    private int responseStatus;
    private String statusMessage;
    private boolean ignore = false;
    private final IAgent agent;
    private final AgentConfig agentConfig;
    private final boolean ttEnabled;
    private final int transactionSizeLimit;
    private int segmentCount = 0;
    private boolean overTracerSegmentLimit = false;
    private boolean stackReset = false;
    private Tracer rootTracer;
    private TransactionTracerConfig transactionTracerConfig;
    private final boolean autoAppNamingEnabled;

    public Transaction() {
        ServiceManager serviceManager = ServiceManagerFactory.getServiceManager();
        this.agentConfig = serviceManager.getConfigService().getAgentConfig();
        this.agent = serviceManager.getAgent();
        this.autoAppNamingEnabled = this.agentConfig.isAutoAppNamingEnabled();
        this.transactionTracerConfig = this.agentConfig.getTransactionTracerConfig();
        this.ttEnabled = ServiceManagerFactory.getServiceManager().getTransactionTraceService().isEnabled();
        this.transactionSizeLimit = this.agentConfig.getTransactionSizeLimit();
        this.objectMaps = new HashMap<String, Map>(4);
        this.callStack = new ArrayStack(16);
        this.parameters = new HashMap<String, Object>(8);
        this.tracers = new ArrayList<Tracer>(512);
        Thread thread = Thread.currentThread();
        this.threadId = thread.getId();
        this.parameters.put("thread_name", thread.getName());
        this.startTime = System.currentTimeMillis();
        if (this.ttEnabled) {
            if (this.agentConfig.isThreadCPUTimeEnabled()) {
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                this.cpuStartTimeInNanos = threadMXBean.getCurrentThreadCpuTime();
            } else {
                this.cpuStartTimeInNanos = 0L;
            }
            this.startGCTimeInMillis = this.transactionTracerConfig.isGCTimeEnabled() ? this.getGCTime() : 0L;
        } else {
            this.startGCTimeInMillis = 0L;
            this.cpuStartTimeInNanos = 0L;
        }
    }

    private long getGCTime() {
        long gcTime = 0L;
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            gcTime += gcBean.getCollectionTime();
        }
        return gcTime;
    }

    public void reportAsStall() {
        if (!this.reportedStall && !this.ignore) {
            this.reportedStall = true;
            this.reportStall(this.threadId, this.getRootTracer(), this.getLastTracer());
        }
    }

    private void reportStall(long executionThreadId, Tracer rootTracer, Tracer topTracer) {
        if (rootTracer == null) {
            return;
        }
        if (Agent.isDebugEnabled() || rootTracer instanceof RequestDispatcherTracer) {
            StackTraceElement[] stackTrace = StackTraces.getThreadStackTraceElements(executionThreadId);
            if (stackTrace == null || stackTrace.length == 0) {
                return;
            }
            List<StackTraceElement> stackTraces = StackTraces.scrubAndTruncate(stackTrace);
            HashMap<String, String> parameters = new HashMap<String, String>();
            if (rootTracer != null) {
                parameters.put("root_tracer_class", rootTracer.getClass().getName());
            }
            StringBuilder message = new StringBuilder("Stall");
            if (topTracer != null) {
                String metricName = topTracer.getMetricName();
                if (metricName != null) {
                    message.append(" in ").append(metricName);
                }
                parameters.put("current_tracer_class", topTracer.getClass().getName());
            }
            String requestUri = rootTracer instanceof RequestDispatcherTracer ? ((RequestDispatcherTracer)rootTracer).getRequestURI() : rootTracer.getMetricName();
            StackTraceError error = new StackTraceError(requestUri, message.toString(), "Stall", stackTraces.toArray(new StackTraceElement[0]), requestUri, parameters);
            this.getRPMService().getErrorService().reportError(error);
        }
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public AgentConfig getAgentConfig() {
        return this.agentConfig;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public TransactionTracerConfig getTransactionTracerConfig() {
        return this.transactionTracerConfig;
    }

    public int getStackTraceCount() {
        return this.stackTraceCount;
    }

    public void incrementStackTraceCount() {
        ++this.stackTraceCount;
    }

    public int getExplainPlanCount() {
        return this.explainPlanCount;
    }

    public void incrementExplainPlanCount() {
        ++this.explainPlanCount;
    }

    public <K, V> Map<K, V> getObjectMap(String key) {
        HashMap map = this.objectMaps.get(key);
        if (map == null) {
            map = new HashMap();
            this.objectMaps.put(key, map);
        }
        return map;
    }

    public Map<String, Method> getMethodCache() {
        return this.getObjectMap("METHOD_CACHE");
    }

    public Map<String, Object> getSolrCache() {
        return this.getObjectMap(SOLR_CACHE);
    }

    public Tracer getRootTracer() {
        return this.rootTracer;
    }

    public boolean isTracerStackEmpty() {
        return this.callStack.isEmpty();
    }

    public Tracer getLastTracer() {
        return this.callStack.isEmpty() ? null : this.callStack.peek();
    }

    public Tracer tracerStarted(Tracer tracer) {
        if (this.reportedStall && this.tracers == null) {
            return null;
        }
        if (this.isTracerStackEmpty()) {
            if (tracer instanceof IOTracer) {
                return null;
            }
            if (!(tracer instanceof DispatcherTracer)) {
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Non-dispatcher tracer of type {0} at the top of a transaction stack", tracer.getClass().getName());
                    Agent.LOG.log(Level.FINEST, "Invalid top level stack item", new Exception());
                }
                return null;
            }
            this.setRootTracer(tracer);
        } else if (tracer instanceof RequestDispatcherTracer && !(this.rootTracer instanceof RequestDispatcherTracer)) {
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, "Encountered a RequestDispatcherTracer that is not the transaction root.  There are {0} tracer(s) on the stack that will be cleared.  The topmost tracer is of type {1}", new Object[]{this.callStack.size(), this.getLastTracer().getClass().getName()});
                if (Agent.LOG.isLoggable(Level.FINEST)) {
                    Agent.LOG.log(Level.FINEST, "Non-root RequestDispatcherTracer", StackTraces.createStackTraceException("Tracer stack error"));
                }
            }
            this.reset();
            this.setRootTracer(tracer);
        }
        this.callStack.push(tracer);
        boolean increment = false;
        if (tracer.isMetricProducer()) {
            this.tracers.add(tracer);
            increment = true;
        }
        if (tracer.isTransactionSegment()) {
            ++this.segmentCount;
            this.overTracerSegmentLimit = this.segmentCount > this.transactionTracerConfig.getMaxSegments();
            increment = true;
        }
        if (increment) {
            this.incrementSize(128);
        }
        return tracer;
    }

    private void setRootTracer(Tracer tracer) {
        this.rootTracer = tracer;
        TransactionTraceService transactionTraceService = ServiceManagerFactory.getServiceManager().getTransactionTraceService();
        this.transactionTracerConfig = transactionTraceService.getTransactionTraceConfig(tracer);
    }

    public void tracerFinished(Tracer tracer, int opcode) {
        Tracer lastTracer;
        if (tracer instanceof SkipTracer) {
            return;
        }
        Tracer tracer2 = lastTracer = this.callStack.isEmpty() ? null : this.callStack.pop();
        if (tracer == lastTracer) {
            if (this.callStack.isEmpty()) {
                this.finished(tracer, opcode);
            }
        } else {
            Agent.LOG.log(this.stackReset ? Level.FINER : Level.SEVERE, "The tracer stack is inconsistent {0} / {1}", new Object[]{tracer.getClass().getName(), lastTracer == null ? "None" : lastTracer.getClass().getName()});
            this.release();
            Transaction.clearTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finished(Tracer tracer, int opcode) {
        try {
            IRPMService rpmService = this.getRPMService();
            String requestURI = tracer.getMetricName();
            boolean isRequestTransaction = false;
            Throwable reportError = this.throwable;
            if (tracer instanceof RequestDispatcherTracer) {
                if (this.agentConfig.waitForRPMConnect() && !rpmService.hasEverConnected()) {
                    return;
                }
                requestURI = ((RequestDispatcherTracer)tracer).getRequestURI();
                isRequestTransaction = true;
                reportError = ((RequestDispatcherTracer)tracer).getReportError(this.throwable);
            } else if (tracer instanceof OtherDispatcherTracer) {
                requestURI = ((OtherDispatcherTracer)tracer).getDispatcherUri();
            }
            if (this.ignore) {
                Agent.LOG.log(Level.FINE, "Ignoring transaction {0}", requestURI);
                return;
            }
            this.recordCpuAndGCTime(tracer);
            if (Agent.isDebugEnabled()) {
                Agent.LOG.log(Level.FINER, "Transaction{4} finished {0}ms {1}{2} for {3}", new Object[]{tracer.getDurationInMilliseconds(), tracer.getParameters(), opcode == 191 ? " with error" : "", requestURI, tracer instanceof DispatcherTracer ? "(dispatch)" : ""});
            }
            if (ServiceManagerFactory.getServiceManager().isStarted()) {
                TransactionNamer txNamer = Transaction.getTransactionNamer(this.rootTracer, isRequestTransaction, requestURI, this.normalizedUri, this.responseStatus, rpmService.getURLNormalizer());
                if (this.isOverTracerSegmentLimit()) {
                    this.parameters.put("segment_clamp", this.segmentCount);
                }
                if (this.isOverSizeLimit()) {
                    this.parameters.put(SIZE_LIMIT_PARAMETER_NAME, "The transaction size limit was reached");
                }
                if (this.stackTraceCount >= this.transactionTracerConfig.getMaxStackTraces()) {
                    this.parameters.put("stack_trace_clamp", this.stackTraceCount);
                }
                if (this.explainPlanCount >= this.transactionTracerConfig.getMaxExplainPlans()) {
                    this.parameters.put("explain_plan_clamp", this.explainPlanCount);
                }
                if (this.responseStatus > 0) {
                    this.parameters.put("http_status", this.responseStatus);
                }
                if (this.statusMessage != null) {
                    this.parameters.put("http_status_message", this.statusMessage);
                }
                long transactionThreshold = this.getTransactionThreshold();
                TransactionData transactionData = new TransactionData(tracer, opcode, reportError, requestURI, txNamer.getBlameMetricName(), new HashMap<String, Object>(this.parameters), this.tracers, this.isTraceDisabled(), this.responseStatus, this.statusMessage, this.transactionSize, this.threadId, rpmService.getApplicationName(), transactionThreshold, this.getStartTime());
                ServiceManagerFactory.getServiceManager().getTransactionService().processTransaction(rpmService, transactionData);
            }
        }
        catch (IgnoreRequestException e) {
            Agent.LOG.finer(e.getMessage());
        }
        finally {
            Transaction.clearTransaction();
            this.release();
        }
    }

    private void recordCpuAndGCTime(Tracer tracer) {
        TransactionTraceService transactionTraceService = ServiceManagerFactory.getServiceManager().getTransactionTraceService();
        if (!transactionTraceService.isEnabled()) {
            return;
        }
        if (tracer.getDurationInMilliseconds() > this.getTransactionThreshold()) {
            long gcTime;
            if (this.cpuStartTimeInNanos > 0L) {
                long cpuTime = transactionTraceService.getThreadMXBean().getCurrentThreadCpuTime() - this.cpuStartTimeInNanos;
                this.parameters.put(CPU_TIME_PARAMETER_NAME, cpuTime);
            }
            if (this.startGCTimeInMillis > 0L && (gcTime = this.getGCTime()) != this.startGCTimeInMillis) {
                this.parameters.put(GC_TIME_PARAMETER_NAME, gcTime - this.startGCTimeInMillis);
            }
        }
    }

    public boolean isAutoAppNamingEnabled() {
        return this.autoAppNamingEnabled;
    }

    private IRPMService getRPMService() {
        return ServiceManagerFactory.getServiceManager().getRPMServiceManager().getOrCreateRPMService(this.getApplicationName());
    }

    public long getTransactionThreshold() {
        return this.transactionTracerConfig.getTransactionThreshold(this.getRPMService().getApdexTInMillis());
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String appName) {
        this.applicationName = appName.intern();
    }

    public boolean isTraceDisabled() {
        return this.traceDisabled;
    }

    public void setTraceDisabled(boolean traceDisabled) {
        this.traceDisabled = traceDisabled;
    }

    public static void clearTransaction() {
        transactionHolder.remove();
    }

    private void release() {
        this.tracers = null;
        this.parameters.clear();
        this.objectMaps.clear();
        this.callStack.clear();
        this.throwable = null;
    }

    private void reset() {
        this.release();
        this.stackReset = true;
        this.tracers = new ArrayList<Tracer>(512);
    }

    public static Transaction getTransaction() {
        Transaction transaction = transactionHolder.get();
        return transaction;
    }

    public void setNormalizedUri(String normalizedUri) {
        this.normalizedUri = normalizedUri;
    }

    public String getNormalizedUri() {
        return this.normalizedUri;
    }

    public void setStatus(int status) {
        if (this.responseStatus < 400) {
            this.responseStatus = status;
        }
    }

    public int getStatus() {
        return this.responseStatus;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String message) {
        if (message != null) {
            this.statusMessage = message;
        }
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public boolean isOverTracerSegmentLimit() {
        return this.overTracerSegmentLimit;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public void incrementSize(int size) {
        this.transactionSize += size;
    }

    public boolean isOverSizeLimit() {
        return this.transactionSize > this.transactionSizeLimit;
    }

    public boolean shouldGenerateTransactionSegment() {
        return this.ttEnabled && !this.isOverTracerSegmentLimit();
    }

    private static TransactionNamer getTransactionNamer(Tracer rootTracer, boolean isRequestTransaction, String requestURI, String normalizedUri, int responseStatus, URLNormalizer urlNormalizer) throws IgnoreRequestException {
        if (isRequestTransaction) {
            return new RequestTransactionNamer(urlNormalizer, requestURI, normalizedUri, responseStatus);
        }
        return new OtherTransactionNamer(requestURI, normalizedUri);
    }

    static class RequestTransactionNamer
    implements TransactionNamer {
        private String metricRootName = "WebTransaction/Uri";
        private final String normalizedUri;

        public RequestTransactionNamer(URLNormalizer urlNormalizer, String requestURI, String normalizedURI, int responseStatus) throws IgnoreRequestException {
            this.normalizedUri = normalizedURI != null ? normalizedURI : this.normalizeUri(requestURI, responseStatus, urlNormalizer);
        }

        public String getBlameMetricName() {
            if (this.normalizedUri == null) {
                return "WebTransaction/Uri/Unknown";
            }
            if (this.normalizedUri.length() == 0 || "/".equals(this.normalizedUri)) {
                return this.metricRootName + "/ROOT";
            }
            if (this.normalizedUri.startsWith("WebTransaction")) {
                return this.normalizedUri;
            }
            return this.metricRootName + this.normalizedUri;
        }

        private String normalizeUri(String requestUri, int responseStatus, URLNormalizer urlNormalizer) throws IgnoreRequestException {
            String uri;
            if (responseStatus == 414 || responseStatus > 400 && responseStatus < 405) {
                uri = this.normalizeUrlWithStatus(responseStatus);
            } else if (requestUri != null) {
                try {
                    uri = urlNormalizer.normalizeURL(requestUri);
                    if (!uri.equals(requestUri)) {
                        this.metricRootName = "WebTransaction/NormalizedUri";
                    }
                }
                catch (IgnoreRequestException ire) {
                    throw ire;
                }
                catch (Throwable t) {
                    Agent.LOG.log(Level.FINE, "An error occurred normalizing url \"{0}\" : {1}", new Object[]{requestUri, t.toString()});
                    Agent.LOG.log(Level.FINER, "URL normalization error", t);
                    return null;
                }
                if (responseStatus >= 400 && !MetricSpec.exists("WebTransaction/Uri" + requestUri, null)) {
                    uri = this.normalizeUrlWithStatus(responseStatus);
                }
            } else {
                return null;
            }
            return uri;
        }

        private String normalizeUrlWithStatus(int responseStatus) {
            return "/" + responseStatus + "/*";
        }
    }

    private static class OtherTransactionNamer
    implements TransactionNamer {
        private final String dispatcherUri;
        private final String normalizedUri;

        public OtherTransactionNamer(String dispatcherUri, String normalizedUri) {
            this.dispatcherUri = dispatcherUri;
            this.normalizedUri = normalizedUri;
        }

        public String getBlameMetricName() {
            return null == this.normalizedUri ? this.dispatcherUri : this.normalizedUri;
        }
    }

    static interface TransactionNamer {
        public String getBlameMetricName();
    }
}

