/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadService
extends AbstractService {
    private static final String THREAD_SERVICE_THREAD_NAME = "New Relic Thread Service";
    private static final long INITIAL_DELAY_IN_SECONDS = 300L;
    private static final long SUBSEQUENT_DELAY_IN_SECONDS = 300L;
    private volatile ScheduledExecutorService scheduledExecutor;
    private volatile ScheduledFuture<?> deadThreadsTask;
    private final Set<Long> agentThreadIds;
    private final Set<Long> requestThreadIds;
    private final Set<Long> backgroundThreadIds;
    private final ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();

    public ThreadService() {
        super(ThreadService.class.getSimpleName());
        this.agentThreadIds = Collections.synchronizedSet(new HashSet());
        this.requestThreadIds = Collections.synchronizedSet(new HashSet());
        this.backgroundThreadIds = Collections.synchronizedSet(new HashSet());
    }

    @Override
    protected void doStart() {
        if (this.threadMXBean == null) {
            return;
        }
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(THREAD_SERVICE_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        Runnable runnable = new Runnable(){

            public void run() {
                ThreadService.this.detectDeadThreads();
            }
        };
        this.deadThreadsTask = this.scheduledExecutor.scheduleWithFixedDelay(runnable, 300L, 300L, TimeUnit.SECONDS);
    }

    @Override
    protected void doStop() {
        if (this.deadThreadsTask != null) {
            this.deadThreadsTask.cancel(false);
        }
    }

    protected void detectDeadThreads() {
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        ArrayList<Long> ids = new ArrayList<Long>(threadIds.length);
        for (long threadId : threadIds) {
            ids.add(threadId);
        }
        this.requestThreadIds.retainAll(ids);
        this.backgroundThreadIds.retainAll(ids);
        this.agentThreadIds.retainAll(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getRequestThreadIds() {
        HashSet<Long> result;
        Set<Long> set = this.requestThreadIds;
        synchronized (set) {
            result = new HashSet<Long>(this.requestThreadIds);
        }
        return Collections.unmodifiableSet(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getBackgroundThreadIds() {
        HashSet<Long> result;
        Set<Long> set = this.backgroundThreadIds;
        synchronized (set) {
            result = new HashSet<Long>(this.backgroundThreadIds);
        }
        return Collections.unmodifiableSet(result);
    }

    public void noticeRequestThread(Long threadId) {
        this.requestThreadIds.add(threadId);
    }

    public void noticeBackgroundThread(Long threadId) {
        this.backgroundThreadIds.add(threadId);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public boolean isAgentThreadId(Long threadId) {
        return this.agentThreadIds.contains(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getAgentThreadIds() {
        HashSet<Long> result;
        Set<Long> set = this.agentThreadIds;
        synchronized (set) {
            result = new HashSet<Long>(this.agentThreadIds);
        }
        return Collections.unmodifiableSet(result);
    }

    public void registerAgentThreadId(long id) {
        this.agentThreadIds.add(id);
    }
}

