/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentMessage;
import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.Environment;
import com.newrelic.agent.ForceDisconnectException;
import com.newrelic.agent.ForceRestartException;
import com.newrelic.agent.HttpError;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.InternalLimitExceeded;
import com.newrelic.agent.LicenseException;
import com.newrelic.agent.MetricData;
import com.newrelic.agent.MetricDataException;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.RPMServiceException;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.Hostname;
import com.newrelic.agent.errors.ErrorService;
import com.newrelic.agent.errors.TracedError;
import com.newrelic.agent.normalization.URLNormalizer;
import com.newrelic.agent.profile.Profile;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.session.SessionService;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.Stats;
import com.newrelic.agent.stats.StatsEngine;
import com.newrelic.agent.stats.StatsEngineImpl;
import com.newrelic.agent.trace.TransactionTrace;
import com.newrelic.agent.util.JSON;
import com.newrelic.agent.util.RubyConversion;
import com.newrelic.agent.validation.TokenValidation;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONObject;
import com.newrelic.org.json.simple.parser.JSONParser;
import com.newrelic.org.json.simple.parser.ParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.UnexpectedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPMService
extends AbstractService
implements IRPMService,
ConnectionListener {
    private static final String COLLECT_TRACES_KEY = "collect_traces";
    private static final String COLLECT_ERRORS_KEY = "collect_errors";
    private static final String AGENT_RUN_ID_KEY = "agent_run_id";
    private static final String APDEX_T_KEY = "apdex_t";
    private static final String DATA_REPORT_PERIOD_KEY = "data_report_period";
    private static final long DEFAULT_APDEX_T = 1000L;
    static final String SUPPORTABILITY_METRIC_HARVEST_TRANSMIT = "Supportability/MetricHarvest/transmit";
    private static final String GZIP = "gzip";
    private static final int PROTOCOL_VERSION = 9;
    public static final int DEFAULT_REQUEST_TIMEOUT_IN_SECONDS = 120;
    private static final int MESSAGE_LIMIT_PER_PERIOD = 20;
    private static final int NO_AGENT_RUN_ID = 0;
    private String licenseKey;
    private volatile int agentRunID = 0;
    private volatile long apdexT;
    private final StatsEngineImpl statsEngine = new StatsEngineImpl();
    private String host;
    private int port;
    private String protocol;
    private volatile boolean connected;
    private final ErrorService errorService;
    private long lastReportTime;
    private final Proxy proxy;
    private final List<AgentMessage> messageQueue;
    private final SessionService sessionService;
    private int requestTimeoutInMillis = 120000;
    private Environment launchEnvironment;
    private long dataReportPeriodInMillis = 60000L;
    private int numInstancesConnected = 1;
    private final String appName;
    private final URLNormalizer urlNormalizer;
    private final ConnectionListener connectionListener;
    private final boolean isMainApp;
    private volatile boolean hasEverConnected = false;

    public RPMService(String applicationName, ConnectionListener connectionListener) {
        super(RPMService.class.getSimpleName() + "/" + applicationName);
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.appName = applicationName.intern();
        this.connectionListener = connectionListener;
        this.messageQueue = Collections.synchronizedList(new LinkedList());
        this.lastReportTime = System.currentTimeMillis();
        this.errorService = new ErrorService(this.appName);
        this.sessionService = new SessionService();
        this.urlNormalizer = new URLNormalizer(config, this.appName);
        this.licenseKey = config.getLicenseKey();
        this.host = config.getHost();
        this.port = config.getPort();
        this.protocol = config.isSSL() ? "https" : "http";
        this.requestTimeoutInMillis = config.getProperty("timeout", 120) * 1000;
        this.isMainApp = applicationName.equals(config.getApplicationName());
        String proxyHost = config.getProxyHost();
        Integer proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort != null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, (int)proxyPort));
            Agent.LOG.log(Level.FINE, "Using proxy host {0}:{1}", new Object[]{proxyHost, Integer.toString(proxyPort)});
        } else {
            this.proxy = null;
        }
        this.apdexT = 1000L;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
        this.connect();
    }

    @Override
    public void connected(IRPMService rpmService, Map<String, Object> connectionInfo) {
    }

    @Override
    public void disconnected(IRPMService rpmService) {
    }

    private Map<String, Object> getStartOptions() {
        ServiceManager serviceManager = ServiceManagerFactory.getServiceManager();
        AgentConfig agentConfig = serviceManager.getConfigService().getAgentConfig();
        int pid = ServiceManagerFactory.getServiceManager().getEnvironmentService().getProcessPID();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("pid", pid);
        options.put("language", agentConfig.getLanguage());
        options.put("host", Hostname.getHostname(Agent.LOG));
        Environment environment = ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment();
        try {
            this.launchEnvironment = environment.clone();
        }
        catch (CloneNotSupportedException e) {
            Agent.LOG.log(Level.FINER, "Environment clone error", e);
        }
        options.put("environment", environment);
        if (agentConfig.getProperty("send_environment_info", true).booleanValue()) {
            options.put("settings", agentConfig);
        }
        HashMap<String, String> validationOptions = new HashMap<String, String>();
        try {
            String seed = TokenValidation.getSeed();
            Agent.LOG.finer(MessageFormat.format("Using seed {0} for token validation", seed));
            validationOptions.put("seed", seed);
        }
        catch (UnknownHostException e) {
            Agent.LOG.log(Level.WARNING, "Exception while retrieving IP address for token validation seed", e);
        }
        validationOptions.put("validate", TokenValidation.getTokenFromEnvironment());
        options.put("validate", validationOptions);
        options.put("agent_version", Agent.getVersion());
        List<String> appNames = null;
        if (this.isMainApp()) {
            appNames = agentConfig.getApplicationNames();
        } else {
            appNames = new ArrayList<String>(1);
            appNames.add(this.appName);
        }
        options.put("app_name", appNames);
        StringBuilder identifier = new StringBuilder("java");
        identifier.append(':').append(this.appName);
        if (environment.getServerPort() != null) {
            identifier.append(':').append(environment.getServerPort());
        }
        options.put("identifier", identifier.toString());
        return options;
    }

    @Override
    public synchronized void launch() throws Exception {
        Boolean wrapNumbers;
        if (this.isConnected()) {
            return;
        }
        this.getRedirectHost();
        Object responseValue = this.invokeRemote("connect", this.getStartOptions());
        if (!(responseValue instanceof Map)) {
            throw new UnexpectedException(MessageFormat.format("Expected an array of connection data, got {0}", responseValue));
        }
        Map data = (Map)responseValue;
        Agent.LOG.log(Level.FINER, "Connection response : {0}", data);
        List<String> requiredParams = Arrays.asList(APDEX_T_KEY, AGENT_RUN_ID_KEY, COLLECT_ERRORS_KEY, COLLECT_TRACES_KEY, DATA_REPORT_PERIOD_KEY);
        if (!data.keySet().containsAll(requiredParams)) {
            throw new UnexpectedException(MessageFormat.format("Missing the following connection parameters", requiredParams.removeAll(data.keySet())));
        }
        this.agentRunID = ((Long)data.get(AGENT_RUN_ID_KEY)).intValue();
        Agent.LOG.log(Level.INFO, "Agent {0} connected to {1}", new Object[]{this.toString(), this.getHostString()});
        Agent.LOG.log(Level.FINE, "Agent run id: {0}", Long.toString(this.agentRunID));
        this.dataReportPeriodInMillis = (Long)data.get(DATA_REPORT_PERIOD_KEY) * 1000L;
        Boolean shouldCollectSamples = (Boolean)data.get(COLLECT_TRACES_KEY);
        Boolean errorsEnabled = (Boolean)data.get(COLLECT_ERRORS_KEY);
        ServiceManagerFactory.getServiceManager().getTransactionTraceService().setEnabled(shouldCollectSamples);
        this.errorService.setEnabled(errorsEnabled);
        this.initializeAdpexT(data);
        this.getUrlRules(data);
        if (ServiceManagerFactory.getServiceManager().getTransactionTraceService().isEnabled()) {
            Agent.LOG.info("Transaction traces will be sent to the RPM service");
        }
        if (this.errorService.isEnabled()) {
            Agent.LOG.info("Errors will be sent to the RPM service");
        }
        this.statsEngine.setWrapNumbersForSerialization((wrapNumbers = (Boolean)data.get("wrap_numbers")) != null && wrapNumbers != false);
        this.connected = true;
        this.hasEverConnected = true;
        if (this.connectionListener != null) {
            this.connectionListener.connected(this, data);
        }
    }

    private void getRedirectHost() throws Exception {
        Object redirectHost = this.invokeRemote("get_redirect_host", new Object[0]);
        if (redirectHost != null) {
            this.host = redirectHost.toString();
            Agent.LOG.log(Level.INFO, "Collector redirection to {0}", this.getHostString());
        }
    }

    @Override
    public synchronized void reconnect() {
        Agent.LOG.info(MessageFormat.format("{0} is reconnecting", this.getApplicationName()));
        try {
            this.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServiceManagerFactory.getServiceManager().getRPMConnectionService().connectImmediate(this);
    }

    @Override
    public void setApplicationServerPort(Integer port) {
        Environment env = ServiceManagerFactory.getServiceManager().getEnvironmentService().getEnvironment();
        if (env.getServerPort() == null) {
            Agent.LOG.finer("Application server port: " + port);
            env.setServerPort(port);
            if (this.launchEnvironment != null && this.launchEnvironment.getServerPort() == null) {
                Agent.LOG.log(Level.INFO, "The agent recognized the application server port {0} after connecting to the RPM service.  Reconnecting..", String.valueOf(port));
                this.reconnect();
            }
        } else {
            Agent.LOG.finest("Application server port already set, not changing it to port " + port);
        }
    }

    @Override
    public String getHostString() {
        return MessageFormat.format("{0}:{1}", this.host, Integer.toString(this.port));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(ManagementFactory.getRuntimeMXBean().getName());
        builder.append('/').append(this.appName);
        return builder.toString();
    }

    List<MetricSpec> sendMetricData(long beginTimeMillis, long endTimeMillis, List<MetricData> metricData) throws Exception {
        Object response = this.invokeRemote("metric_data", this.agentRunID, beginTimeMillis / 1000L, endTimeMillis / 1000L, metricData);
        if (response == null) {
            throw new MetricDataException("Received a null response sending metric data");
        }
        if (!(response instanceof List)) {
            throw new UnexpectedException(MessageFormat.format("Unexpected response while sending metric data: {0}", response));
        }
        List idsToMetricSpecs = (List)response;
        if (idsToMetricSpecs.size() > 0) {
            Agent.LOG.finer("metric data response: " + idsToMetricSpecs);
        }
        ArrayList<MetricSpec> specs = new ArrayList<MetricSpec>(idsToMetricSpecs.size());
        try {
            for (List keyValue : idsToMetricSpecs) {
                if (keyValue.size() == 2) {
                    // empty if block
                }
                Iterator iter = keyValue.iterator();
                JSONObject metricSpecObj = (JSONObject)iter.next();
                Long id = (Long)iter.next();
                String scope = metricSpecObj.keySet().contains("scope") ? metricSpecObj.get("scope") : null;
                MetricSpec metricSpec = MetricSpec.lookup((String)metricSpecObj.get("name"), scope);
                metricSpec.setMetricId(id.intValue());
                specs.add(metricSpec);
            }
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "An error occurred parsing metric specs : {0}", e.toString());
            Agent.LOG.log(Level.FINER, "Metric data response parse error", e);
        }
        return specs;
    }

    private void sendTracedErrors(Collection<TracedError> errors) {
        try {
            if (errors.size() > 0) {
                this.sendErrorData(errors);
            }
        }
        catch (IgnoreSilentlyException e) {
        }
        catch (Exception e) {
            Agent.LOG.severe("Unable to send error data: " + e.getMessage());
            Agent.LOG.log(Level.FINER, "Problem sending error data", e);
        }
    }

    @Override
    public List<Long> sendProfileData(List<Profile> profiles) throws Exception {
        Agent.LOG.log(Level.FINER, "Sending {0} profile(s)", profiles.size());
        return (List)this.invoke("profile_data", false, this.agentRunID, profiles);
    }

    public void sendErrorData(Collection<TracedError> errors) throws Exception {
        this.invokeRemote("error_data", this.agentRunID, errors);
    }

    @Override
    public void sendTransactionTraceData(Collection<TransactionTrace> traces) throws Exception {
        if (traces.isEmpty()) {
            return;
        }
        ArrayList<TransactionTrace> list = new ArrayList<TransactionTrace>(traces.size());
        for (TransactionTrace trace : traces) {
            list.add(trace);
        }
        Agent.LOG.log(Level.FINE, "Sending {0} trace(s)", traces.size());
        Object response = this.invoke("transaction_sample_data", false, this.agentRunID, list);
        if (response != null) {
            Agent.LOG.log(Level.SEVERE, "(Transaction Trace) The server responded with an error: {0}", response);
        }
    }

    @Override
    public void logAndQueueMessages(Level level, AgentMessage ... messages) {
        for (AgentMessage message : messages) {
            Agent.LOG.log(level, message.getTitle());
        }
        this.queueMessages(messages);
    }

    @Override
    public void queueMessages(AgentMessage ... messages) {
        this.messageQueue.addAll(Arrays.asList(messages));
    }

    void sendMessageData(AgentMessage ... messages) throws Exception {
        if (messages.length == 0 || !this.connected) {
            return;
        }
        this.invokeRemote("message_data", this.agentRunID, Arrays.asList(RPMService.truncateMessages(messages)));
    }

    static AgentMessage[] truncateMessages(AgentMessage ... messages) {
        if (messages.length > 20) {
            AgentMessage[] truncatedMessages = new AgentMessage[20];
            System.arraycopy(messages, 0, truncatedMessages, 0, 20);
            return truncatedMessages;
        }
        return messages;
    }

    @Override
    public long getDataReportPeriod() {
        return this.dataReportPeriodInMillis;
    }

    @Override
    public ErrorService getErrorService() {
        return this.errorService;
    }

    @Override
    public URLNormalizer getURLNormalizer() {
        return this.urlNormalizer;
    }

    @Override
    public String getApplicationName() {
        return this.appName;
    }

    @Override
    public boolean isMainApp() {
        return this.isMainApp;
    }

    @Override
    public long getApdexTInMillis() {
        return this.apdexT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() throws Exception {
        block6: {
            try {
                if (this.agentRunID <= 0) break block6;
                this.sendMessagesFromQueue();
                int timeout = this.requestTimeoutInMillis;
                try {
                    this.requestTimeoutInMillis = 10000;
                    this.invokeRemote("shutdown", this.agentRunID, System.currentTimeMillis());
                    this.connected = false;
                }
                finally {
                    this.requestTimeoutInMillis = timeout;
                }
            }
            finally {
                this.agentRunID = 0;
                this.resetMetricSpecsAndData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetMetricSpecsAndData() {
        MetricSpec.clear();
        Object object = this.statsEngine.getHarvestLock();
        synchronized (object) {
            this.statsEngine.clearPendingMetricData();
            this.statsEngine.resetStats();
        }
    }

    @Override
    public List<List> getAgentCommands() throws Exception {
        return (List)this.invokeRemote("get_agent_commands", this.agentRunID);
    }

    @Override
    public int getAgentRunID() {
        return this.agentRunID;
    }

    @Override
    public void sendCommandResults(Map<Long, Object> commandResults) throws Exception {
        if (commandResults.size() == 0) {
            return;
        }
        this.invokeRemote("agent_command_results", this.agentRunID, commandResults);
    }

    public void queuePingCommand() throws Exception {
        this.invokeRemote("queue_ping_command", this.agentRunID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessagesFromQueue() {
        try {
            this.sendMessageData(this.messageQueue.toArray(new AgentMessage[0]));
        }
        catch (Throwable e) {
            Agent.LOG.log(Level.FINE, "Unable to send messages", e);
        }
        finally {
            this.messageQueue.clear();
        }
    }

    public void connect() {
        ServiceManagerFactory.getServiceManager().getRPMConnectionService().connect(this);
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean hasEverConnected() {
        return this.hasEverConnected;
    }

    @Override
    public StatsEngine getStatsEngine() {
        return this.statsEngine;
    }

    public String getConnectionString() {
        String licenseKey = "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" + (this.licenseKey.length() > 30 ? this.licenseKey.substring(30) : "");
        return MessageFormat.format("{0}:{1} {2}", this.host, this.port, licenseKey);
    }

    private <T> T invokeRemote(String method, Object ... params) throws Exception {
        return this.invoke(method, true, params);
    }

    private <T> T invoke(String method, boolean deflate, Object ... params) throws Exception {
        Object val = this.invokeRemote(method, deflate, Arrays.asList(params));
        if ("null".equals(val)) {
            return null;
        }
        try {
            return (T)val;
        }
        catch (ClassCastException e) {
            Agent.LOG.log(Level.SEVERE, "Unable to cast {0} of type {1}", new Object[]{val, val.getClass().getName()});
            throw e;
        }
    }

    @Override
    public Object invokeRemote(String method, boolean deflate, String data) throws Exception {
        data = data.replace("{start_time}", Long.toString(System.currentTimeMillis() / 1000L - 120L));
        data = data.replace("{end_time}", Long.toString(System.currentTimeMillis() / 1000L));
        final String moddedData = data.replace("{agent_run_id}", Integer.toString(this.agentRunID));
        return new DataSender(){

            protected String dataToString() {
                return moddedData;
            }

            protected String getJSON() {
                return moddedData;
            }

            protected void writeData(Writer out) throws IOException {
                out.write(moddedData);
            }
        }.invokeRemote(method, deflate);
    }

    private Object invokeRemote(String method, boolean deflate, List params) throws Exception {
        return new DefaultDataSender(params).invokeRemote(method, deflate);
    }

    private Exception parseException(Object exception) {
        String message;
        if (!(exception instanceof Map)) {
            return new UnexpectedException(exception.toString());
        }
        Map map = (Map)exception;
        try {
            message = (String)map.get("message");
        }
        catch (Exception e) {
            message = exception.toString();
        }
        try {
            String type = (String)map.get("error_type");
            Class clazz = RubyConversion.rubyClassToJavaClass(type);
            Constructor constructor = clazz.getConstructor(String.class);
            return (Exception)constructor.newInstance(message);
        }
        catch (ClassNotFoundException e) {
            Agent.LOG.log(Level.FINEST, e.getMessage(), e);
            return new RuntimeException(message, e);
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINEST, e.getMessage(), e);
            return new RuntimeException(message, e);
        }
    }

    @Override
    public void setNumberInstances(int numInstances) {
        this.numInstancesConnected = numInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean harvest() throws Exception {
        this.sessionService.beforeHarvest(this);
        Collection<TracedError> errors = this.errorService.harvest(this);
        if (this.isConnected()) {
            List<MetricData> data;
            long now = System.currentTimeMillis();
            Object object = this.getStatsEngine().getHarvestLock();
            synchronized (object) {
                this.getStatsEngine().getStats("Agent/Metrics/Count").setCallCount(MetricSpec.getMetricCount());
                data = this.getStatsEngine().harvest();
            }
            long startTime = System.nanoTime();
            try {
                this.sendMetricData(this.lastReportTime, now, data);
            }
            catch (InternalLimitExceeded ex) {
                this.handleMetricDataError();
                throw ex;
            }
            catch (MetricDataException ex) {
                this.handleMetricDataError();
                throw ex;
            }
            catch (HttpError ex) {
                if (ex.getStatusCode() == 413) {
                    this.handleMetricDataError();
                }
                throw ex;
            }
            catch (Exception ex) {
                String message = ex.getMessage().toLowerCase();
                if (message.contains("json") && message.contains("parse")) {
                    this.handleMetricDataError();
                }
                throw ex;
            }
            long duration = System.nanoTime() - startTime;
            Object object2 = this.getStatsEngine().getHarvestLock();
            synchronized (object2) {
                this.getStatsEngine().clearPendingMetricData();
                ResponseTimeStats responseTimeStats = this.getStatsEngine().getResponseTimeStats(SUPPORTABILITY_METRIC_HARVEST_TRANSMIT);
                responseTimeStats.recordResponseTime(duration, TimeUnit.NANOSECONDS);
                responseTimeStats.setCallCount(this.numInstancesConnected);
                Stats stats = this.getStatsEngine().getStats("Supportability/MetricHarvest/count");
                stats.incrementCallCount(data.size());
            }
            Agent.LOG.log(Level.FINE, "Reported {0} timeslices", data.size());
            this.sendMessagesFromQueue();
            this.sendTracedErrors(errors);
            this.lastReportTime = now;
            return true;
        }
        if (this.messageQueue.size() > 0) {
            Agent.LOG.fine("Clearing the message queue");
        }
        this.messageQueue.clear();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMetricDataError() {
        Agent.LOG.log(Level.SEVERE, "A parse error was encountered while sending metric data.  Clearing the pending metric data.");
        Object object = this.getStatsEngine().getHarvestLock();
        synchronized (object) {
            this.getStatsEngine().clearPendingMetricData();
        }
    }

    private void getUrlRules(Map<String, Object> extraData) {
        try {
            Object response = extraData.get("url_rules");
            if (response == null || JSON.nullValue().equals(response)) {
                return;
            }
            if (!(response instanceof List)) {
                Agent.LOG.log(Level.FINER, "Unexpected response while getting url rules: {0}", response);
                return;
            }
            List rules = (List)response;
            this.getURLNormalizer().setUrlRules(rules);
            Agent.LOG.log(rules.isEmpty() ? Level.FINE : Level.INFO, "The agent received {0} url normalization rule(s)", rules.size());
            if (!rules.isEmpty()) {
                this.resetMetricSpecsAndData();
            }
        }
        catch (Exception e) {
            String msg = MessageFormat.format("An error occurred setting url normalization rules for {0}: {1}", this.getApplicationName(), e.getLocalizedMessage());
            if (Agent.LOG.isLoggable(Level.FINER)) {
                Agent.LOG.log(Level.FINER, msg, e);
            }
            Agent.LOG.log(Level.INFO, msg);
        }
    }

    private void initializeAdpexT(Map<String, Object> extraData) {
        Object response = extraData.get(APDEX_T_KEY);
        if (response == null || JSON.nullValue().equals(response)) {
            String msg = MessageFormat.format("No apdex_t sent by RPM for {0} - using default value", this.getApplicationName());
            Agent.LOG.info(msg);
            this.apdexT = 1000L;
        } else if (!(response instanceof Double)) {
            String msg = MessageFormat.format("Unexpected apdex_t type sent by RPM for {0}: {1}", this.getApplicationName(), response.getClass());
            Agent.LOG.info(msg);
            this.apdexT = 1000L;
        } else {
            this.apdexT = (long)((Double)response * 1000.0);
        }
        Agent.LOG.fine(MessageFormat.format("Setting apdex_t for {0} to: {1} milliseconds", this.getApplicationName(), this.apdexT));
    }

    @Override
    protected void doStop() {
        if (!this.isMainApp()) {
            ServiceManagerFactory.getServiceManager().getRPMServiceManager().removeConnectionListener(this);
        }
        try {
            this.shutdown();
        }
        catch (Exception e) {
            Level level = e instanceof ConnectException ? Level.FINER : Level.SEVERE;
            Agent.LOG.log(level, "An error occurred in the NewRelic agent shutdown", e);
        }
    }

    public SessionService getSessionService() {
        return this.sessionService;
    }

    private class DefaultDataSender
    extends DataSender {
        private final List params;

        public DefaultDataSender(List params) {
            this.params = params;
        }

        protected String dataToString() {
            return this.params.toString();
        }

        protected String getJSON() {
            return JSON.toJSONString(this.params).toString();
        }

        protected void writeData(Writer out) throws IOException {
            JSONArray.writeJSONString(this.params, out);
        }
    }

    abstract class DataSender {
        DataSender() {
        }

        public Object invokeRemote(String method, boolean deflate) throws Exception {
            StringBuilder uri = new StringBuilder("/agent_listener/invoke_raw_method?method=").append(method).append("&license_key=").append(RPMService.this.licenseKey).append("&marshal_format=json").append("&protocol_version=").append(Integer.toString(9));
            if (RPMService.this.agentRunID > 0) {
                uri.append("&run_id=").append(Integer.toString(RPMService.this.agentRunID));
            }
            URL url = new URL(RPMService.this.protocol, RPMService.this.host, RPMService.this.port, uri.toString());
            HttpURLConnection conn = (HttpURLConnection)(RPMService.this.proxy == null ? url.openConnection() : url.openConnection(RPMService.this.proxy));
            conn.setConnectTimeout(RPMService.this.requestTimeoutInMillis);
            conn.setReadTimeout(RPMService.this.requestTimeoutInMillis);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("CONTENT-TYPE", "application/octet-stream");
            conn.setRequestProperty("ACCEPT-ENCODING", RPMService.GZIP);
            try {
                String encoding = deflate ? "deflate" : "identity";
                conn.setRequestProperty("CONTENT-ENCODING", encoding);
                OutputStream zipStream = "identity".equals(encoding) ? conn.getOutputStream() : new DeflaterOutputStream(conn.getOutputStream(), new Deflater(1));
                OutputStreamWriter out = new OutputStreamWriter(zipStream);
                this.writeData(out);
                ((Writer)out).flush();
                ((Writer)out).close();
                int responseCode = conn.getResponseCode();
                InputStream inStream = conn.getInputStream();
                String contentTypeEncoding = conn.getHeaderField("content-encoding");
                if (RPMService.GZIP.equals(contentTypeEncoding)) {
                    inStream = new GZIPInputStream(inStream);
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(inStream));
                String responseBody = in.readLine();
                try {
                    JSONParser parser = new JSONParser();
                    Object response = parser.parse(responseBody);
                    ServiceManager serviceManager = ServiceManagerFactory.getServiceManager();
                    AgentConfig agentConfig = serviceManager.getConfigService().getAgentConfig();
                    if (agentConfig.isTraceDataCallsEnabled()) {
                        Agent.LOG.log(Level.INFO, "Transmitted JSON({0}): {1}", new Object[]{method, this.getJSON()});
                    }
                    if (response instanceof Map) {
                        Map responseMap = (Map)response;
                        Object exception = responseMap.get("exception");
                        if (exception != null) {
                            try {
                                throw RPMService.this.parseException(exception);
                            }
                            catch (ForceRestartException ex) {
                                RPMService.this.reconnect();
                                throw ex;
                            }
                            catch (ForceDisconnectException ex) {
                                Agent.LOG.log(Level.INFO, "The New Relic Agent received a ForceDisconnectException - {0}", ex.toString());
                                ServiceManagerFactory.getServiceManager().getAgent().shutdownAsync();
                                throw ex;
                            }
                            catch (LicenseException ex) {
                                Agent.LOG.log(Level.WARNING, ex.getMessage());
                                throw ex;
                            }
                            catch (Exception ex) {
                                Agent.LOG.log(Level.INFO, "An error occurred invoking \"{0}\"", method);
                                Agent.LOG.log(Level.FINER, "Error sending json data : {0} - {1}", new Object[]{this.getJSON(), response.toString()});
                                throw ex;
                            }
                        }
                        if (responseCode != 200) {
                            throw new HttpError(responseBody, responseCode);
                        }
                        Object v = responseMap.get("return_value");
                        return v;
                    }
                    try {
                        throw new RPMServiceException(MessageFormat.format("Invalid response: {0}", responseBody));
                    }
                    catch (ParseException e) {
                        throw new RPMServiceException(MessageFormat.format("Invalid response: {0}", responseBody), e);
                    }
                }
                finally {
                    in.close();
                }
            }
            finally {
                conn.disconnect();
            }
        }

        protected abstract String dataToString();

        protected abstract String getJSON();

        protected abstract void writeData(Writer var1) throws IOException;
    }
}

