/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.AgentMessage;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.Externalizable;
import com.newrelic.org.json.simple.JSONObject;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

public class MetricSpec
implements JSONStreamAware,
Externalizable {
    static final int TOTAL_METRIC_LIMIT = 15000;
    private static final int MAX_ROOT_METRIC_LIMIT = 100;
    static final int MAX_METRICS_PER_ROOT_LIMIT = 2000;
    private static final Set<String> METRIC_EXPLOSION_ROOT_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("WebTransaction", "OtherTransaction")));
    static final int MAX_METRICS_PER_WEB_OR_OTHER_TRANSACTION_LIMIT = 500;
    private static final int INITIAL_METRIC_SPEC_MAP_SIZE = 200;
    private static final Map<NameScope, MetricSpec> sMetricSpecs = new HashMap<NameScope, MetricSpec>(200);
    private static final Map<String, List<MetricSpec>> sRootMetricSpecs = new HashMap<String, List<MetricSpec>>();
    private static final String EMPTY_SCOPE = "";
    public static final MetricSpec DISPATCHER = MetricSpec.lookup("HttpDispatcher");
    public static final MetricSpec APDEX = MetricSpec.lookup("Apdex");
    public static final MetricSpec WEB_TRANSACTION = MetricSpec.lookup("WebTransaction");
    public static final MetricSpec DATABASE_ALL = MetricSpec.lookup("Database/all");
    public static final MetricSpec DATABASE_GET_CONNECTION = MetricSpec.lookup("Database/getConnection");
    public static final MetricSpec WEB_TRANSACTION_DATABASE_ALL = MetricSpec.lookup("Database/allWeb");
    public static final MetricSpec OTHER_TRANSACTION_DATABASE_ALL = MetricSpec.lookup("Database/allOther");
    public static final MetricSpec WEB_TRANSACTION_ORM_ALL = MetricSpec.lookup("ORM/allWeb");
    public static final MetricSpec OTHER_TRANSACTION_ORM_ALL = MetricSpec.lookup("ORM/allOther");
    public static final MetricSpec EXTERNAL_ALL = MetricSpec.lookup("External/all");
    public static final MetricSpec WEB_TRANSACTION_EXTERNAL_ALL = MetricSpec.lookup("External/allWeb");
    public static final MetricSpec OTHER_TRANSACTION_EXTERNAL_ALL = MetricSpec.lookup("External/allOther");
    public static final MetricSpec WEB_TRANSACTION_SOLR_ALL = MetricSpec.lookup("Solr/allWeb");
    public static final MetricSpec OTHER_TRANSACTION_SOLR_ALL = MetricSpec.lookup("Solr/allOther");
    public static final MetricSpec QUEUE_TIME = MetricSpec.lookup("WebFrontend/QueueTime");
    public static final MetricSpec WEBFRONTEND_WEBSERVER_ALL = MetricSpec.lookup("WebFrontend/WebServer/all");
    private final NameScope nameScope;
    private Integer metricId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String name, String scope) {
        if (name == null || name.length() == 0) {
            return false;
        }
        scope = scope == null ? EMPTY_SCOPE : scope;
        NameScope key = new NameScope(name, scope);
        Class<MetricSpec> clazz = MetricSpec.class;
        synchronized (MetricSpec.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sMetricSpecs.containsKey(key);
        }
    }

    public static MetricSpec lookup(String name, String scope) {
        return MetricSpec.lookup(name, scope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricSpec lookup(String name, String scope, boolean checkLimits) {
        if (name == null || name.length() == 0) {
            RuntimeException e = new RuntimeException("Metric names cannot be blank");
            if (Agent.isDebugEnabled()) {
                Agent.LOG.log(Level.FINE, "Metric names cannot be blank", e);
            }
            throw e;
        }
        scope = scope == null ? EMPTY_SCOPE : scope;
        NameScope key = new NameScope(name, scope);
        Class<MetricSpec> clazz = MetricSpec.class;
        synchronized (MetricSpec.class) {
            MetricSpec metricSpec = sMetricSpecs.get(key);
            if (metricSpec == null) {
                if (sMetricSpecs.size() == 15000) {
                    String msg = MessageFormat.format("The agent metric limit of {0} metrics has been exceeded.", 15000);
                    MetricSpec.notifyServer(msg);
                    MetricSpec.clear();
                    throw new RuntimeException(msg);
                }
                metricSpec = new MetricSpec(key);
                if (checkLimits && EMPTY_SCOPE.equals(scope)) {
                    int pathSeparatorIndex = name.indexOf(47);
                    String rootSegment = pathSeparatorIndex > 0 ? name.substring(0, pathSeparatorIndex) : name;
                    List<MetricSpec> specs = sRootMetricSpecs.get(rootSegment);
                    if (specs == null) {
                        specs = new LinkedList<MetricSpec>();
                        sRootMetricSpecs.put(rootSegment, specs);
                    } else {
                        int rootMetricLimit;
                        boolean isWebOrOtherTransaction = METRIC_EXPLOSION_ROOT_NAMES.contains(rootSegment);
                        int n = rootMetricLimit = isWebOrOtherTransaction ? 500 : 2000;
                        if (specs.size() == rootMetricLimit) {
                            String msg = MessageFormat.format("The metric limit of {0} metrics has been exceeded for the root metric \"{1}\".", 2000, rootSegment);
                            MetricSpec.notifyServer(msg);
                        } else if (specs.size() > rootMetricLimit && isWebOrOtherTransaction) {
                            // ** MonitorExit[var4_5] (shouldn't be in output)
                            return MetricSpec.lookup(rootSegment + "/MetricExplosion/*", EMPTY_SCOPE, false);
                        }
                    }
                    specs.add(metricSpec);
                    if (sRootMetricSpecs.size() > 100) {
                        String msg = MessageFormat.format("The number of root metric paths has exceeded the limit of {0}.", 100);
                        MetricSpec.notifyServer(msg);
                    }
                }
                sMetricSpecs.put(key, metricSpec);
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return metricSpec;
        }
    }

    private static void notifyServer(String msg) {
        try {
            Agent.LOG.info(msg);
            ServiceManagerFactory.getServiceManager().getRPMServiceManager().getRPMService().queueMessages(new AgentMessage(msg, null, 1));
        }
        catch (Exception e) {
            Agent.LOG.log(Level.FINE, "Unable to send message to server: " + msg, e);
        }
    }

    public static MetricSpec lookup(String name) {
        return MetricSpec.lookup(name, EMPTY_SCOPE);
    }

    public static synchronized MetricSpec lookup(Integer metricId) {
        for (MetricSpec spec : sMetricSpecs.values()) {
            if (!metricId.equals(spec.getMetricId())) continue;
            return spec;
        }
        return null;
    }

    static synchronized int getMetricCount() {
        return sMetricSpecs.size();
    }

    private MetricSpec(NameScope nameScope) {
        this.nameScope = nameScope;
    }

    static void clear() {
        for (MetricSpec spec : sMetricSpecs.values()) {
            spec.metricId = null;
        }
        sMetricSpecs.clear();
        sRootMetricSpecs.clear();
    }

    public String getName() {
        return this.nameScope.name;
    }

    public String getScope() {
        return this.nameScope.scope;
    }

    public Integer getMetricId() {
        return this.metricId;
    }

    void setMetricId(int id) {
        this.metricId = id;
    }

    public int hashCode() {
        return this.nameScope.hashCode;
    }

    public boolean equals(Object o) {
        if (o.getClass() != this.getClass()) {
            return false;
        }
        MetricSpec spec = (MetricSpec)o;
        return this.nameScope.equals(spec.nameScope);
    }

    public String toString() {
        return this.nameScope.toString();
    }

    public void writeJSONString(Writer writer) throws IOException {
        HashMap<String, Object> props = new HashMap<String, Object>(3){
            {
                if (MetricSpec.this.metricId != null) {
                    this.put("metric_id", MetricSpec.this.metricId);
                } else {
                    if (MetricSpec.this.nameScope.scope.length() > 0) {
                        this.put("scope", MetricSpec.this.nameScope.scope);
                    }
                    this.put("name", MetricSpec.this.nameScope.name);
                }
            }
        };
        JSONObject.writeJSONString(props, writer);
    }

    public void write(DataOutputStream dataOutput) throws IOException {
        dataOutput.writeUTF(this.nameScope.name);
        dataOutput.writeUTF(this.nameScope.scope);
    }

    private static class NameScope {
        private final String name;
        private final String scope;
        private final int hashCode;

        public NameScope(String name, String scope) {
            this.name = name;
            this.scope = scope;
            this.hashCode = this.computeHash();
        }

        private int computeHash() {
            return this.name.hashCode() ^ this.scope.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            NameScope other = (NameScope)obj;
            return this.name.equals(other.name) && this.scope.equals(other.scope);
        }

        public String toString() {
            StringBuilder tmp = new StringBuilder(this.name);
            if (this.scope.length() > 0) {
                tmp.append(" (").append(this.scope).append(')');
            }
            return tmp.toString();
        }
    }
}

