/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.MetricSpec;
import com.newrelic.agent.stats.AbstractStats;
import com.newrelic.agent.stats.CountStats;
import com.newrelic.agent.stats.StatsBase;
import com.newrelic.org.json.simple.JSONArray;
import com.newrelic.org.json.simple.JSONStreamAware;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.Level;

public class MetricData
implements JSONStreamAware {
    private StatsBase stats;
    private MetricSpec metricSpec;
    private Integer metricID;

    public MetricData(MetricSpec metricSpec, StatsBase stats) {
        this.stats = stats;
        this.metricID = metricSpec.getMetricId();
        this.metricSpec = metricSpec;
    }

    public StatsBase getStats() {
        return this.stats;
    }

    public CountStats getCountStats() {
        return (CountStats)this.stats;
    }

    public MetricSpec getMetricSpec() {
        return this.metricSpec;
    }

    public Integer getMetricId() {
        return this.metricID;
    }

    public String toString() {
        return this.metricSpec.toString();
    }

    public void writeJSONString(Writer writer) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>(2){
            {
                if (MetricData.this.metricID == null) {
                    this.add(MetricData.this.metricSpec);
                } else {
                    this.add(Integer.valueOf(MetricData.this.metricID));
                }
                if (MetricData.this.stats.isValid()) {
                    this.add(MetricData.this.stats);
                } else {
                    Agent.LOG.log(Level.FINE, "Encountered an invalid stat for metric \"{0}\" : {1}", new Object[]{MetricData.this.metricSpec.toString(), MetricData.this.stats.toString()});
                    this.add(AbstractStats.EMPTY_STATS);
                }
            }
        };
        JSONArray.writeJSONString(list, writer);
    }
}

