/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.ConnectionListener;
import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.HarvestService;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.IgnoreSilentlyException;
import com.newrelic.agent.ServerCommandException;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.util.DefaultThreadFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HarvestServiceImpl
extends AbstractService
implements HarvestService {
    public static final String HARVEST_THREAD_NAME = "New Relic Harvest Service";
    private static final int MAX_DATA_CONNECTION_ERRORS_TO_LOG = 5;
    private static final long INITIAL_DELAY = 30000L;
    private final ScheduledExecutorService scheduledExecutor;
    private final List<HarvestListener> harvestListeners = new CopyOnWriteArrayList<HarvestListener>();
    private final Map<IRPMService, HarvestTask> harvestTasks = new HashMap<IRPMService, HarvestTask>();

    public HarvestServiceImpl() {
        super(HarvestService.class.getSimpleName());
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(HARVEST_THREAD_NAME, true);
        this.scheduledExecutor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        ServiceManagerFactory.getServiceManager().getRPMServiceManager().addConnectionListener(new ConnectionListenerImpl());
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    public void startHarvest(IRPMService rpmService) {
        HarvestTask harvestTask = this.getOrCreateHarvestTask(rpmService);
        harvestTask.start();
    }

    private synchronized HarvestTask getOrCreateHarvestTask(IRPMService rpmService) {
        HarvestTask harvestTask = this.harvestTasks.get(rpmService);
        if (harvestTask == null) {
            harvestTask = new HarvestTask(rpmService);
            this.harvestTasks.put(rpmService, harvestTask);
        }
        return harvestTask;
    }

    private synchronized List<HarvestTask> getHarvestTasks() {
        return new ArrayList<HarvestTask>(this.harvestTasks.values());
    }

    @Override
    public void addHarvestListener(HarvestListener listener) {
        this.harvestListeners.add(listener);
    }

    @Override
    public void removeHarvestListener(HarvestListener listener) {
        this.harvestListeners.remove(listener);
    }

    @Override
    protected void doStop() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            task.stop();
        }
    }

    private ScheduledFuture<?> scheduleHarvestTask(HarvestTask harvestTask, long reportPeriod) {
        return this.scheduledExecutor.scheduleWithFixedDelay(harvestTask, this.getInitialDelay(), reportPeriod, TimeUnit.MILLISECONDS);
    }

    public long getInitialDelay() {
        return 30000L;
    }

    @Override
    public void harvestNow() {
        List<HarvestTask> tasks = this.getHarvestTasks();
        for (HarvestTask task : tasks) {
            task.harvestNow();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionListenerImpl
    implements ConnectionListener {
        private ConnectionListenerImpl() {
        }

        @Override
        public void connected(IRPMService rpmService, Map<String, Object> connectionInfo) {
            HarvestServiceImpl.this.startHarvest(rpmService);
        }

        @Override
        public void disconnected(IRPMService rpmService) {
        }
    }

    private final class HarvestTask
    implements Runnable {
        private final IRPMService rpmService;
        private ScheduledFuture<?> task;
        private long reportPeriod = -1L;
        private int errorCount = 0;
        private final Lock harvestLock = new ReentrantLock();

        private HarvestTask(IRPMService rpmService) {
            this.rpmService = rpmService;
        }

        public void run() {
            this.harvest();
        }

        private synchronized void start() {
            long period = this.rpmService.getDataReportPeriod();
            if (this.reportPeriod != period || !this.isRunning()) {
                this.reportPeriod = period;
                this.stop();
                String msg = MessageFormat.format("Scheduling harvest task for {0}.  Reporting period is {1} milliseconds", this.rpmService.getApplicationName(), period);
                HarvestServiceImpl.this.getLogger().log(Level.FINER, msg);
                this.task = HarvestServiceImpl.this.scheduleHarvestTask(this, period);
            }
        }

        private synchronized void stop() {
            if (this.task != null) {
                HarvestServiceImpl.this.getLogger().log(Level.FINER, "Stopping harvest task for {0}", this.rpmService.getApplicationName());
                this.task.cancel(false);
            }
        }

        private boolean isRunning() {
            if (this.task == null) {
                return false;
            }
            return !this.task.isCancelled() || this.task.isDone();
        }

        private void harvestNow() {
            if (this.rpmService.isConnected() && this.harvestLock.tryLock()) {
                String msg = MessageFormat.format("Sending metrics for {0} immediately", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().info(msg);
                this.harvest();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void harvest() {
            this.harvestLock.lock();
            try {
                this.doHarvest();
                this.errorCount = 0;
            }
            catch (ServerCommandException e) {
            }
            catch (IgnoreSilentlyException e) {
            }
            catch (Throwable e) {
                String msg;
                ++this.errorCount;
                if (this.errorCount <= 5 && HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                    msg = MessageFormat.format("Error sending metric data for {0}: {1}", this.rpmService.getApplicationName(), e.getMessage());
                    if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINEST)) {
                        HarvestServiceImpl.this.getLogger().log(Level.FINEST, msg, e);
                    } else {
                        HarvestServiceImpl.this.getLogger().finer(msg);
                    }
                }
                if (this.errorCount == 5 && HarvestServiceImpl.this.getLogger().isLoggable(Level.FINE)) {
                    msg = MessageFormat.format("No more data connection exceptions for {0} will be logged until after the agent connection is re-established", this.rpmService.getApplicationName());
                    HarvestServiceImpl.this.getLogger().fine(msg);
                }
            }
            finally {
                this.harvestLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void doHarvest() throws Exception {
            long duration;
            if (HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) {
                String msg = MessageFormat.format("Starting harvest for {0}", this.rpmService.getApplicationName());
                HarvestServiceImpl.this.getLogger().finer(msg);
            }
            long startTime = System.nanoTime();
            try {
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    listener.beforeHarvest(this.rpmService);
                }
                this.rpmService.harvest();
                for (HarvestListener listener : HarvestServiceImpl.this.harvestListeners) {
                    listener.afterHarvest(this.rpmService);
                }
                duration = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                this.rpmService.getStatsEngine().getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration, TimeUnit.MILLISECONDS);
                if (!HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) return;
            }
            catch (Throwable throwable) {
                long duration2 = TimeUnit.MILLISECONDS.convert(System.nanoTime() - startTime, TimeUnit.NANOSECONDS);
                this.rpmService.getStatsEngine().getResponseTimeStats("Supportability/Harvest").recordResponseTime(duration2, TimeUnit.MILLISECONDS);
                if (!HarvestServiceImpl.this.getLogger().isLoggable(Level.FINER)) throw throwable;
                String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", this.rpmService.getApplicationName(), duration2);
                HarvestServiceImpl.this.getLogger().finer(msg);
                throw throwable;
            }
            String msg = MessageFormat.format("Harvest for {0} took {1} milliseconds", this.rpmService.getApplicationName(), duration);
            HarvestServiceImpl.this.getLogger().finer(msg);
        }
    }
}

