/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.HarvestListener;
import com.newrelic.agent.IRPMService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import com.newrelic.agent.stats.ResponseTimeStats;
import com.newrelic.agent.stats.StatsEngine;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GCService
extends AbstractService
implements HarvestListener {
    private final Map<String, GarbageCollector> garbageCollectors = new HashMap<String, GarbageCollector>();

    public GCService() {
        super(GCService.class.getSimpleName());
    }

    public boolean isEnabled() {
        return true;
    }

    protected void doStart() {
        ServiceManagerFactory.getServiceManager().getHarvestService().addHarvestListener(this);
    }

    protected void doStop() {
    }

    public synchronized void beforeHarvest(IRPMService rpmService) {
        for (GarbageCollectorMXBean gcBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            GarbageCollector garbageCollector = this.garbageCollectors.get(gcBean.getName());
            if (garbageCollector == null) {
                garbageCollector = new GarbageCollector(gcBean);
                this.garbageCollectors.put(gcBean.getName(), garbageCollector);
                continue;
            }
            garbageCollector.recordGC(gcBean, rpmService);
        }
    }

    public void afterHarvest(IRPMService rpmService) {
    }

    private class GarbageCollector {
        private long collectionCount;
        private long collectionTime;

        public GarbageCollector(GarbageCollectorMXBean gcBean) {
            this.collectionCount = gcBean.getCollectionCount();
            this.collectionTime = gcBean.getCollectionTime();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recordGC(GarbageCollectorMXBean gcBean, IRPMService service) {
            long lastCollectionCount = this.collectionCount;
            long lastCollectionTime = this.collectionTime;
            this.collectionCount = gcBean.getCollectionCount();
            this.collectionTime = gcBean.getCollectionTime();
            long numberOfCollections = this.collectionCount - lastCollectionCount;
            long time = this.collectionTime - lastCollectionTime;
            if (numberOfCollections > 0L) {
                String rootMetricName = "GC/" + gcBean.getName();
                StatsEngine statsEngine = service.getStatsEngine();
                Object object = statsEngine.getHarvestLock();
                synchronized (object) {
                    ResponseTimeStats stats = statsEngine.getResponseTimeStats(rootMetricName);
                    stats.recordResponseTime(time, TimeUnit.MILLISECONDS);
                    stats.setCallCount((int)numberOfCollections);
                }
            }
        }
    }
}

