/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.ApplicationNamingService;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationNamingServiceImpl
extends AbstractService
implements ApplicationNamingService {
    private final Map<String, String> appRenamings;
    private final boolean isAutoAppNamingEnabled;

    public ApplicationNamingServiceImpl() {
        super(ApplicationNamingService.class.getSimpleName());
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        this.isAutoAppNamingEnabled = config.isAutoAppNamingEnabled();
        this.appRenamings = this.initializeRenamings(config);
    }

    private Map<String, String> initializeRenamings(AgentConfig config) {
        HashMap<String, String> result = new HashMap<String, String>();
        Map<String, String> renamings = config.getAppRenaming();
        if (renamings == null) {
            return result;
        }
        for (Map.Entry<String, String> entry : renamings.entrySet()) {
            String msg = MessageFormat.format("Rename application \"{0}\" to \"{1}\"", entry.getKey(), entry.getValue());
            Agent.LOG.info(msg);
            result.put(entry.getKey(), entry.getValue().intern());
        }
        return result;
    }

    @Override
    public String getApplicationName(String appName) {
        if (!this.isAutoAppNamingEnabled) {
            return appName;
        }
        if (appName == null || appName.length() == 0) {
            return appName;
        }
        String result = this.appRenamings.get(appName);
        if (result == null) {
            return appName;
        }
        if (this.getLogger().isLoggable(Level.FINEST)) {
            String msg = MessageFormat.format("Renamed application \"{0}\" to \"{1}\"", appName, result);
            Agent.LOG.finest(msg);
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }
}

