/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.Agent;
import com.newrelic.agent.Deployments;
import com.newrelic.agent.install.AppServerIdentifier;
import com.newrelic.agent.install.SelfInstaller;
import com.newrelic.agent.install.SelfInstallerFactory;
import com.newrelic.agent.util.Streams;
import com.newrelic.org.apache.commons.cli.CommandLine;
import com.newrelic.org.apache.commons.cli.HelpFormatter;
import com.newrelic.org.apache.commons.cli.Option;
import com.newrelic.org.apache.commons.cli.Options;
import com.newrelic.org.apache.commons.cli.ParseException;
import com.newrelic.org.apache.commons.cli.PosixParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

class AgentCommandLineParser {
    private static final String INSTALL_COMMAND = "install";
    private static final String DEPLOYMENT_COMMAND = "deployment";
    private static final Map<String, Options> commandOptionsMap = new HashMap<String, Options>();
    private static final Map<String, String> commandDescriptions;

    AgentCommandLineParser() {
    }

    public void parseCommand(String[] args) {
        PosixParser parser = new PosixParser();
        try {
            String command;
            CommandLine cmd = parser.parse(AgentCommandLineParser.getCommandLineOptions(), args);
            List argList = cmd.getArgList();
            String string = command = argList.size() > 0 ? (String)argList.get(0) : null;
            if (cmd.hasOption('h')) {
                this.printHelp(command);
                return;
            }
            if (command != null) {
                Options commandOptions = commandOptionsMap.get(command);
                if (commandOptions == null) {
                    this.printHelp();
                    System.err.println("\nInvalid command - " + command);
                    System.exit(1);
                }
                cmd = parser.parse(commandOptions, args);
            }
            if (DEPLOYMENT_COMMAND.equals(command)) {
                this.deploymentCommand(cmd);
            } else if (INSTALL_COMMAND.equals(command)) {
                this.installCommand(cmd);
            } else if (cmd.hasOption('v')) {
                System.out.println(Agent.getVersion());
            } else {
                this.printHelp();
                System.exit(1);
            }
        }
        catch (ParseException e) {
            System.err.println("Error parsing arguments");
            e.printStackTrace();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error executing command");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void deploymentCommand(CommandLine cmd) throws Exception {
        Deployments.recordDeployment(cmd);
    }

    private void installCommand(CommandLine cmd) throws Exception {
        System.out.println("***** ( ( o))  New Relic Java Agent Installer");
        System.out.println("***** Installing version " + Agent.getVersion() + " ...");
        File currentDir = new File(System.getProperty("user.dir"));
        boolean succeeded = false;
        AppServerIdentifier.AppServerType type = AppServerIdentifier.getAppServerType(currentDir.getParentFile());
        if (type == null || type == AppServerIdentifier.AppServerType.UNKNOWN) {
            this.printUnknownAppServer(currentDir.getParentFile());
        } else {
            SelfInstaller installer = SelfInstallerFactory.getSelfInstaller(type);
            if (installer != null) {
                succeeded = installer.backupAndEditStartScript(currentDir.getParentFile().toString());
            }
        }
        String licenseKey = cmd.getOptionValue('l');
        if (succeeded &= this.installYaml(licenseKey == null ? "'replace_with_your_license_key'" : licenseKey, currentDir)) {
            this.printInstallSuccess();
            System.exit(0);
        } else {
            this.printInstallIncomplete();
            System.exit(1);
        }
    }

    private boolean installYaml(String licenseKey, File yamlDir) {
        boolean result = false;
        if (yamlDir != null && yamlDir.exists() && yamlDir.isDirectory()) {
            File file = new File(yamlDir, "newrelic.yml");
            if (file.exists()) {
                System.out.println("No need to create New Relic configuration file because:");
                System.out.println(MessageFormat.format(" .:. A config file already exists: {0}", file.getAbsolutePath()));
                result = true;
            } else {
                result = this.generateConfig(licenseKey, file);
            }
        } else {
            System.err.println("Could not create New Relic configuration file because:");
            System.err.println(MessageFormat.format(" .:. {0} does not exist or is not a directory", yamlDir.getAbsolutePath()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateConfig(String licenseKey, File file) {
        boolean result = false;
        InputStream inStream = Agent.class.getClassLoader().getResourceAsStream("com/newrelic/agent/newrelic.yml");
        if (inStream != null) {
            String generatedFrom = this.getGeneratedFromString();
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                Streams.copy(inStream, output);
                String yaml = output.toString().replace("<%= generated_for_user %>", generatedFrom).replace("<%= license_key %>", licenseKey);
                FileOutputStream fileOut = new FileOutputStream(file);
                try {
                    Streams.copy(new ByteArrayInputStream(yaml.getBytes()), fileOut);
                }
                finally {
                    fileOut.close();
                }
                System.out.println("Generated New Relic configuration file " + file.getAbsolutePath());
                result = true;
            }
            catch (IOException e) {
                System.err.println(MessageFormat.format("An error occurred generating the configuration file {0} : {1}", file.getAbsolutePath(), e.toString()));
                Agent.LOG.log(Level.FINE, "Config file generation error", e);
                result = false;
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    result = false;
                }
            }
        }
        return result;
    }

    private String getGeneratedFromString() {
        return MessageFormat.format("Generated on {0}, from version {1}", new Date(), Agent.getVersion());
    }

    private void printInstallSuccess() {
        System.out.println("***** Install successful");
        System.out.println("***** Next steps:");
        System.out.println("You're almost done! To see performance data for your app:" + SelfInstaller.lineSep + " .:. Restart your app server" + SelfInstaller.lineSep + " .:. Exercise your app" + SelfInstaller.lineSep + " .:. Log into http://rpm.newrelic.com" + SelfInstaller.lineSep + "Within two minutes, your app should show up, ready to monitor and troubleshoot." + SelfInstaller.lineSep + "If app data doesn't appear, check newrelic/logs/newrelic_agent.log for errors.");
    }

    private void printInstallIncomplete() {
        System.out.println("***** Install incomplete");
        System.out.println("***** Next steps:");
        System.out.println("For help completing the install, see http://support.newrelic.com/faqs/docs/java-agent-installation");
    }

    private void printUnknownAppServer(File appServerLoc) {
        StringBuffer knownAppServers = new StringBuffer();
        for (int i = 0; i < AppServerIdentifier.AppServerType.values().length - 1; ++i) {
            AppServerIdentifier.AppServerType type = AppServerIdentifier.AppServerType.values()[i];
            knownAppServers.append(type.getName());
            if (i < AppServerIdentifier.AppServerType.values().length - 3) {
                knownAppServers.append(", ");
                continue;
            }
            if (i != AppServerIdentifier.AppServerType.values().length - 3) continue;
            knownAppServers.append(" or ");
        }
        System.out.println("Could not edit start script because:");
        System.out.println(" .:. Could not locate a " + knownAppServers.toString() + " instance in " + appServerLoc.toString());
        System.out.println("Try re-running the install command from <AppServerRootDirectory>" + SelfInstaller.fileSep + "newrelic.");
        System.out.println("If that doesn't work, locate and edit the start script manually.");
    }

    private void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(MessageFormat.format("New Relic Agent Version {0}", Agent.getVersion()));
        formatter.printHelp("java -jar newrelic.jar", "", AgentCommandLineParser.getBasicOptions(), this.getCommandLineFooter());
    }

    private void printHelp(String command) {
        if (command == null) {
            this.printHelp();
            return;
        }
        HelpFormatter formatter = new HelpFormatter();
        System.out.println(MessageFormat.format("New Relic Agent Version {0}", Agent.getVersion()));
        String footer = "\n  " + command + ' ' + commandDescriptions.get(command);
        formatter.printHelp("java -jar newrelic.jar " + command, "", commandOptionsMap.get(command), footer);
    }

    private String getCommandLineFooter() {
        StringBuilder builder = new StringBuilder("\nCommands:");
        for (Map.Entry<String, String> entry : commandDescriptions.entrySet()) {
            builder.append("\n  ").append((entry.getKey() + "          ").substring(0, this.getMaxCommandLength())).append(' ').append(entry.getValue());
        }
        return builder.toString();
    }

    private int getMaxCommandLength() {
        int max = 0;
        for (String command : commandDescriptions.keySet()) {
            max = Math.max(max, command.length());
        }
        return max;
    }

    static Options getCommandLineOptions() {
        ArrayList<Options> values = new ArrayList<Options>(Arrays.asList(AgentCommandLineParser.getBasicOptions()));
        values.addAll(commandOptionsMap.values());
        return AgentCommandLineParser.combineOptions(AgentCommandLineParser.getBasicOptions(), AgentCommandLineParser.getInstallOptions(), AgentCommandLineParser.getDeploymentOptions());
    }

    private static Options combineOptions(Options ... optionsList) {
        Options newOptions = new Options();
        for (Options options : optionsList) {
            for (Option option : options.getOptions()) {
                newOptions.addOption(option);
            }
        }
        return newOptions;
    }

    private static Options getBasicOptions() {
        Options options = new Options();
        options.addOption("v", false, "Prints the agent version");
        options.addOption("h", false, "Prints help");
        return options;
    }

    private static Options getInstallOptions() {
        Options options = new Options();
        options.addOption("l", true, "Use the given license key");
        return options;
    }

    private static Options getServerOptions() {
        Options options = new Options();
        return options;
    }

    private static Options getDeploymentOptions() {
        Options options = new Options();
        options.addOption("appname", true, "Set the application name.  Default is app_name setting in newrelic.yml");
        options.addOption("environment", true, "Set the environment (staging, production, test, development)");
        options.addOption("user", true, "Specify the user deploying");
        options.addOption("revision", true, "Specify the revision being deployed");
        options.addOption("changes", false, "Reads the change log for a deployment from standard input");
        return options;
    }

    static {
        commandOptionsMap.put(DEPLOYMENT_COMMAND, AgentCommandLineParser.getDeploymentOptions());
        commandOptionsMap.put(INSTALL_COMMAND, AgentCommandLineParser.getInstallOptions());
        commandDescriptions = new HashMap<String, String>();
        commandDescriptions.put(DEPLOYMENT_COMMAND, "[OPTIONS] [description]  Records a deployment");
        commandDescriptions.put(INSTALL_COMMAND, "[OPTIONS]                Generates a newrelic.yml configuration with the given license key");
    }
}

