/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent;

import com.newrelic.agent.AgentCommandLineParser;
import com.newrelic.agent.AgentLogger;
import com.newrelic.agent.IAgent;
import com.newrelic.agent.InstrumentationProxy;
import com.newrelic.agent.config.AgentConfig;
import com.newrelic.agent.config.AgentConfigChangeListener;
import com.newrelic.agent.config.ConfigService;
import com.newrelic.agent.service.AbstractService;
import com.newrelic.agent.service.ServiceManager;
import com.newrelic.agent.service.ServiceManagerFactory;
import java.lang.instrument.Instrumentation;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;

public final class Agent
extends AbstractService
implements IAgent,
AgentConfigChangeListener {
    public static final AgentLogger LOG = AgentLogger.initialize("com.newrelic.agent");
    private static final String AGENT_ENABLED_PROPERTY = "newrelic.config.agent_enabled";
    private static final boolean DEBUG = Boolean.getBoolean("newrelic.debug");
    private static final String VERSION = Agent.initVersion();
    private volatile boolean enabled = true;
    private final Instrumentation instrumentation;
    private volatile InstrumentationProxy instrumentationProxy;

    private Agent(Instrumentation instrumentation) {
        super(IAgent.class.getSimpleName());
        this.instrumentation = instrumentation;
    }

    protected void doStart() {
        ConfigService configService = ServiceManagerFactory.getServiceManager().getConfigService();
        AgentConfig config = configService.getAgentConfig();
        LOG.configureLogger(config);
        configService.addConfigChangeListener(this);
        this.enabled = config.isAgentEnabled();
        if (!this.enabled) {
            LOG.info("The New Relic agent is disabled");
        }
        this.instrumentationProxy = InstrumentationProxy.getInstrumentationProxy(this.instrumentation);
        final long startTime = System.currentTimeMillis();
        Runnable runnable = new Runnable(){

            public void run() {
                Agent.this.jvmShutdown(startTime);
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic JVM Shutdown");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    protected void doStop() {
    }

    public void shutdownAsync() {
        Runnable runnable = new Runnable(){

            public void run() {
                Agent.this.shutdown();
            }
        };
        Thread shutdownThread = new Thread(runnable, "New Relic Shutdown");
        shutdownThread.start();
    }

    private void jvmShutdown(long startTime) {
        AgentConfig config = ServiceManagerFactory.getServiceManager().getConfigService().getAgentConfig();
        if (config.isSendDataOnExit() && System.currentTimeMillis() - startTime > (long)config.getSendDataOnExitThreshold()) {
            ServiceManagerFactory.getServiceManager().getHarvestService().harvestNow();
        }
        this.shutdown();
    }

    public synchronized void shutdown() {
        try {
            ServiceManagerFactory.getServiceManager().stop();
            this.getLogger().info("The New Relic Agent has shutdown");
        }
        catch (Exception e) {
            LOG.severe(MessageFormat.format("Error shutting down the New Relic Agent: {0}", e));
        }
    }

    public void configChanged(AgentConfig config) {
        LOG.configChanged(config);
        boolean isEnabled = config.isAgentEnabled();
        if (isEnabled != this.isEnabled()) {
            if (isEnabled) {
                this.enableAgent();
            } else {
                this.disableAgent();
            }
        }
    }

    private void enableAgent() {
        LOG.log(Level.INFO, "Enabling the New Relic Agent");
        try {
            ServiceManagerFactory.getServiceManager().getRPMServiceManager().start();
        }
        catch (Exception e) {
            LOG.severe(MessageFormat.format("Error enabling the New Relic Agent: {0}", e));
        }
    }

    private void disableAgent() {
        LOG.log(Level.INFO, "Disabling the New Relic Agent");
        try {
            ServiceManagerFactory.getServiceManager().getHarvestService().stop();
            ServiceManagerFactory.getServiceManager().getRPMServiceManager().stop();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Error disabling the New Relic Agent: {0}", e);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public InstrumentationProxy getInstrumentation() {
        return this.instrumentationProxy;
    }

    public static String getVersion() {
        return VERSION;
    }

    private static String initVersion() {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(Agent.class.getName());
            return bundle.getString("version");
        }
        catch (Throwable t) {
            return "Unknown";
        }
    }

    public static boolean isDebugEnabled() {
        return DEBUG;
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        if (ServiceManagerFactory.getServiceManager() != null) {
            System.err.println("The New Relic Agent is already running! Check if more than one -javaagent switch is used on the command line");
            return;
        }
        String enabled = System.getProperty(AGENT_ENABLED_PROPERTY);
        if (enabled != null && !Boolean.parseBoolean(enabled.toString())) {
            System.out.println("The New Relic agent is disabled");
            return;
        }
        try {
            LOG.fine("Booting the New Relic Agent from Premain (-javaagent)");
            Agent agent = new Agent(inst);
            ServiceManager serviceManager = ServiceManagerFactory.create(agent);
            serviceManager.start();
            LOG.log(Level.INFO, "The New Relic Agent v{0} has started", Agent.getVersion());
            LOG.log(Level.CONFIG, "Java version: {0}", System.getProperty("java.version"));
        }
        catch (Throwable t) {
            String msg = MessageFormat.format("Unable to start the New Relic agent: {0}", t);
            System.err.println(msg);
            t.printStackTrace();
        }
    }

    public static void main(String[] args) {
        new AgentCommandLineParser().parseCommand(args);
    }
}

