;; Copyright (C) 2011, Eduardo Julián. All rights reserved.
;;
;; The use and distribution terms for this software are covered by the 
;; Eclipse Public License 1.0
;; (http://opensource.org/licenses/eclipse-1.0.php) which can be found
;; in the file epl-v10.html at the root of this distribution.
;;
;; By using this software in any fashion, you are agreeing to be bound
;; by the terms of this license.
;;
;; You must not remove this notice, or any other, from this software.

(ns clj-recipe-puppy
  "This is an small Clojure binding for the Recipe Puppy API for cooking recipes.
For more information, please visit this webiste: http://www.recipepuppy.com/about/api/"
  (:import (java.net URL URLEncoder))
  (:require [clj-http.client :as client]
    (clojure.contrib [json :as json]))
  (:use (clojure.contrib def)))

(defvar- +base-url+ "http://www.recipepuppy.com/api/?")

(defn- url-encode [url] (if url (URLEncoder/encode url "UTF-8") url))

(defn- fetch-url [url] (-> url client/get :body json/read-json :results))

(defn search-recipes ""
  [& {:keys [keywords ingredients page]}]
  (let [url (str +base-url+
                 (when keywords (str "q=" (url-encode keywords)))
                 (when ingredients (apply str "&i=" (butlast (interleave ingredients ", "))))
                 (when page (str "&p=" page)))]
    (fetch-url url)))
