/*
 * Decompiled with CFR 0.152.
 */
package tech.v3.datatype;

import clojure.lang.AFn;
import clojure.lang.AFunction;
import clojure.lang.IFn;
import clojure.lang.IObj;
import clojure.lang.RT;
import clojure.lang.Symbol;
import clojure.lang.Var;

public final class ffi$fn__9229
extends AFunction {
    public static final Var const__0 = RT.var((String)"clojure.core", (String)"commute");
    public static final Var const__1 = RT.var((String)"clojure.core", (String)"deref");
    public static final Var const__2 = RT.var((String)"clojure.core", (String)"*loaded-libs*");
    public static final Var const__3 = RT.var((String)"clojure.core", (String)"conj");
    public static final AFn const__4 = (AFn)((IObj)Symbol.intern(null, (String)"tech.v3.datatype.ffi")).withMeta(RT.map((Object[])new Object[]{RT.keyword(null, (String)"doc"), "Generalized C Foreign Function Interface (FFI) that unifies JNA and JDK-16 FFI architectures.\n\n  Users can dynamically define and load libraries and define callbacks that C can then\n  call.\n\n  This namespace is meant to work with the `struct` namespace where you can define\n  C-structs laid out precisely in memory.\n\n  Available datatypes for the binding layer:\n\n  * `:int8` `:int16` `:int32` `:int64` `:float32` `:float64` `:pointer` `:pointer?`\n    `:size-t`.\n\n  `:pointer`, `:pointer?`, `:size-t` are all types that change their underlying\n  definition depending on if the system is 32 bit or 64 bit.\n\n  Note that unsigned types will work but the interface will have to be defined in\n  terms of their signed analogues.\n\nExample:\n\n```clojure\nuser> (require '[tech.v3.datatype.ffi :as dtype-ffi])\nnil\nuser> (dtype-ffi/define-library!\n        clib\n        '{:memset {:rettype :pointer\n                   :argtypes [[buffer :pointer]\n                              [byte-value :int32]\n                              [n-bytes :size-t]]}\n          :memcpy {:rettype :pointer\n                   ;;dst src size-t\n                   :argtypes [[dst :pointer]\n                              [src :pointer]\n                              [n-bytes :size-t]]}\n          :qsort {:rettype :void\n                  :argtypes [[data :pointer]\n                             [nitems :size-t]\n                             [item-size :size-t]\n                             [comparator :pointer]]}}\n        nil ;;no library symbols defined\n        nil ;;no systematic error checking\n        )\n\nnil\nuser> ;;now we bind to a path or existing library.  nil means find\nuser> ;;symbols in current executable.\nuser> (dtype-ffi/library-singleton-set! clib nil)\n#<G__17822@7f71640c:\n  {:qsort #object[tech.v3.datatype.ffi.jna.G__17822$invoker_qsort 0x32b4a8cd \"tech.v3.datatype.ffi.jna.G__17822$invoker_qsort@32b4a8cd\"], :memset #object[tech.v3.datatype.ffi.jna.G__17822$invoker_memset 0x676ccb88 \"tech.v3.datatype.ffi.jna.G__17822$invoker_memset@676ccb88\"], :memcpy #object[tech.v3.datatype.ffi.jna.G__17822$invoker_memcpy 0x59fd3d8f \"tech.v3.datatype.ffi.jna.G__17822$invoker_memcpy@59fd3d8f\"]}>\nuser> ;;We can now call functions in our library.\nuser> (require '[tech.v3.datatype :as dtype])\nnil\nuser> (def container (dtype/make-container :native-heap :float64 (range 10)))\n#'user/container\nuser> (apply + container)\n45.0\nuser> (memset container 0 (* (dtype/ecount container) 8))\n#object[tech.v3.datatype.ffi.Pointer 0x59fa4fe0 \"{:address 0x00007F1B4458C0E0 }\"]\nuser> (apply + container)\n0.0\nuser> ;;C callbacks take a bit more effort\nuser> ;;First define the callback signature.\nuser> (def comp-iface (dtype-ffi/define-foreign-interface :int32 [:pointer :pointer]))\n#'user/comp-iface\nuser> ;;Then instantiate an implementation.\nuser> (import [tech.v3.datatype.ffi Pointer])\nuser> (require '[tech.v3.datatype.native-buffer :as native-buffer])\nnil\nuser> (def iface-inst (dtype-ffi/instantiate-foreign-interface\n                       comp-iface\n                       (fn [^Pointer lhs ^Pointer rhs]\n                         (let [lhs (.getDouble (native-buffer/unsafe) (.address lhs))\n                               rhs (.getDouble (native-buffer/unsafe) (.address rhs))]\n                           (Double/compare lhs rhs)))))\n#'user/iface-inst\nuser> iface-inst\n#object[tech.v3.datatype.ffi.jna.ffi_G__17831 0x6e9ddc45 \"tech.v3.datatype.ffi.jna.ffi_G__17831@6e9ddc45\"]\nuser> ;;From an instance of a foreign interface we can get an integer pointer\nuser> (def iface-ptr (dtype-ffi/foreign-interface-instance->c comp-iface iface-inst))\n#'user/iface-ptr\nuser> iface-ptr\n#object[tech.v3.datatype.ffi.Pointer 0x47099d5d \"{:address 0x00007F1BB400F390 }\"]\nuser> ;;reset container\nuser> (dtype/copy! (vec (shuffle (range 10))) container)\n#native-buffer@0x00007F1B4458C0E0<float64>[10]\n[5.000, 9.000, 8.000, 1.000, 3.000, 0.000, 6.000, 7.000, 4.000, 2.000]\nuser> (qsort container 10 8 iface-ptr)\nnil\nuser> container\n#native-buffer@0x00007F1B4458C0E0<float64>[10]\n[0.000, 1.000, 2.000, 3.000, 4.000, 5.000, 6.000, 7.000, 8.000, 9.000]\n```\n\n  Structs can be defined and passed by pointer/reference.  See the [[tech.v3.datatype.struct]]\n  namespace.  Also note that the output of clang can be used to define your structs based on\n  parsing c/c++ header files.  See [[tech.v3.datatype.ffi.clang/defstruct-from-layout]]."}));

    public static Object invokeStatic() {
        return ((IFn)const__0.getRawRoot()).invoke(((IFn)const__1.getRawRoot()).invoke((Object)const__2), const__3.getRawRoot(), (Object)const__4);
    }

    public Object invoke() {
        return ffi$fn__9229.invokeStatic();
    }
}

