(ns leiningen.new.clj-opencv
  (:use [leiningen.new.templates :only [raw-resourcer renderer name-to-path sanitize-ns ->files]]))

(def render (renderer "clj-opencv"))
(def raw (raw-resourcer "clj-opencv"))

(defn clj-opencv
  [name]
  (let [data {:name name
              :ns-name (sanitize-ns name)
              :sanitized (name-to-path name)}]
    (->files data ["samples/opencv3/collage.clj" (render "samples/opencv3/collage.clj" data)]

["notes/practice.clj" (render "notes/practice.clj" data)]

["resources/cat.jpg" (raw "resources/cat.jpg")]
["resources/minicat.jpg" (raw "resources/minicat.jpg")]
["resources/nekobench.jpg" (raw "resources/nekobench.jpg")]
["resources/souslesoleil.jpg" (raw "resources/souslesoleil.jpg")]
["resources/sunflower.jpg" (raw "resources/sunflower.jpg")]

["test/opencv3/video/short_stream5.clj" (render "test/opencv3/video/short_stream5.clj" data)]
["test/opencv3/rotatingcat.clj" (render "test/opencv3/rotatingcat.clj" data)]
["test/opencv3/watermarking.clj" (render "test/opencv3/watermarking.clj" data)]
["test/opencv3/bounding_boxes.clj" (render "test/opencv3/bounding_boxes.clj" data)]
["test/opencv3/warpone.clj" (render "test/opencv3/warpone.clj" data)]
["test/opencv3/siemensstar.clj" (render "test/opencv3/siemensstar.clj" data)]
["test/opencv3/tutorial.clj" (render "test/opencv3/tutorial.clj" data)]
["test/opencv3/video/short_stream4.clj" (render "test/opencv3/video/short_stream4.clj" data)]
["test/opencv3/matching.clj" (render "test/opencv3/matching.clj" data)]
["test/opencv3/shapes2.clj" (render "test/opencv3/shapes2.clj" data)]
["test/opencv3/colormatching.clj" (render "test/opencv3/colormatching.clj" data)]
["test/opencv3/orb.clj" (render "test/opencv3/orb.clj" data)]
["test/opencv3/akazing.clj" (render "test/opencv3/akazing.clj" data)]
["test/opencv3/highlights.clj" (render "test/opencv3/highlights.clj" data)]
["test/opencv3/combine.clj" (render "test/opencv3/combine.clj" data)]
["test/opencv3/memories.clj" (render "test/opencv3/memories.clj" data)]
["test/opencv3/video/find_red.clj" (render "test/opencv3/video/find_red.clj" data)]
["test/opencv3/comparing.clj" (render "test/opencv3/comparing.clj" data)]
["test/opencv3/segmentation.clj" (render "test/opencv3/segmentation.clj" data)]
["test/opencv3/distance_transform.clj" (render "test/opencv3/distance_transform.clj" data)]
["test/opencv3/video/take_one.clj" (render "test/opencv3/video/take_one.clj" data)]
["test/opencv3/average_color.clj" (render "test/opencv3/average_color.clj" data)]
["test/opencv3/floodfill.clj" (render "test/opencv3/floodfill.clj" data)]
["samples/opencv3/applycolormaps.clj" (render "samples/opencv3/applycolormaps.clj" data)]
["test/opencv3/luminosity.clj" (render "test/opencv3/luminosity.clj" data)]
["test/opencv3/movetocenter.clj" (render "test/opencv3/movetocenter.clj" data)]
["test/opencv3/drawsegments.clj" (render "test/opencv3/drawsegments.clj" data)]
["test/opencv3/video/writingv2.clj" (render "test/opencv3/video/writingv2.clj" data)]
["test/opencv3/video/background_substraction.clj" (render "test/opencv3/video/background_substraction.clj" data)]
["test/opencv3/cartoon2.clj" (render "test/opencv3/cartoon2.clj" data)]
["test/opencv3/minarearect.clj" (render "test/opencv3/minarearect.clj" data)]
["test/opencv3/video/movement.clj" (render "test/opencv3/video/movement.clj" data)]
["project.clj" (render "project.clj" data)]
["test/opencv3/video/hand.clj" (render "test/opencv3/video/hand.clj" data)]
["test/opencv3/cartoon4.clj" (render "test/opencv3/cartoon4.clj" data)]
["test/opencv3/video/warping.clj" (render "test/opencv3/video/warping.clj" data)]
["test/opencv3/pipes.clj" (render "test/opencv3/pipes.clj" data)]
["test/opencv3/cartoon3.clj" (render "test/opencv3/cartoon3.clj" data)]
["test/opencv3/detection.clj" (render "test/opencv3/detection.clj" data)]
["test/opencv3/video/writing.clj" (render "test/opencv3/video/writing.clj" data)]
["test/opencv3/warp.clj" (render "test/opencv3/warp.clj" data)]
["test/opencv3/morph.clj" (render "test/opencv3/morph.clj" data)]
["test/opencv3/exposure.clj" (render "test/opencv3/exposure.clj" data)]
["samples/opencv3/photomosaic.clj" (render "samples/opencv3/photomosaic.clj" data)]
["test/opencv3/scaling.clj" (render "test/opencv3/scaling.clj" data)]
["test/opencv3/warpaffine.clj" (render "test/opencv3/warpaffine.clj" data)]
["test/opencv3/gamma.clj" (render "test/opencv3/gamma.clj" data)]
["test/opencv3/sampling.clj" (render "test/opencv3/sampling.clj" data)]
["test/opencv3/touring.clj" (render "test/opencv3/touring.clj" data)]
["test/opencv3/detectblur.clj" (render "test/opencv3/detectblur.clj" data)]
["test/opencv3/bgdiff.clj" (render "test/opencv3/bgdiff.clj" data)]
["test/opencv3/threshes.clj" (render "test/opencv3/threshes.clj" data)]
["test/opencv3/geometrictransformations.clj" (render "test/opencv3/geometrictransformations.clj" data)]
["test/opencv3/video/face_recognition.clj" (render "test/opencv3/video/face_recognition.clj" data)]
["samples/opencv3/changesomecolors.clj" (render "samples/opencv3/changesomecolors.clj" data)]
["test/opencv3/customfilter.clj" (render "test/opencv3/customfilter.clj" data)]
["test/opencv3/samplingandcontours.clj" (render "test/opencv3/samplingandcontours.clj" data)]
["test/opencv3/video/face_recognition2.clj" (render "test/opencv3/video/face_recognition2.clj" data)]
["test/opencv3/seesawing.clj" (render "test/opencv3/seesawing.clj" data)]
["test/opencv3/lena.clj" (render "test/opencv3/lena.clj" data)]
["test/opencv3/video/filter.clj" (render "test/opencv3/video/filter.clj" data)]
["test/opencv3/roi.clj" (render "test/opencv3/roi.clj" data)]
["test/opencv3/threshold.clj" (render "test/opencv3/threshold.clj" data)]
["test/opencv3/dip.clj" (render "test/opencv3/dip.clj" data)]
["test/opencv3/watershed.clj" (render "test/opencv3/watershed.clj" data)]
["test/opencv3/gabor.clj" (render "test/opencv3/gabor.clj" data)]
["test/opencv3/cartoon.clj" (render "test/opencv3/cartoon.clj" data)]
["test/opencv3/histo.clj" (render "test/opencv3/histo.clj" data)]
["test/opencv3/hull.clj" (render "test/opencv3/hull.clj" data)]
["test/opencv3/channels.clj" (render "test/opencv3/channels.clj" data)]
["test/opencv3/first.clj" (render "test/opencv3/first.clj" data)]
["test/opencv3/colors.clj" (render "test/opencv3/colors.clj" data)]
["test/opencv3/matchingshapes.clj" (render "test/opencv3/matchingshapes.clj" data)]
["test/opencv3/hough.clj" (render "test/opencv3/hough.clj" data)]
["test/opencv3/video/movement2.clj" (render "test/opencv3/video/movement2.clj" data)]
["samples/opencv3/makeborder.clj" (render "samples/opencv3/makeborder.clj" data)]
["test/opencv3/matrixes.clj" (render "test/opencv3/matrixes.clj" data)]
["test/opencv3/simple.clj" (render "test/opencv3/simple.clj" data)]
["test/opencv3/shapes.clj" (render "test/opencv3/shapes.clj" data)]
["samples/opencv3/shapefinder.clj" (render "samples/opencv3/shapefinder.clj" data)]
["test/opencv3/video/lemons.clj" (render "test/opencv3/video/lemons.clj" data)]
["test/opencv3/video/affine.clj" (render "test/opencv3/video/affine.clj" data)]
["test/opencv3/zoom.clj" (render "test/opencv3/zoom.clj" data)]
["test/opencv3/video/scaling.clj" (render "test/opencv3/video/scaling.clj" data)]
["test/opencv3/edges.clj" (render "test/opencv3/edges.clj" data)]
["test/opencv3/grabcut.clj" (render "test/opencv3/grabcut.clj" data)]
["test/opencv3/video/twocameras.clj" (render "test/opencv3/video/twocameras.clj" data)]
["test/opencv3/trees.clj" (render "test/opencv3/trees.clj" data)]
["test/opencv3/matching2.clj" (render "test/opencv3/matching2.clj" data)]
["test/opencv3/leftright.clj" (render "test/opencv3/leftright.clj" data)]
["test/opencv3/filter.clj" (render "test/opencv3/filter.clj" data)]
["test/opencv3/sharping.clj" (render "test/opencv3/sharping.clj" data)]
["test/opencv3/video/kalman.clj" (render "test/opencv3/video/kalman.clj" data)]
["test/opencv3/rotating.clj" (render "test/opencv3/rotating.clj" data)]
["samples/opencv3/resizeall.clj" (render "samples/opencv3/resizeall.clj" data)]
["test/opencv3/optical.clj" (render "test/opencv3/optical.clj" data)]
["test/opencv3/video/threshold.clj" (render "test/opencv3/video/threshold.clj" data)]
["test/opencv3/colormaps.clj" (render "test/opencv3/colormaps.clj" data)]
["test/opencv3/rotated_rect.clj" (render "test/opencv3/rotated_rect.clj" data)]
["test/opencv3/video/cartoon.clj" (render "test/opencv3/video/cartoon.clj" data)]
["test/opencv3/video/short_stream1.clj" (render "test/opencv3/video/short_stream1.clj" data)]
["test/opencv3/tennisball.clj" (render "test/opencv3/tennisball.clj" data)]
["test/opencv3/pencilsketch.clj" (render "test/opencv3/pencilsketch.clj" data)]
["test/opencv3/contours.clj" (render "test/opencv3/contours.clj" data)]
["test/opencv3/filtering2d.clj" (render "test/opencv3/filtering2d.clj" data)]
["test/opencv3/video/short_stream3.clj" (render "test/opencv3/video/short_stream3.clj" data)]
["test/opencv3/ok.clj" (render "test/opencv3/ok.clj" data)]
["test/opencv3/seesaw2.clj" (render "test/opencv3/seesaw2.clj" data)]
["samples/opencv3/rotasquare.clj" (render "samples/opencv3/rotasquare.clj" data)]
["samples/opencv3/closecontours.clj" (render "samples/opencv3/closecontours.clj" data)]
["test/opencv3/rotate.clj" (render "test/opencv3/rotate.clj" data)]
["test/opencv3/video/short_stream2.clj" (render "test/opencv3/video/short_stream2.clj" data)]
["test/opencv3/canny.clj" (render "test/opencv3/canny.clj" data)]
["resources/XML/aGest.xml" (render "resources/XML/aGest.xml")]

["resources/XML/palm.xml" (render "resources/XML/palm.xml")]
["resources/XML/face.xml" (render "resources/XML/face.xml")]
["resources/XML/closed_frontal_palm.xml" (render "resources/XML/closed_frontal_palm.xml")]
["resources/XML/fist.xml" (render "resources/XML/fist.xml")]
["resources/XML/haarcascade_eye_tree_eyeglasses.xml" (render "resources/XML/haarcascade_eye_tree_eyeglasses.xml")]
["resources/XML/haarcascade_frontalface_alt2.xml" (render "resources/XML/haarcascade_frontalface_alt2.xml")]
)))