(ns kotr.client.stardog.turtle-builder
  (:require [stardog.values :as values]))

;(def key-identifier "_id")

(def ^:dynamic class-uri "allianz")
(def ^:dynamic instance-uri "data")

(defn as-class-name [input-string]
  (let [words (clojure.string/split input-string #"[\s_-]+")]
    (clojure.string/join "" (cons (clojure.string/capitalize (first words)) (map clojure.string/capitalize (rest words))))))

(defn as-attr-name [input-string]
  (let [words (clojure.string/split input-string #"[\s_-]+")]
    (->> (clojure.string/join "" (cons (clojure.string/lower-case (first words)) (map clojure.string/capitalize (rest words)))))))

(defn as-value [field-schema field-name field-value]
  (let [t (get field-schema field-name)]
    (if t
      (try
        ; (values/convert field-value)
        field-value
        (catch Exception e
          field-value))
      field-value)))

(defn relation-turtle [key-identifier subject type-iden-name field-name field-value]
  (when (and
          (not= type-iden-name field-name)

          (clojure.string/ends-with? (clojure.string/lower-case field-name) key-identifier))
    (let [e-name (clojure.string/replace (clojure.string/lower-case field-name) (re-pattern key-identifier) "")
          w (as-attr-name (str "has_" e-name))
          ;field-value ()
          e-name (as-attr-name e-name #_(str e-name "-id"))

          object (str instance-uri ":" "a" ":" e-name "-" field-value)
          object-as-uri (->> object (values/as-uri))

          type-name (as-class-name e-name)
          class-object-as-uri (values/as-uri (str class-uri ":" "a" ":" type-name))
          predict (str "rdf" ":" "a" ":" "type")]

      [[subject (str class-uri ":" "a" ":" w) object-as-uri]
       [object predict class-object-as-uri]])))



(defn as-turtle-from-entity [config {:keys [key value]}]
  ;(clojure.pprint/pprint config)
  (let [{:keys [type-m topic-name topic-key topic-id-end-with]} config
        key-identifier topic-id-end-with
        type-m (if type-m
                 type-m
                 (into {} (map (fn [v] {v "string"})) (keys value)))

        m value
        predict (str "rdf" ":" "a" ":" "type")
        type-name (as-class-name topic-name)
        object (values/as-uri (str class-uri ":" "a" ":" type-name))]

    (let [identifier (or key
                         (get m topic-key)
                         (get m "id")
                         (get m :id))
          m (assoc m topic-key identifier)

          ;   _ (println "--identifier " identifier "------" topic-key "-------" m)
          ;_ (println "--identifier " type-iden-name)
          ;    _ (println type-iden-name)
          type-iden2 (clojure.string/replace topic-key (re-pattern key-identifier) "")
          ;_ (print "identifier " identifier)
          identifier (clojure.string/join "_" (clojure.string/split identifier #" "))
          ;  _ (println "----------before iden" type-iden2)
          subject (str instance-uri ":" "a" ":" (str (as-attr-name type-iden2) "-" identifier))
          turtle [[subject predict object]]
          xf (comp (remove (fn [[field-name field-value]]
                             (or (nil? field-value)
                                 (and (string? field-value)
                                      (clojure.string/blank? field-value)))))
                   (map (fn [[field-name field-value]]
                          (let [field-name (if (keyword? field-name)
                                             (name field-name)
                                             field-name)
                                ;_ (println "---" field-name)
                                new-field-name (as-attr-name field-name)
                                field-value (as-value type-m new-field-name field-value)

                                out [[subject
                                      (str class-uri ":" "a" ":" new-field-name)
                                      field-value]]
                                out (if-let [w (relation-turtle key-identifier subject topic-key field-name field-value)]
                                      (into out w)
                                      out)]
                            out)))
                   cat)]
      (into turtle xf m))

    #_(into [] xf fields)))


#_(defn avro-to-turtle [context avro-schema v]
    ;(println "--" avro-schema)
    (let [key-identifier (or (get context :topic-id-end-with)
                             "_id")
          n (clojure.string/lower-case (get avro-schema :name))
          avro-key (clojure.string/lower-case (get avro-schema :key))
          type-m (into {} (comp (map (fn [m]
                                       {(clojure.string/lower-case (get m :name))
                                        (second (get m :type))}
                                       ))) (get avro-schema :fields))]
      (as-turtle-from-entity key-identifier n avro-key type-m v)))

(comment


  #_(avro-to-turtle {} {:name :hello :key "hello_id" :fields [{:name "fname" :type "string"}
                                                              {:name "hello_id" :type "string"}
                                                              {:name "other_id" :type "string"}
                                                              ]}
                    [{"fname" "fname" "hello_id" "1" "other_id" 3}]
                    )

  )