(ns ksql.gen.macro.expand-core
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.reader.mapping-reader :as mr]
            [ksql.gen.metadata_schema_gen :as sg]
            [ksql.gen.util :as u]
            [ksql.gen.macro.expand-flow-impl :as f]
            [ksql.gen.macro.metadata-crawler-impl]
            [ksql.gen.macro.expand-step-impl :as s]
            ))






(comment



  (let [grammar-matcher (.getPathMatcher
                          (java.nio.file.FileSystems/getDefault)
                          "glob:*.{csv}")]
    (->> "test/resources"
         clojure.java.io/file
         file-seq
         (filter #(.isFile %))
         (filter #(.matches grammar-matcher (.getFileName (.toPath %))))
         (mapv #(.getName %))
         #_(mapv #(.getAbsolutePath %)))

    )


  (->> (clojure.java.io/file "test/resources")
       (file-seq)
       (filter #(.isFile %))
       ; (first)
       (take 3)
       #_(doall))

  )



(defn replace-this-macro [field-m field]
  ;(println "" field-m)
  (let [

        field (if (= "as" (first field))
                (second field)
                field
                )]
    (clojure.walk/postwalk (fn [v]
                             (if (and (u/is-namespace? v)
                                      (clojure.string/includes? v "this/"))
                               (let [[_ fields-name] (clojure.string/split v #"/")
                                     v (get field-m fields-name)]
                                 (when (nil? v)
                                   (throw (ex-info (get p/msg :100) field)))
                                 v)
                               v)) field)))


(defn expand-this-macro [mapping]
  ;  (p/log-v mapping)
  (let []
    (loop [[field & mapping] mapping
           out []]
      ;(p/log-v field)
      (if (nil? field)
        out
        (let [trans (get field :transfer_fn)
              new-trans (if (clojure.string/includes? (pr-str trans) "this/")
                          (let [m (into {} (comp (map (juxt :field_name :transfer_fn) #_(fn [v] (println v) [(second v) (nth 2 v)]))
                                                 (remove (fn [[v n]] (nil? v)))
                                                 ) out)]
                            (replace-this-macro m trans))
                          trans)
              new-field (assoc field :transfer_fn new-trans)]
          (recur mapping (conj out new-field))
          )
        )
      )
    )

  ;mapping
  )



(defn into-step [result new-steps]
  (let [field-name-set (into #{} (comp (map :field_name)
                                       (remove nil?)
                                       (remove clojure.string/blank?)
                                       ) new-steps)
        result (into [] (remove (fn [v] (contains? field-name-set (get v :field_name))) result))]
    (into result new-steps)))



(defn expand-step-processor [schema-coll mapping-steps]
  (let [mapping-steps mapping-steps
        expand-step-list (-> (into #{} (keys (methods p/expand-step)))
                             (disj :default))
        exapnds-step-sets (-> expand-step-list
                              (into (keys (methods s/expand-step-internal)))
                              (disj :default))]

  ;  (clojure.pprint/pprint exapnds-step-sets)
    (loop [[f & r] mapping-steps
           result []]
      (if (nil? f)
        result
        (if (or (nil? (get f :transfer_fn))
                (not (contains? exapnds-step-sets (first (get f :transfer_fn)))))
          (recur r (into-step result [f]))

          (let [w (if (contains? expand-step-list (first (get f :transfer_fn)))
                    (->> ((juxt :name :field_name :transfer_fn) f)
                         (p/expand-step schema-coll result)
                    ;     (p/log-v)
                         (mr/as-compiler-schema)
                     ;    (p/log-v)
                         (into [] (comp
                                    cat
                                    (map (fn [f]
                                           (s/expand-step-internal schema-coll result f)))
                                    cat
                                    )))

                    (s/expand-step-internal schema-coll result f))

                out (into-step result w)]
            (recur r out)))))))



(defn do-expand-step [schema-coll mapping]
  (->> mapping
       (expand-step-processor schema-coll)
       (expand-this-macro)))



(defn do-expand-flow [schema-coll mapping]
  (let [expand-flow-set (-> (into #{} (keys (methods p/expand-flow)))
                            (disj :default))
        expand-flow-set (-> expand-flow-set
                            (into (keys (methods f/expand-flow-internal)))
                            (disj :default))]
    (if-not (contains? expand-flow-set (first (get (first mapping) :transfer_fn)))
      [mapping]
      (let [xf (comp (remove empty?)
                     (map (fn [v]
                            (if (p/is-terminate-step v)
                              [(p/get-expand-terminate-value v)]
                              (mr/as-compiler-schema v))
                            ))
                     cat
                     (remove empty?)
                     (map (fn [v] (f/expand-flow-internal schema-coll v)))
                     cat)]
        (->> (p/expand-flow schema-coll mapping)
             (into [] xf))))))



#_(defn do-expand-macro [schema-coll mapping]

    (->> (do-expand-flow schema-coll mapping)
         (into [] (map (fn [m] (do-expand-step schema-coll m))))
         ))
