(ns ksql.metadata-api
  (:require [ksqldb.client :as c]))


(defn get-ksqldb-schema [context]
  (let [stream-xf (map (fn [m]
                         (let [out (c/invoke context "describe-stream" (get m :name) #_{:op  :request })
                               fields (get out :fields)
                               key-name (reduce (fn [acc f]
                                                  (when (= "KEY" (get f :type))
                                                    (reduced (clojure.string/lower-case (get f :name)))
                                                    )
                                                  ) nil fields)
                               out (-> out                  ;(dissoc out :writeQueries :readQueries)
                                       (update :name clojure.string/lower-case)
                                       (assoc :key key-name #_(fn [v]
                                                                (when v
                                                                  (clojure.string/lower-case (last (clojure.string/split v #"\.")))
                                                                  )
                                                                ))
                                       (update :fields (fn [v]
                                                         (into []
                                                               (comp
                                                                 (remove (fn [m]
                                                                           (= "rowkey" (clojure.string/lower-case (get m :name)))
                                                                           ))
                                                                 (map (fn [m]
                                                                        (assoc m :name (clojure.string/lower-case (get m :name)))
                                                                        )))
                                                               v #_(drop 2 v)))))]
                           {(clojure.string/lower-case (get m :name)) out})))
        table-xf (map (fn [m]
                        (let [out (c/invoke context "describe-table" (get m :name)  #_{:op  :request })
                              fields (get out :fields)
                              key-name (reduce (fn [acc f]
                                                 (when (= "KEY" (get f :type))
                                                   (reduced (clojure.string/lower-case (get f :name)))
                                                   )
                                                 ) nil fields)

                              out (-> out #_(dissoc out :writeQueries :readQueries)
                                      (update :name clojure.string/lower-case)
                                      ;(update :key clojure.string/lower-case)
                                      (assoc :key key-name #_(fn [v]
                                                               (when v
                                                                 (clojure.string/lower-case (last (clojure.string/split v #"\.")))
                                                                 )

                                                               ))
                                      (update :fields (fn [v]
                                                        (into []
                                                              (comp (remove (fn [m]
                                                                              (= "rowkey" (clojure.string/lower-case (get m :name)))
                                                                              ))
                                                                    (map (fn [m]
                                                                           (assoc m :name (clojure.string/lower-case (get m :name)))
                                                                           )))
                                                              v #_(drop 2 v)))))]
                          {(clojure.string/lower-case (get m :name)) out})))

        server-entity-schema-m (into {} stream-xf (c/invoke context "show-streams" ))
        server-entity-schema-m (into server-entity-schema-m table-xf (c/invoke context "show-tables" ))]
    server-entity-schema-m))





#_(defn get-source-name-from-sql-str [sql-str]
  (let [v (-> (clojure.string/trim sql-str)
              (clojure.string/split #"FROM")
              (last))]
    (if (clojure.string/includes? v "JOIN") #_(< 1 (count source-list))
      (-> (first (clojure.string/split v #"ON"))
          (clojure.string/replace "LEFT OUTER JOIN" "")
          (clojure.string/replace "\n" "")
          (clojure.string/split #" ")
          (distinct)
          (->> (remove clojure.string/blank?)))
      (-> v
          (clojure.string/trim)
          (clojure.string/split #" ")
          (first)
          (vector)))))

#_(comment
  (get-source-name-from-sql-str "INSERT INTO CUST_STAGE SELECT  cust_raw_enrich.id  AS id ,
   cust_raw_enrich.name  AS name  FROM CUST_RAW_ENRICH CUST_RAW_ENRICH left join t on t.io=u.io;")


  (get-source-name-from-sql-str

    "CREATE STREAM CUST_RAW_ENRICH WITH (KAFKA_TOPIC='cust_raw_enrich', PARTITIONS=1, REPLICAS=1, VALUE_FORMAT='AVRO') AS SELECT
                                  CUST_RAW.ID ID,
                                  CUST_STAGE_TAB.ID OLD_ID,
                                  CUST_RAW.NAME NAME
                                FROM CUST_RAW CUST_RAW
                                LEFT OUTER JOIN CUST_STAGE_TAB CUST_STAGE_TAB ON ((CUST_RAW.ID = CUST_STAGE_TAB.ID))
                                EMIT CHANGES;"
    )

  (get-source-name-from-sql-str
    "INSERT INTO CUST_RAW_ENRICH SELECT  cust_raw.id  AS id , cust_stage_tab.id  AS old_id , cust_raw.name  AS name  FROM CUST_RAW CUST_RAW  left join cust_stage_tab cust_stage_tab  ON cust_raw.id = cust_stage_tab.id;"
    )

  )





#_(defn ksqldb-metadata [context]
  (->> (get-ksqldb-schema context)
       (vals)
       (into [] (map (fn [m]
                       (let [q-coll (get m :writeQueries)
                             query-coll (into [] (comp
                                                   (map :queryString)
                                                   ;   (filter (fn [v] (clojure.string/starts-with? v "INSERT")))
                                                   (map get-source-name-from-sql-str)
                                                   cat
                                                   (map clojure.string/lower-case)
                                                   ) q-coll)
                             source-coll (into [] (distinct query-coll))]
                         (-> (assoc m :sink-name (get m :name) :source-name source-coll)
                             ;   (dissoc :writeQueries :statement :readQueries)
                             )))))))



