(ns ksql.gen.core-type-processor
  (:require [ksql.gen.protocol :as p])
  )



(defn get-source-name-from-fields [transfer_fn]
  (->> transfer_fn
       rest
       (filter (fn [v]
                 (clojure.string/includes? v "/")))
       (remove (fn [v]
                 (clojure.string/starts-with? v "'")))
       (flatten)
       (first)))

(comment

  (get-source-name-from-fields ["as" "'ref_mapping2/id'"])

  )




(defn apply-type-cast? [source-type sink-type]
  (if (and source-type
           sink-type
           (contains? #{"int" "integer" "double" "bigint"} (clojure.string/lower-case (first sink-type)))
           (contains? #{"string"} (clojure.string/lower-case (first source-type))))
    true
    false))


;SELECT PERSON_RAW3.id AS id , CAST ( PERSON_RAW3.value AS bigint ) AS value
;FROM PERSON_RAW3 PERSON_RAW3
;where  CAST ( person_raw3.value AS bigint ) <> 0 and  person_raw3.value is not null
;     or
;      CAST ( person_raw3.value AS bigint ) = 0
;emit changes ;

(defn build-expression-for-type-cast [s-name source-type sink-type]
  (let [[f & r :as w] s-name
        s-name (if (= "as" f)
                 (second w)
                 w)]
    ["castable" s-name source-type sink-type]
    #_(cond
        (or (clojure.string/includes? sink-type "int")
            (clojure.string/includes? sink-type "double"))

        #_["or"
           ["=null" s-name]
           ["and"
            ["!=null" s-name]
            ["or"
             ["=" 0 ["cast" s-name sink-type]]
             ["<>" 0 ["cast" s-name sink-type]]]]]
        :else
        nil)
    )
  )

(defn as-where-expression [type-convert-where]
  (let [type-convert-where (into [] (remove nil?) type-convert-where)
        type-convert-where (into [] (distinct type-convert-where))
        ]
    (cond
      (= 1 (count type-convert-where))
      (into ["where_for_type_cast"] type-convert-where)
      (< 1 (count type-convert-where))
      ;(into )
      ["where_for_type_cast" (into ["and"] type-convert-where)]
      :else
      nil)))


(defn build-error-expression-for-type-cast [s-name source-type sink-type]
  (let [[f & r :as w] s-name
        s-name (if (= "as" f)
                 (second w)
                 w)]
    ["!castable" s-name source-type sink-type]
    #_(cond
        (or (clojure.string/includes? sink-type "int")
            (clojure.string/includes? sink-type "double"))
        ["!castable" s-name source-type sink-type]
        #_["and"
           ["!=null" s-name]

           ["=" 0 ["cast" s-name sink-type]]]
        :else
        nil)
    )
  )


(defn as-error-expression [type-convert-where]
  (let [type-convert-where (into [] (remove nil?) type-convert-where)
        type-convert-where (into [] (distinct type-convert-where))
        ]
    (cond
      (= 1 (count type-convert-where))
      (into ["error_for_type_cast"] type-convert-where)
      (< 1 (count type-convert-where))
      ;(into )
      ["error_for_type_cast" (into ["or"] type-convert-where)]
      :else
      nil)))



(defn get-source-type [st]
  (let [source-type (loop [out []
                           m st]
                      (if (nil? m)
                        (into [] (reverse out))
                        (let [out (conj out (get m :type))]
                          (recur out (get m :member_schema)))))
        source-type (if (empty? source-type) nil source-type)]
    source-type))


(defn add-source-type-batch [schema-coll flow-mapping]
  (let [schema-m (reduce (fn [acc v]
                           (let [sink-name (get v :sink-name)]
                             (if (get acc sink-name)
                               acc
                               (merge acc (into {} (map (fn [m]
                                                          {(str sink-name "/" (get m :name)) (get-in m [:schema])}
                                                          )) (get v :fields)))))
                           ) {} schema-coll)
        ; _ (clojure.pprint/pprint schema-m)
        type-cast-expression (atom [])
        error-expression (atom [])
        sink-name (get (first flow-mapping) :name)
        xf (map (fn [step-mapping]
                  ;   (println "--" step-mapping)
                  (if (get step-mapping :field_name)
                    (let [s-name (get-source-name-from-fields (get step-mapping :transfer_fn))
                          st (when-let [v (get schema-m s-name)] v)
                          source-type (get-source-type st)

                          sink-type (get-source-type (get schema-m (str (get step-mapping :name) "/" (get step-mapping :field_name))))

                          sink-type (or sink-type
                                        (get step-mapping :field_type)
                                        source-type
                                        ["string"])]

                      ;   (println source-type "--" sink-type "--"(get step-mapping :transfer_fn))

                      (if (apply-type-cast? source-type sink-type)
                        (do
                          (->> (build-expression-for-type-cast (get step-mapping :transfer_fn) (first source-type) (first sink-type))
                               (swap! type-cast-expression conj))

                          (->> (build-error-expression-for-type-cast (get step-mapping :transfer_fn) (first source-type) (first sink-type))
                               (swap! error-expression conj))

                          (-> (assoc step-mapping :field_type sink-type :source-type st)
                              (update :transfer_fn (fn [[f & r :as w]]
                                                     (if (= "as" f)
                                                       ["as" ["cast" s-name (first sink-type)]]
                                                       ["cast" w (first sink-type)])))))
                        (assoc step-mapping :field_type sink-type :source-type st)))
                    step-mapping)))
        out (into [] xf flow-mapping)

        out (if-let [v (as-where-expression @type-cast-expression)]
              (conj out {:name        sink-name
                         :transfer_fn v})
              out
              )

        out (if-let [v (as-error-expression @error-expression)]
              (conj out {:name        sink-name
                         :transfer_fn v})
              out
              )

        ]

    ; (clojure.pprint/pprint flow-mapping)
    ;  (clojure.pprint/pprint v)

    ;@todo need to auto type cast check
    ;    out
    out
    #_(if v
        (conj out v)
        out)))


(defn as-json-fields [source-name fields]
  (let [w (reduce (fn [acc v]
                    (conj acc [(str "'" v ":' ") (str source-name "/" v)])

                    ) [] fields)
        w (interpose "," w)
        w (flatten w)
        w (into ["concat" "{"] w)
        w (conj w " }")
        ]
    w
    )

  #_(let [out (into [] (comp
                         (map (fn [f]
                                [(str "'" f ":'") ["ifnull" (str source-name "/" f) "'null'"]]
                                ;(str "'" f ":'" " (ifnull " source-name "/" f " 'null'" ")")
                                ))
                         cat

                         )

                    fields)
          ;out (clojure.string/join " ',' " w )
          out (interpose "," out)
          ]
      ["concat" "{" out "}"]
      #_(str "(concat '{' " out "  '}'  )")))





(defn map-to-error-table [md-repo mapping]

  ;(clojure.pprint/pprint mapping)
  (let [w (into [] (comp
                     (map :transfer_fn)
                     (remove nil?)
                     (distinct)
                     (filter (fn [v] (= "error_for_type_cast" (first v))))
                     (map second)
                     ) mapping)
        w (first w)

        dq-check (into [] (comp
                            (map :transfer_fn)
                            (remove nil?)
                            (distinct)
                            (filter (fn [v] (= "dq_check" (first v))))
                            (map (fn [v] (assoc v 0 "!dq_check") ))
                            ;   (map second)
                            ) mapping)
        w (if  (empty? w)
            (if (empty? dq-check)
              []
              (into ["or"] dq-check)

              )

            (into ["or"] (conj dq-check w))

            )

        ]

    ; (println w)
    ;(clojure.pprint/pprint dq-check)

    (when-not (empty? w)
      ;  (p/log-v mapping)

      (let [
            ;_ (clojure.pprint/pprint w)
            e-name-coll (into [] (comp
                                   (map :name)
                                   (remove nil?)
                                   (distinct)
                                   ) mapping)
            target-name (first e-name-coll)
            source-coll (into [] (comp (filter (fn [f]
                                                 (clojure.string/includes? f "/")
                                                 ))
                                       (distinct)
                                       (map (fn [v] (first (clojure.string/split v #"/"))))
                                       (distinct)
                                       ) (flatten w))
            source-name (first source-coll)

            field-name (p/get-property-names md-repo source-name)
            json-field (as-json-fields source-name field-name) #_(into [])
            ;source-name (u/get-source-name2 w)
            ]
        ;(println  " e-name " target-name "" source-name "--w" json-field)

        [{:name        "error"
          :field_name  "cause"
          :field_type  ["string"],
          :transfer_fn ["concat" (str "'"  " ' ")]}

         {:name        "error"
          :field_name  "cause_des"
          :field_type  ["string"],
          :transfer_fn ["constant" (str "'dq error '")]}

         {:name        "error"
          :field_name  "cause_id"
          :field_type  ["string"],
          :transfer_fn ["concat" "1"]}

         {:name        "error"
          :field_name  "source_name"
          :field_type  ["string"],
          :transfer_fn ["constant" source-name]}

         {:name        "error"
          :field_name  "event_time_stamp"
          :field_type  ["string"],
          :transfer_fn ["TIMESTAMPTOSTRING" (str source-name "/rowtime") "'yyyy-MM-dd HH:mm:ss.SSS'"]}

         ;         TIMESTAMPTOSTRING(ROWTIME, 'yyyy-MM-dd HH:mm:ss.SSS' [, TIMEZONE])


         {:name        "error"
          :field_name  "target_name"
          :field_type  ["string"],
          :transfer_fn ["constant" target-name]}

         {:name        "error"
          :field_name  "source_value"
          :field_type  ["string"],
          :transfer_fn json-field}


         {:name        "error"
          :field_name  nil
          :transfer_fn ["where" w]}

         ]))))
