(ns ksql.gen
  (:require [ksql.gen.core :as mc]
           ; [ksql.client :as client]
            [ksql.gen.util :as u]
            [ksql.gen.protocol :as p]
            [ksql.gen.emitter.ksql.core :as kc]
            [ksql.gen.emitter.ksql :as eksql]))


(defn get-reader-type [v]
  (if (string? v) :csv :default))

#_(defn as-schema-map [schema-coll]
    (into {} (map (fn [[k v]]
                    {k v #_(first v)})) (group-by :sink-name schema-coll)))

(defn gen-schema
  ([mapping] (gen-schema {} [] mapping))
  ([context mapping] (gen-schema context [] mapping))
  ([context schema-coll mapping]
   (binding [p/gcontext context]
     (->> mapping
          (p/read-req (or (get context :reader) (get-reader-type mapping)))
          ;(p/log-v)
          (mc/do-compile-batch schema-coll))
     )

    )
  )

(defn gen-mapping [context schema mapping]
  (->>
       (p/read-req  (or (get context :reader) :triple ) mapping)
     ;  (p/expand-flow schema)
       )

  )


(defn do-process [context schema-coll mapping]
  (binding [kc/current-context context]
    (->> (gen-schema context schema-coll mapping)
         ;(p/log-v)
         (into [] (comp
                    (remove (fn [schema-m] (= "struct" (get schema-m :type)) ))
                    (map (fn [schema-m]
                           (assoc schema-m :statement (p/gen-ksql schema-m))))
                    ) ))))






(defn gen-ksql-by-mapping
  ([mapping] (gen-ksql-by-mapping {} [] mapping))
  ([context mapping] (gen-ksql-by-mapping context [] mapping))
  ([context schema-coll mapping]
   (->> (do-process context schema-coll mapping)
        ;(remove (into #{} schema-coll) )
        (split-at (count schema-coll))
        (second)
        (into [] (comp (map :statement) cat))
        ;(remove (into #{} schema-coll) )
        ;(map-ksql context)
        )
    #_(binding [kc/current-context context]
        (->> (gen-schema context schema-coll mapping)
             (into [] (comp (map p/gen-ksql) cat))))))



(defn gen-ksql-by-file [context topic-name file-path]
  (let [w (last (clojure.string/split file-path #"\."))
        file-type (clojure.string/lower-case w)
        v (condp = file-type
            "json" (str "(load_md_from_json_file \"" file-path "\" )")
            "csv" (str "(load_md_from_csv_file \"" file-path "\" )")
            "xml" (str "(load_md_from_xml_file \"" file-path "\" )")
            (throw (Exception. "type does not supported, only supprt file xml, csv, json ")))
        mapping [topic-name "_" v
                 topic-name "_" "(value_format 'json' )" ";"]]
    (gen-ksql-by-mapping context mapping)))



(defn get-source-schema [ksqldb-schema-m-coll source-name]

  (reduce (fn [acc schema]
            ;(println "--" (get schema :name) source-name)
            (if (= (clojure.string/lower-case (get schema :name))
                   (clojure.string/lower-case source-name)
                   )
              (reduced schema)
              acc
              )
            ) nil ksqldb-schema-m-coll )
  )

(defn get-stream-and-query-id [ksqldb-schema-m-coll stream-names]
  ;(println "--stream name " stream-names)
  (let [

        w (into [] (map (fn [v]
                          (get-source-schema ksqldb-schema-m-coll v)
                          )) stream-names)  #_(select-keys (into {} (map (fn [m] {(get m :sink-name) m})) ksqldb-schema-m-coll) stream-names)

      ;  _ (println "--" w)
        deleted-schema (into [] (reverse w))
       ; _ (println "------------------")
        ;_ (p/log-v deleted-schema)
        queries-id (->> deleted-schema
                        (into [] (comp (map (fn [v]

                                              (into (get v :readQueries) (get v :writeQueries))
                                              ))
                                       cat
                                       (map :id)))
                        (distinct)
                        (into []))
        topics-name (->> deleted-schema
                         (into [] (map :topic))
                         (distinct)
                         (into []))
        stream-m (->> deleted-schema
                      (into [] (map (juxt :type :name)))

                      (group-by first)
                      ;(p/log-v)
                      (reduce-kv (fn [acc k v]
                                   (assoc acc (clojure.string/lower-case k) (distinct (mapv second v)))
                                   ) {}))

        ;[q-list stream-m-list topics-name :as out] (get-delete-queries deleted-schema)
        ]
    [queries-id stream-m topics-name]
    )
  )


#_(defn delete-dataflow-req [context schema-m-coll mapping]
    (let [[q-list stream-m-list topics-name :as out] (get-stream-and-query-id context schema-m-coll mapping)
          ksql (eksql/gen-drop-stream q-list stream-m-list)]
      ksql))

#_(defn gen-drop-ksql-statement [stream-names with-topic?]

    )


(defn gen-drop-ksql
  ([context ksqldb-schema-coll stream-names] (gen-drop-ksql context ksqldb-schema-coll stream-names false))
  ([context ksqldb-schema-coll stream-names with-topic?]
   (let [
         [q-list stream-m-list topics-name :as out] (get-stream-and-query-id ksqldb-schema-coll stream-names)
       ;  _ (println "get drop --" stream-m-list " -- " q-list " -- " topics-name)
         ksql (if with-topic?
                (eksql/gen-drop-stream-with-topic q-list stream-m-list)
                (eksql/gen-drop-stream q-list stream-m-list))

         ;   _ (println "--" ksql )
         schema-names (into [] (map (fn [v]
                                      (str v "-value")
                                      )) topics-name)
         ]
     {:ksql ksql :topic topics-name :schema schema-names}))
  )


;;;;;;;;;;;;;;



