(ns ksql.core
  (:require [clojure.tools.reader.edn :as edn]
            ;[ksql.gen :as gen]
           ; [ksql.metadata-api :as md]
            [ksql.gen.protocol :as p]
            ;[ksqldb.client.protocol :as client-pro]
            [ksqldb.client :as client]
           ; [ksql.gen :as gen]
            ;[ksql.gen-connector :as conn]
            ;[ksql.gen.reader.csv-data-reader :as r]
            ;[ksql.gen.reader.mapping-reader]           ;; reader plugin
           ; [ksql.dataflow-impl :as pipeline]               ;; pipeline plugin
            ;[clojure.tools.logging :as log]
            #_[cheshire.core :as json]))


(defrecord MetaDataInMemoryRepo [x-atom]
  p/MDRepo
  (-get-all-metadata [this]
    (into [] cat @x-atom))

  (-push-metadata [this new-schema-m-coll]
    (swap! x-atom conj new-schema-m-coll))

  (-peek-metadata [this]
    (let [mapping-schema-coll (last @x-atom)]
      ;(swap! x-atom (fn [v] (into [] (butlast v))))
      mapping-schema-coll))

  (-pull-metadata [this]
    (let [mapping-schema-coll (last @x-atom)]
      (swap! x-atom (fn [v] (into [] (butlast v))))
      mapping-schema-coll)))


(defn new-metadata-repo []
  (->MetaDataInMemoryRepo (atom [])))

;(def context (init-context))

(defn get-default-context [] {:kafka-rest-url "http://localhost:8082"
                              :schema-url     "http://localhost:8081"
                              :connector-url  "http://localhost:8083"
                              :ksql-url       "http://localhost:8088"
                              :kafka-broker   "localhost:9092"
                              :partitions     1
                              :join-window    "WITHIN 5 MINUTES"
                              :join-split     false
                              :offline        false
                              :reader         :triple       ;; default reader
                              :query-id-m     (atom {})
                              :metadata-repo (new-metadata-repo) #_(atom [])})


(defn get-version [] "0.11.0-2-snapshot")


(def context nil)


(defn load-app-config [app-file]
  (-> (slurp app-file)
      (edn/read-string)))


(defn init-context
  "Init app with new context, context contains kafka url, partition no etc. "
  ([]
   (init-context {}))
  ([m]
   (let [m (if (string? m)
             (load-app-config m)
             m)
         m (merge (get-default-context) m)
         m (if (get m :offline)
             m
             (client/init-client m))]
     (alter-var-root #'context (constantly m)))))

(defn update-context [m]
  (alter-var-root #'context (constantly m)))


(defn reset-md-repo [context md-repo]
  (->> (assoc context :metadata-repo md-repo)
       (constantly )
       (alter-var-root #'context )))


(defn get-context []
  (when (nil? context)
    (init-context))
  context)


#_(defn ksql
  "Execute ksql statement to KSQL server. KSQL server URL must need to be configured in context  "
  [ksql-str]
  (client/ksql (get-context) ksql-str))





#_(defn invoke-dataflow
  [op-name request]
  (p/invoke-dataflow op-name (get-context) request))





#_(defn count-topic-row
  "Count total record in topic, Client will be blocked until finished it. "
  [topic-name]
  0
  #_(client-pro/count-topic-row client-pro/context topic-name))



#_(defn get-ksqldb-schema
  "Return current schema from Kafka schema registry "
  []
  (md/get-ksqldb-schema (get-context))
  ;(gen/get-schema)
  )



(defn show-api-doc []

  (->> [
        {:api "init-context" :doc "start compiler with kafka context" :usage "(init-context \" context file path \" )" :type "Ingestion API"}

        {:api "show-connectors-status" :doc "Show connector status " :usage "(invoke-kafka \"show-connectors-status\" \"{connector_name}\"  ) " :type "Kafka API"}
        {:api "show-connectors" :doc "Show connector list " :usage "(invoke-kafka \"show-connectors\"  )" :type "Kafka API"}
        {:api "create-connector-batch" :doc "Create list of connector in kafka  " :usage "(invoke-kafka \"create-connector-batch\" \" {list of connector config} \"  )" :type "Kafka API"}
        {:api "delete-connector" :doc "Delete connector " :usage "(invoke-kafka \"delete-connector\" \" {connector_name}\"  )" :type "Kafka API"}
        {:api "delete-all-connector" :doc "Describe details of stream " :usage "(invoke-kafka \"delete-all-connector\"  )" :type "Kafka API"}
        {:api "pause-connector" :doc "Pause connector " :usage "(invoke-kafka \"pause-connector\" \"{connector_name}\" )" :type "Kafka API"}
        {:api "resume-connector" :doc "Resume connector " :usage "(invoke-kafka \"resume-connector\" \"{connector_name}\" )" :type "Kafka API"}
        {:api "create-connector" :doc "Create source or sink connector in kafka   " :usage "(invoke-kafka \"create-connector\" \"{connector_config}\" )" :type "Kafka API"}
        {:api "describe-connector" :doc "Details of connector   " :usage "(invoke-kafka \"describe-connector\" \"{connector_name}\" )" :type "Kafka API"}

        {:api "show-streams" :doc "Display list of streams " :usage "(invoke-kafka \"show-streams\" )" :type "Kafka API"}
        {:api "show-streams-name" :doc "Display list of stream name " :usage "(invoke-kafka \"show-streams-name\" )" :type "Kafka API"}
        {:api "describe-stream" :doc "Describe details of stream " :about "TODO" :usage "(invoke-kafka \"describe-stream\" \"{stream_name}\" )" :type "Kafka API"}
        {:api "drop-stream" :doc "remove stream " :usage "(invoke-kafka \"drop-stream\" )" :type "Kafka API"}


        {:api "show-tables" :doc "Show tables list  " :usage "(invoke-kafka \"show-tables\"  )" :type "Kafka API"}
        {:api "show-table-name" :doc "List of kafka table " :about "TODO" :usage "(invoke-kafka \"show-table-name\")" :type "Kafka API"}
        {:api "describe-table" :doc "Details of table  " :about "(invoke-kafka \"describe-table\" \"{table_name}\" )" :type "Kafka API"}

        {:api "show-topics" :doc "Display list of topics " :usage "(invoke-kafka \"show-topics\" )" :type "Kafka API"}
        {:api "describe-topic" :doc "Describe details of topic " :usage "(invoke-kafka \"describe-topic\"  )" :type "Kafka API"}

        {:api "show-functions" :doc "Display list of functions in ksql " :usage "(invoke-kafka \"show-functions\" )" :type "Kafka API"}
        {:api "description-function" :doc "Display function documentation from kafka " :usage "(invoke-kafka \"description-function\" )" :type "Kafka API"}


        {:api "register-schema" :doc "Describe details of topic " :usage "(invoke-kafka \"register-schema\" \"{schema_details}\"  )" :type "Kafka API"}
        {:api "delete-schema" :doc "Delete schema for topics " :usage "(invoke-kafka \"delete-schema\" )" :type "Kafka API"}
        {:api "show-schemas" :doc "List of topic schema   " :usage "(invoke-kafka \"show-schemas\" )" :type "Kafka API"}
        {:api "describe-schema" :doc "Show connector status " :usage "(invoke-kafka \"describe-schema\" \"{schema_name}\"  )" :type "Kafka API"}




        {:api "ksql" :doc "KSQL api adaptor, push ksql to ksqldb " :usage "(ksql \" ksql_statement \" )" :type "Kafka API"}
        {:api "query-by-total" :doc "Run query on ksqldb with time " :usage "(query \" ksql_query|stream \", total_row )" :type "Kafka API"}

        {:api "print-stream" :doc "Print stream from ksqldb " :usage "(print-stream \" stream name \" )" :type "Kafka API"}

        {:api "print-topic" :doc "print kafka topic in terminal, async operation " :usage "(print-topic \" topic name \" )" :type "data API"}
        {:api "print-query" :doc "Run query on ksqldb and print value, async operation " :usage "(print-query \" ksql_query|stream_name \" )
                                                                                         or (print-query \" ksql_query or stream_name \" earliest )" :type "data API"}


        {:api "terminate-query" :doc "Terminal query " :usage "(terminate-query \" query id \" )" :type "Kafka API"}

        {:api "get-ksqldb-schema" :doc "Get full schema from kafka  " :usage "(get-ksqldb-schema)" :type "Ingestion API"}


        {:api "get-schema" :doc "Return full schema from compiler  " :usage "(get-schema)" :type "Ingestion API"}

        ;; Generator API

        {:api "gen-ksql-by-mapping" :doc "Gen ksql statement based on mapping " :usage "(gen-ksql \" mapping or mapping file \" )" :type "Ingestion Generation API"}
        {:api "gen-ksql-by-file" :doc "Gen ksql statement based on mapping " :usage "(gen-ksql \" mapping or mapping file \" )" :type "Ingestion Generation API"}
        {:api "gen-schema" :doc "Gen compiler schema " :usage "(gen-schema \" mapping \" )" :type "Ingestion Generation API"}
        {:api "gen-source-connector" :doc "Gen source connector based on mapping " :usage "(gen-source-connector \" source connector mapping \" )" :type "Ingestion Generation API"}
        {:api "gen-sink-connector" :doc "Gen sink connector based on mapping " :usage "(gen-sink-connector \" sink connector mapping \" )" :type "Ingestion Generation API"}


        {:api "create-dataflow" :doc "Create ksql statement based on mapping, push to kafka " :usage "(invoke-dataflow create-dataflow \" {mapping } \")" :type "Ingestion API"}
        {:api "show-dataflow" :doc "show dataflow from kafka " :usage "(invoke-dataflow show-dataflow \" {mapping } \")" :type "Ingestion API"}
        {:api "create-source-connector" :doc "create source connector based on mapping " :usage "(invoke-dataflow \"create-source-connector\" \"{source_connector_mapping or file }\")" :type "Ingestion API"}
        {:api "pause-source-connector" :doc "pause source connector based on mapping " :usage "(invoke-dataflow \"pause-source-connector\" \"{source_connector_mapping or file }\")" :type "Ingestion API"}
        {:api "resume-source-connector" :doc "resume source connector based on mapping " :usage "(invoke-dataflow \"pause-source-connector\" \"{source_connector_mapping or file }\")" :type "Ingestion API"}
        {:api "create-sink-connector" :doc "create sink connector based on mapping " :usage "(invoke-dataflow \"create-source-connector\" \"{sink_connector_mapping or file }\")" :type "Ingestion API"}

        {:api "export-ksql-to-file" :doc "create ksql based on mapping and save as file " :usage "(export-ksql-to-file \"Export file name \" \"mapping file \"  )" :type "Pipeline Generator API"}
        {:api "import-ksql-from-file" :doc "Push ksql file to ksql server  " :usage "(import-ksql-from-file \"KSQL file name \" )" :type "Pipeline Generator API"}


        {:api "push-edn-event" :doc "create push edn event " :usage "(push-edn-event topic_name end_data_coll)" :type "data import api"}
        {:api "push-json-event" :doc "create push json event " :usage "(push-json-event topic_name json_data_coll)" :type "data import api"}
        {:api "push-file" :doc "push file, it will create model on fly " :usage "(push-file topic_name file_path)" :type "data import api"}
        {:api "push-meta-model" :doc "import meta model from directory  " :usage "(push-meta-model dir_name)" :type "data import api"}
        {:api "push-directory" :doc "push directory, internally it use push-file " :usage "(push-directory dir_name)" :type "data import api"}

        ]


       (clojure.pprint/print-table)
       )

  )


