(ns ksql.metadata-api
  (:require [ksqldb.client :as c]))


(defn get-ksqldb-schema [context]
  (let [stream-xf (map (fn [m]
                         (let [out (c/invoke context "describe-stream" (get m :name) #_{:op  :request })
                               fields (get out :fields)
                               key-name (reduce (fn [acc f]
                                                  (when (= "KEY" (get f :type))
                                                    (reduced (clojure.string/lower-case (get f :name)))
                                                    )
                                                  ) nil fields)
                               out (-> out                  ;(dissoc out :writeQueries :readQueries)
                                       (update :name clojure.string/lower-case)
                                       (assoc :key key-name #_(fn [v]
                                                                (when v
                                                                  (clojure.string/lower-case (last (clojure.string/split v #"\.")))
                                                                  )
                                                                ))
                                       (update :fields (fn [v]
                                                         (into []
                                                               (comp
                                                                 (remove (fn [m]
                                                                           (= "rowkey" (clojure.string/lower-case (get m :name)))
                                                                           ))
                                                                 (map (fn [m]
                                                                        (assoc m :name (clojure.string/lower-case (get m :name)))
                                                                        )))
                                                               v #_(drop 2 v)))))]
                           {(clojure.string/lower-case (get m :name)) out})))
        table-xf (map (fn [m]
                        (let [out (c/invoke context "describe-table" (get m :name)  #_{:op  :request })
                              fields (get out :fields)
                              key-name (reduce (fn [acc f]
                                                 (when (= "KEY" (get f :type))
                                                   (reduced (clojure.string/lower-case (get f :name)))
                                                   )
                                                 ) nil fields)

                              out (-> out #_(dissoc out :writeQueries :readQueries)
                                      (update :name clojure.string/lower-case)
                                      ;(update :key clojure.string/lower-case)
                                      (assoc :key key-name #_(fn [v]
                                                               (when v
                                                                 (clojure.string/lower-case (last (clojure.string/split v #"\.")))
                                                                 )

                                                               ))
                                      (update :fields (fn [v]
                                                        (into []
                                                              (comp (remove (fn [m]
                                                                              (= "rowkey" (clojure.string/lower-case (get m :name)))
                                                                              ))
                                                                    (map (fn [m]
                                                                           (assoc m :name (clojure.string/lower-case (get m :name)))
                                                                           )))
                                                              v #_(drop 2 v)))))]
                          {(clojure.string/lower-case (get m :name)) out})))

        server-entity-schema-m (into {} stream-xf (c/invoke context "show-streams" ))
        server-entity-schema-m (into server-entity-schema-m table-xf (c/invoke context "show-tables" ))]
    server-entity-schema-m))



