(ns ksql.gen.schema-gen
  (:require [ksql.gen.file-util :as u]
            [ksql.gen.util :as cu]
            [ksql.gen.protocol :as p]))


(def arvo-p-type #{"string" "varchar" "bytes" "double" "float" "long" "int" "integer" "bigint" "boolean" "decimal" "null"})

(defn arvo-type-map [n]
  (if (contains? arvo-p-type (clojure.string/lower-case (or n "string")))
    n
    "string"))



(defn as-vector [trans-fn]
  (clojure.walk/postwalk (fn [v]
                           (if (list? v)
                             (into [] v)
                             v
                             )) trans-fn))




#_(defn process-fields [mapping]
    (let [source-name (cu/get-source-name2 mapping)
          sink-name (get-in mapping [0 :name])]
      {:sink-name   sink-name
       :source-name source-name
       :fields      mapping}))

#_(defn add-logical-type [m]
    ;(println "--" m)
    (if (get m :type)
      (let [type (get m :type "string")]
        (assoc m :type type #_(arvo-type-map type)

                 ))
      m
      )
    )




(defn as-emitter-schema [schema-coll-m mapping]
  ;(p/log-v mapping)
  (let [source-name (cu/get-source-name2 mapping)
        sink-name (get-in mapping [0 :name])

        {:keys [topic partition stream-type]} (first mapping)

        main-m {:sink-name   sink-name
                :source-name source-name
                ;  :type        (or stream-type "stream")
                :partitions  partition
                :topic       topic}


        schema-m {}
        ;@todo key come as tranformation fn, need to remove this functionality. key should be attached as field
        key-field (->> mapping
                       (mapv :transfer_fn)
                       (remove nil?)
                       (filter (fn [v] (= "key" (first v))))
                       (first)
                       (second))

        ;_ (println "--" key-field)
        fields (into [] (comp
                          (remove (fn [v] (nil? (:field_name v))))
                          (map (fn [v]
                                 (let [tf (as-vector (get v :transfer_fn))
                                       type (get v :field_type)
                                       ;   _ (println "--type" type)
                                       field_type (if (and (= (get v :field_name) key-field)
                                                           (= 1 (count type))
                                                           )
                                                    (conj type "key")
                                                    type

                                                    )
                                       ;_ (println "--" field_type)
                                       ;type-reverse (reverse type)
                                       schema (loop [[ftype & type-coll] (reverse field_type)
                                                     out {}]
                                                (if (nil? ftype)
                                                  out
                                                  (let [
                                                        ;_ (println "--" ftype "-" (keys schema-coll-m ))
                                                        schema (if-let [w (get schema-coll-m ftype)]
                                                                 (do

                                                                   (select-keys w [:fields :type])
                                                                   )
                                                                 {:type ftype :member_schema nil :fields nil}
                                                                 )
                                                        out (if (empty? out)
                                                              schema
                                                              (assoc out :member_schema schema))]
                                                    (recur type-coll out))))]
                                   ;  (println "--type " schema)
                                   {:name        (get v :field_name)
                                    :source-type (get v :source-type)
                                    :schema      schema  #_{:type type :memberSchema nil}
                                    :transfer_fn tf})))
                          ) mapping)

        join (into [] (comp
                        (filter (fn [v]
                                  (and
                                    (nil? (:field_name v))
                                    (contains? #{"join" "left_join" "outer_join"} (first (get v :transfer_fn [""]))))))
                        (map :transfer_fn)
                        ) mapping)

        schema-m (if (empty? join)
                   schema-m
                   (assoc schema-m :join join))

        ;_ (println mapping)
        where (into [] (comp
                         (filter (fn [v]
                                   (and
                                     (nil? (:field_name v))
                                     (contains? #{"where"} (clojure.string/lower-case
                                                             (or (first (get v :transfer_fn [""])) "")
                                                             )))))
                         (map :transfer_fn)
                         ) mapping)

        where (cond
                (= 1 (count where))
                (first where)
                (< 1 (count where))
                ["where" (into ["and"] (mapv second where))]
                :else [])

        schema-m (if (empty? where)
                   schema-m
                   (assoc schema-m :where where))

        dq_check (into [] (comp
                            (filter (fn [v]
                                      (and
                                        (nil? (:field_name v))
                                        (contains? #{"dq_check"} (clojure.string/lower-case
                                                                   (or (first (get v :transfer_fn [""])) "")
                                                                   )))))
                            (map :transfer_fn)
                            ) mapping)

        dq_check (cond
                   (= 1 (count dq_check))
                   (first dq_check)
                   (< 1 (count dq_check))
                   ["dq_check" (into ["and"] dq_check #_(mapv second))]
                   :else [])


        schema-m (if (empty? dq_check)
                   schema-m
                   (assoc schema-m :dq_check dq_check))



        ;  _ (p/log-v "-----------------------------" schema-m)
        group-by2 (into [] (comp
                             (filter (fn [v]
                                       (and
                                         (nil? (:field_name v))
                                         (contains? #{"group_by"} (first (get v :transfer_fn [""]))))))
                             (map :transfer_fn)
                             (map rest #_(juxt first rest))
                             cat
                             ) mapping)
        ; _ (println "----" group-by2)
        schema-m (if (empty? group-by2)
                   schema-m
                   (assoc schema-m :group_by group-by2))

        ;_ (p/log-v mapping)
        other-m (->> mapping
                     (filter (fn [v] (nil? (:field_name v))))
                     (remove (fn [v]
                               (contains? #{"join" "left_join" "outer_join" "where" "group_by" "dq_check"} (clojure.string/lower-case (first (get v :transfer_fn [""]))))))
                     (mapv :transfer_fn)
                     (group-by first)
                     ;(-> (dissoc "join" "left_join" "outer_join" "where" ))
                     (mapv (fn [[k v]] {(keyword k) (first v)}))
                     (into {})
                     )



        schema-m (merge schema-m other-m)
        ;_ (println "--" schema-m)

        schema-keys (apply disj (into #{} (keys schema-m)) [:fields :sink-name :source-name :type :where :join :group_by :window])
        schema-m (reduce (fn [acc k]
                           (update acc k (fnil second [k nil]))
                           ) schema-m schema-keys)
        ]


    (-> schema-m
        (assoc :fields fields #_(into [] xf fields))
        (merge main-m)
        ;(assoc :key k )
        (update :type (fn [v]
                        (or (second v) stream-type "stream")

                        ) #_(fnil second "stream" #_["type"]))
        )
    ))

(comment

  (->> [[:group_by :person/id :person/name]]
       (into {} (map (juxt first rest)))
       )
  )

