(ns ksql.gen.emitter.ksql
  (:require [ksql.gen.emitter.ksql.core :as kc]
            [clojure.tools.logging :as log]
            [ksql.gen.protocol :as p]))




#_(defn emit-ksql [context schema-coll]
  (binding [kc/current-context context]
    (->> (into [] (comp (map p/gen-ksql) cat) schema-coll)
         (sort-by (fn [m]
                    (if (clojure.string/starts-with? m "CREATE")
                      0 1)))
         (distinct)
         (into [])
         #_(make-order))))



(defn gen-drop-stream [quiries-id stream-m]
  (let [out (into [] (map (fn [v]
                            (str "TERMINATE " v "; ")
                            )) quiries-id)
        out (into out (map (fn [v]
                             (str "DROP TABLE IF EXISTS " v "  ; ")
                             )) (get stream-m "table"))
        out (into out (map (fn [v]
                             (str "DROP STREAM IF EXISTS " v "  ; ")
                             )) (get stream-m "stream"))

        ]
    out
    )

  )


(defn gen-drop-stream-with-topic [quiries-id stream-m]
  (let [out (into [] (map (fn [v]
                            (str "TERMINATE " v "; ")
                            )) quiries-id)
        out (into out (map (fn [v]
                             (str "DROP TABLE IF EXISTS " v "  ; ")
                             )) (get stream-m "table"))
        out (into out (map (fn [v]
                             (str "DROP STREAM IF EXISTS " v " DELETE TOPIC  ; ")
                             )) (get stream-m "stream"))

        ]
    out
    )

  )
