(ns ksql.gen.reader.csv-data-reader
  (:require [ksql.gen.file-util :as u]
            [ksql.gen.xmltojson :as xmltojson]
            [clojure.xml :as xml]
            [clojure.java.io :as io]
            [clojure.walk :as w :refer [postwalk]]
            [cheshire.core :as json]
            [ksql.gen.protocol :as p]))


(defn load-template [template-path]
  (-> template-path
      (slurp)
      (json/parse-string true)))

(defn get-separator [file-name]
  (with-open [rdr (clojure.java.io/reader file-name)]
    (let [w (first (line-seq rdr))]
      (if (< (count (clojure.string/split w #"\;"))
             (count (clojure.string/split w #"\,")))
        \, \;))))


(comment


  (with-open [rdr (clojure.java.io/reader "app/azben/data/source/bnl_claim.csv")]
    (let [w (first (line-seq rdr))

          comma (if (< (count (clojure.string/split w #"\;"))
                       (count (clojure.string/split w #"\,")))
                  "," ";"
                  )

          ]
      (println "--" (count (clojure.string/split w #"\;")))
      (println "--" (count (clojure.string/split w #"\,")))
      comma

      )
    )


  ;(first (map #(clojure.string/split-lines ) (slurp "app/azben/data/source/bnl_claim.csv")) )

  )


(defn get-all-files [csv-folder-name t]
  (let [grammar-matcher (.getPathMatcher
                          (java.nio.file.FileSystems/getDefault)
                          t)]
    (->> csv-folder-name
         clojure.java.io/file
         file-seq
         (filter #(.isFile %))
         (filter #(.matches grammar-matcher (.getFileName (.toPath %)))))))


(defn get-all-file-name [folder-name type]
  (let [csv-file-list (get-all-files folder-name type)
        csv-file-path (into []
                            (comp
                              (remove (fn [v]
                                        (-> (.getAbsolutePath v)
                                            (clojure.string/includes?  "/.") )))
                              (map (fn [v]
                                     (let [file-path (.getAbsolutePath v)
                                           file-name (-> v
                                                         (.getName)
                                                         (clojure.string/split #"\.")
                                                         first)]
                                       [file-name file-path]))))
                            csv-file-list )
        w (into (sorted-set-by #(compare (first %1) (first %2))) csv-file-path)
        w (vec w)
        ]
    ;csv-file-path
    w
    ))




(defn read-csv-header
  ([csv-file-path] (read-csv-header csv-file-path (get-separator csv-file-path)))
  ([csv-file-path separator]
   (let [
         ;csv-file-path (str data-dir "/" entity-name ".csv")
         ; separator (get-in config [:config :csv.separator.char])
         ;separator (or separator \;) #_(if (= separator 59) \; \,)
         ]
     (->> csv-file-path
          (u/get-csv-header separator)
          (into [])))))

(defn format-csv-header [header]
  (mapv (fn [v]
          (-> v
              (clojure.string/trim)
              (.replaceAll " " "_")
              (.toLowerCase)
              (clojure.string/replace-first #"\"" "")
              (.replaceFirst (str "(?s)(.*)" "\"") (str "$1" "")))
          ) header)

  )


(defn read-header [config csv-file-path]
  (let [
        ;csv-file-path (str data-dir "/" entity-name ".csv")
        separator (get-in config [:config :csv.separator.char])
        separator (if (= separator 59) \; \,)]
    (->> csv-file-path
         (u/get-csv-header separator)
         (into #{}))))

(defn get-file-name [file-name]
  (-> (clojure.java.io/as-file file-name)
      (.getName)
      (clojure.string/split #"\.")
      (first)))


(defn gen-schema-from-entity-one [e]
  ; (  e)
  (let [template-path (get e :ds_file)
        file-path (get e :data_file)
        pk-name (get e :key)
        e-name (get e :entity_name)
        e-name (if (clojure.string/blank? e-name)
                 nil
                 e-name
                 )
        tn (get-file-name template-path)
        t (load-template template-path)
        connector_ref_name (get-file-name file-path) #_(or e-name)
        fields (->> (read-header t file-path)
                    (mapv (fn [v]
                            {:name v, :schema {:type "string"}})))]
    {:name               (or e-name connector_ref_name)
     :key                pk-name
     :fields             fields
     :connector_ref_name connector_ref_name
     :connector_source   tn
     :connector          t}))

#_(defn gen-schema-from-entity [entity-list]
    (let [xf (comp (map gen-schema-from-entity-one))]
      (into [] xf entity-list)))


(defn unlazy
  [coll]
  (let [unlazy-item (fn [item]
                      (cond
                        (sequential? item) (vec item)
                        (map? item) (into {} item)
                        :else item))
        result    (postwalk unlazy-item coll) ]
    result ))

(defn lowercase-keys
  "Recursively transforms all map keys from keywords to strings."
  {:added "1.1"}
  [m]
  (let [f (fn [[k v]] (if (keyword? k) [ (keyword (clojure.string/lower-case (name k)) )  v] [k v]))]
    ;; only apply to maps
    (postwalk (fn [x] (if (map? x) (into {} (map f x)) x)) m)))


;"ISO-8859-1"
(defn convert-xml-to-edn [xml-str]
  (-> xml-str
      (clojure.string/replace "'" "")
      (.getBytes )
      (java.io.ByteArrayInputStream.)
      xml/parse
      (xmltojson/parse)
      (lowercase-keys)
      (xmltojson/format-map)
     ; (clojure.walk/stringify-keys)
     ; (p/log-v)
      )

  )

(comment


  (w/keywordize-keys)

  (-> (slurp "test/example/azuk/reqah1.xml")
      (convert-xml-to-edn)
      )

  (-> (slurp "test/resources/data/books.xml")
      (convert-xml-to-edn)
      ;(lowercase-keys)
      ;(pr-str)
      ;(pr-str)
      ;(clojure.tools.reader.edn/read-string)
      )

  )

(defn convert-xml-file-to-edn [xml-file-path]
  ;(println "--xml file path " xml-file-path)

  (->> xml-file-path
       ;io/resource
       io/file
       xml/parse

       (xmltojson/parse)
       (xmltojson/format-map)
       #_(json/generate-string))

  #_(with-open [rdr  (-> xml-file-path  io/reader) #_(clojure.java.io/reader (clojure.java.io/as-file xml-file-path))]
    (let [w (-> rdr
                xml/parse

                ;(xmltojson/parse)
                ;(doall)
                #_(json/generate-string))
          ;w1 (json/generate-string w)
          ]
       (clojure.pprint/pprint w)
      w
      ; (clojure.pprint/pprint w)
      #_(async/>!! input-chan {:value w1})
      ;(swap! total inc)
      )
    #_(async/>!! input-chan "done!"))
  )


(defn get-file-name [file-path]
  ;(println "---file path " file-path)
  (-> file-path
      (clojure.string/split #"/")
      (last)
      (clojure.string/split #"\.")
      (first))
  )


(comment


  (convert-xml-file-to-edn "/home/mamun/development/workspace/clj/ksql-gen/test/resources/data/books.xml")

  (clojure.string/split "")

  (->> [["app/allianz_life/config/csv_source.json" "app/allianz_life/data/Product.csv" "product_code" "product"]]
       (gen-schema-from-entity)
       )



  #_(gen-schema-from-entity "app/allianz_life/config/csv_source.json"
                            [["product" "product_code" "Product"]]
                            "app/allianz_life/data")



  ;"app/allianz_life/config/csv_source.json"

  )