(ns ksql.gen.protocol
  (:require [clojure.pprint]))



(defn new-step
  ([subject ref]
   (new-step subject "" ref))
  ([subject property ref]
   [subject property ref]))


(defn add-step [acc new-step-v]
  (conj acc new-step-v)
  )



(defprotocol MappingStore
  (-get-all-mapping [this] "return all mapping")
  (-push-mapping [this mapping-coll] "push new mapping ")
  (-peek-mapping [this] "peek mapping")
  (-pull-mapping [this] "pull mapping"))



(defrecord MappingStoreInMemory [x-atom]
  MappingStore
  (-get-all-mapping [this]
    (into [] cat @x-atom))

  (-push-mapping [this new-schema-m-coll]
    (swap! x-atom conj new-schema-m-coll))

  (-peek-mapping [this]
    (let [mapping-schema-coll (last @x-atom)]
      ;(swap! x-atom (fn [v] (into [] (butlast v))))
      mapping-schema-coll))

  (-pull-mapping [this]
    (let [mapping-schema-coll (last @x-atom)]
      (swap! x-atom (fn [v] (into [] (butlast v))))
      mapping-schema-coll)))


(defn new-memory-store []
  (->MappingStoreInMemory (atom [])))


(defn peek-mapping [store]
  (-peek-mapping store)
  )


(defn pull-mapping [store]
  (-pull-mapping store)
  )

(defn push-mapping [store v]
  (-push-mapping store v)
  )

(defn get-all-mapping [store]
  (-get-all-mapping store)
  )




(def arvo-p-type #{"string" "bytes" "double" "float" "long" "int" "boolean" "null"})


(defmulti read-req (fn [t v] t))

(defmulti gen-ksql :ksql-gen-type)

(def gen-ksql-rekey-stream-from-mapping "rekey")
(def gen-ksql-stream-insert-from-mapping "insert-into")
(def gen-ksql-stream-from-mapping "stream-to-stream")
(def gen-ksql-create-stream "create-stream")
(def gen-ksql-table-from-stream-after-rekey "table-from-stream-after-rekey")
(def gen-ksql-create-table-as "create-table-as")
(def gen-ksql-create-table "create-table")

(defmulti invoke-dataflow (fn [op-name context request] op-name))

(defmulti expand-step (fn [_ _ mapping-fields]
                        ;(println "--" mapping-fields)
                        (get-in mapping-fields [2 0] #_(get mapping-fields :transfer_fn))))

(defmethod expand-step :default
  [_ _ w]
  ;(vector m)
  [w]
  )


(defrecord ExpandTerminate [v])

(defn new-expand-terminate [v]
  (ExpandTerminate. v))

(defn get-expand-terminate-value [t]
  (get t :v))

(defn is-terminate-step [v]
  (instance? ExpandTerminate v)
  )


(comment

  (-> (new-expand-terminate "hello")
      (get-expand-terminate-value)
      )


  (-> {}                                                    ;(new-expand-terminate "hello")
      (is-terminate-step)
      ;      (get-expand-terminate-value)
      )

  )

(defmulti expand-flow (fn [_ mapping-fields] (first (get (first mapping-fields) :transfer_fn))))



(defmethod expand-flow :default
  [_ mapping]
  ;(println "--" (count mapping) "--" mapping)
  [(new-expand-terminate mapping)]
  ;(new-expand-terminate [mapping] )
  )



(defmulti transfer-fn (fn [f]
                        (-> (first f)
                            (clojure.string/trim)
                            (clojure.string/lower-case))))


(defmulti gen-connector (fn [m]
                          ;(get m t)
                          (get-in m [:template :config :connector.class])

                          ))

(defmethod gen-connector
  :default
  [connector-schema]
  ; (  connector-schema)
  (get connector-schema :template))



(defn log-v
  ([v] (log-v "" v))
  ([msg v]
   (println "--start--" msg)
   (clojure.pprint/pprint v)
   (println "--end--")
   v)

  )


(defprotocol GetValue
  (-getValue [_]))

(defrecord ConstantValue [v]
  GetValue
  (-getValue [_] v))


(defn new-constant [v]
  (->ConstantValue v))


(defn constant-string? [v]
  (instance? ConstantValue v))


(defrecord RefValue [v]
  GetValue
  (-getValue [_] v))


(defrecord QuoteStringValue [v]
  GetValue
  (-getValue [_] v))

(defn new-quote-string [v]
  (->QuoteStringValue v))


(defn quote-string? [v]
  (instance? QuoteStringValue v))

(defn get-quote-value [v]
  (get v :v)
  )




(defn as-referance [v]
  (->RefValue v))



(defn get-value [v-type]
  (-getValue v-type))


(comment

  ;(get-value (as-constant 23))

  )


(def msg {:100 "Could not find this reference on current context "
          :500 "Key is missing in mapping or source stream/table "

          })


(defn get-source-schema [ksqldb-schema-m-coll source-name]
  (reduce (fn [acc schema]
            (if (= (get schema :sink-name) source-name)
              (reduced schema)
              acc
              )
            ) nil ksqldb-schema-m-coll))


(defn get-all-subject-names [schema-coll]
  (into [] (map :sink-name) schema-coll))


(defn get-object-value [mapping]
  (into [] (rest (get (first mapping) :transfer_fn [[]] ))))


(defn get-property-names [ksqldb-schema-m-coll source-name]
  (if-let [w (get-source-schema ksqldb-schema-m-coll source-name)]
    (into [] (map :name ) (get w :fields))
    []))
