(ns ksql.gen.macro.expand-flow-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.util :as u])
  )



(defmulti expand-flow-internal (fn [_ mapping-fields] (first (get (first mapping-fields) :transfer_fn))))


(defmethod expand-flow-internal :default
  [_ mapping]
  ;(println "--" mapping)
  [mapping]
  )




;csv-file-list (get-all-files csv-folder-name "glob:*.{csv}")


(defmethod expand-flow-internal "map_before"
  [schema-coll mapping]
  ;(  mapping)
  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (p/get-source-schema schema-coll source-name)
        fields (get schema :fields)
        stage-name (str source-name "_stage")
        stage-name-tab (str stage-name "_tab")
        ;statge-enrich (str source-name "_stage")

        stage-mapping-fields (into [] (map (fn [field]
                                             (-> field
                                                 (assoc :name stage-name)
                                                 (assoc :field_name (get field :name))
                                                 (dissoc :schema)
                                                 (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                                 )
                                             )) fields)

        stage-mapping-fields (conj stage-mapping-fields {:name        stage-name
                                                         :transfer_fn ["key" key-name]})

        cust_stage_tab-fields (into [] (map (fn [field]
                                              (-> field
                                                  (assoc :name stage-name-tab)
                                                  (assoc :field_name (get field :name))
                                                  (dissoc :schema)
                                                  (assoc :transfer_fn ["as" (str stage-name "/" (get field :name))])
                                                  )
                                              )) fields)

        cust_stage_tab-fields (into cust_stage_tab-fields [{:name        stage-name-tab
                                                            :transfer_fn ["key" key-name]}
                                                           {:name        stage-name-tab
                                                            :transfer_fn ["type" "table"]}])
        enrich-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name n)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                          )
                                      )) fields)


        enrich-fields_full (into enrich-fields (map (fn [field]
                                                      (-> field
                                                          (assoc :name n)
                                                          (assoc :field_name (str (get field :name) "_before"))
                                                          (dissoc :schema)
                                                          (assoc :transfer_fn ["as" (str stage-name-tab "/" (get field :name))])
                                                          )
                                                      )) fields)

        enrich-fields_full (into enrich-fields_full [{:name        n
                                                      :transfer_fn ["left_join"
                                                                    (str source-name "/" key-name)
                                                                    (str stage-name-tab "/" key-name)
                                                                    ]}
                                                     ])
        insert-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name stage-name)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str n "/" (get field :name))])
                                          )
                                      )) fields)]
    [stage-mapping-fields
     cust_stage_tab-fields
     enrich-fields_full
     insert-fields]))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn flatten-mapping-impl [schema-coll mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)
        fields (into [] (comp (filter (fn [m]
                                        (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                              (remove (fn [m]
                                        (and
                                          (contains? #{"array"} (get-in m [:schema :type]))
                                          (not= "struct" (get-in m [:schema :member_schema :type]))))))
                     fields)
        {:keys [array-list struct-list]} (group-by (fn [m]
                                                     (if (= "array" (get-in m [:schema :type]))
                                                       :array-list
                                                       :struct-list)
                                                     ) fields)
        struct-m (for [w struct-list
                       f (get-in w [:schema :fields])]
                   (let [t (if (= "struct" (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                             (get-in f [:schema :type])
                             )]
                     ;    (println "--" t)
                     [(str source-name "_" (get w :name))
                      (str (get f :name) " " t)
                      (str source-name "/" (get w :name) "->" (get f :name))]
                     )
                   )
        out-mapping (into [] struct-m)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w array-list]
            [(str source-name "_" (get w :name) coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        array-list (for [w array-list
                         f (get-in w [:schema :member_schema :fields])]
                     [
                      ;(get w :name)
                      (str source-name "_" (get w :name))
                      (str (get f :name) " " (get-in f [:schema :type]))
                      (str source-name "_" (get w :name) coll_postfix "/" (get w :name) "->" (get f :name))])
        ;_ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping array-list)]

    ;    (clojure.pprint/pprint out-mapping)
    out-mapping))



(defmethod p/expand-flow "flatten"
  [schema-coll mapping]
  (let [out-mapping (flatten-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))



(defn get-mapping-impl [schema-coll mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name source-ref-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)
        sink-name (get mapping :name)
        ;  _ (println "--" sink-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)
        ;   _ (clojure.pprint/pprint fields)
        fields (into [] (comp
                          (filter (fn [m] (= (clojure.string/lower-case source-ref-name)
                                             (clojure.string/lower-case (get m :name)))))
                          (filter (fn [m]
                                    (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                          (remove (fn [m]
                                    (and
                                      (contains? #{"array"} (get-in m [:schema :type]))
                                      (not= "struct" (get-in m [:schema :member_schema :type]))))))
                     fields)
        ;  _ (clojure.pprint/pprint fields)
        {:keys [array-list struct-list]} (group-by (fn [m]
                                                     (if (= "array" (get-in m [:schema :type]))
                                                       :array-list
                                                       :struct-list)
                                                     ) fields)
        struct-m (for [w struct-list
                       f (get-in w [:schema :fields])]
                   (let [t (if (= "struct" (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                             (get-in f [:schema :type])
                             )]
                     ;    (println "--" t)
                     [(str source-name "_" (get w :name))
                      (str (get f :name) " " t)
                      (str source-name "/" (get w :name) "->" (get f :name))]
                     )
                   )
        out-mapping (into [] struct-m)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w array-list]
            [(str sink-name coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        array-list (for [w array-list
                         f (get-in w [:schema :member_schema :fields])]
                     (let [f-type (if (= "array"
                                         (get-in f [:schema :type]))

                                    (if (get-in f [:schema :member_schema :fields])
                                      (str source-name "_" (get w :name) "_" (get f :name) "_struct" " " (get-in f [:schema :type]))
                                      (str (get-in f [:schema :member_schema :type]) " " (get-in f [:schema :type])))
                                    (get-in f [:schema :type]))]
                       [sink-name
                        (str (get f :name) " " f-type)
                        (str sink-name coll_postfix "/" (get w :name) "->" (get f :name))]
                       )
                     )

        ;    _ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping array-list)]

    ; (clojure.pprint/pprint out-mapping)
    out-mapping))


(defmethod p/expand-flow "get"
  [schema-coll mapping]
  (let [out-mapping (get-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))


(defmethod p/expand-flow "distinct_old"
  [schema-coll mapping]
  (let [
        mapping (first mapping)
        [_ source-name groupy-by-key window-str] (get mapping :transfer_fn)
        ;_ (println "---" mapping)
        sink-name (get mapping :name)
        ;  _ (println "--" sink-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)

        ;    "clicks_detected table" "key1" "clicks/ip_address"
        key-fields (map (fn [f i]
                          (if (= i 0)
                            [(str source-name "_detected table")
                             (str "key" i  #_(get f :name) " " (get-in f [:schema :type]))
                             (str source-name "/" (get f :name))
                             ]
                            [(str source-name "_detected ")
                             (str "key" i  #_(get f :name) " " (get-in f [:schema :type]))
                             (str source-name "/" (get f :name))
                             ]
                            )

                          ) fields (range))

        mapping-fields (map (fn [f]
                              [(str source-name "_detected")
                               (str (get f :name) " " (get-in f [:schema :type]))
                               (str "( as_value " source-name "/" (get f :name) " )")
                               ]

                              ) fields)

        ffields (into [] cat (into (into [] key-fields) mapping-fields))

        windows [(str source-name "_detected ") "" (str "(window " window-str ") ")]
        ffields (into ffields windows)

        group-by-str (->> (map (fn [f]
                                 (str source-name "/" (get f :name))
                                 ) fields)
                          (clojure.string/join ", ")

                          )
        group-by-str [(str source-name "_detected ") "" (str "(group_by " group-by-str ")")]
        ffields (into ffields group-by-str)
        having-vec [(str source-name "_detected") "" (str "(having (= (count " source-name "/" groupy-by-key " ) 1 ))")]
        ffields (into ffields having-vec)

        raw-detect-fields (map (fn [f i]
                                 (if (= i 0)
                                   [(str source-name "_raw_detected stream " source-name "_detected ")
                                    (str (get f :name) " " (get-in f [:schema :type]))
                                    ""
                                    ]
                                   [(str source-name "_raw_detected  ")
                                    (str (get f :name) " " (get-in f [:schema :type]))
                                    ""

                                    ]
                                   )

                                 ) fields (range))
        ffields (into ffields cat raw-detect-fields)

        distinct-fields (map (fn [f]
                               [sink-name
                                (if (= (clojure.string/lower-case groupy-by-key)
                                       (clojure.string/lower-case (get f :name))
                                       )
                                  (str (get f :name) " " (get-in f [:schema :type]) " key")
                                  (str (get f :name) " " (get-in f [:schema :type]))
                                  )

                                (str source-name "_raw_detected/" (get f :name))

                                ]

                               ) fields)
        distinct-fields-where [sink-name "" (str "(where (!=null " source-name "_raw_detected/" groupy-by-key "))")]
        distinct-fields (into [] cat (conj (into [] distinct-fields) distinct-fields-where))
        ffields (into ffields distinct-fields)
        ]
    ;(clojure.pprint/pprint ffields)

    [ffields]))



(defmethod p/expand-flow "distinct"
  [schema-coll mapping]
  (let [
        mapping (first mapping)
        [_ source-name window-str & group-by-key-list ] (get mapping :transfer_fn)
        ;_ (println "---" mapping)
        sink-name (get mapping :name)
        ;  _ (println "--" sink-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)

        group-by-key-list (if (or
                                (nil? group-by-key-list)
                                (empty? group-by-key-list))
                            (mapv :name fields)
                            group-by-key-list)
        ;  _ (println "---" group-by-key-list)


        group-by-key-set (into #{} group-by-key-list)

        k-ffield-list (into [] (filter (fn [f]
                                         (contains? group-by-key-set (get f :name) )
                                         )) fields )
        ;_ (clojure.pprint/pprint k-ffield-list)
        ;    "clicks_detected table" "key1" "clicks/ip_address"
        key-fields (map (fn [f i]
                          (if (= i 0)
                            [(str source-name "_detected table")
                             (str "key" i  " " (get-in f [:schema :type]))
                             (str source-name "/" (get f :name))
                             ]
                            [(str source-name "_detected ")
                             (str "key" i  " " (get-in f [:schema :type]))
                             (str source-name "/" (get f :name))
                             ])
                          ) k-ffield-list (range))

        mapping-fields  (into [] (map (fn [f]
                                        [(str source-name "_detected")
                                         (str (get f :name) " " (get-in f [:schema :type]))
                                         (str "( as_value " source-name "/" (get f :name) " )")]))
                              k-ffield-list)

        mapping-fields  (into mapping-fields
                              (comp
                                (remove (fn [f]
                                          (contains? group-by-key-set (get f :name) )
                                          ) )
                                (map (fn [f]
                                       [(str source-name "_detected")
                                        (str (get f :name) " " (get-in f [:schema :type]))
                                        (str "( latest_by_offset " source-name "/" (get f :name) " )")]))
                                )
                              fields
                              ;k-ffield-list

                              )


        ffields (->> (into (into [] key-fields) mapping-fields)
                     (into [] cat ))

        windows [(str source-name "_detected ") "" (str "(window " window-str ") ")]
        ffields (into ffields windows)

        group-by-str (->> (map (fn [f]
                                 (str source-name "/" (get f :name))
                                 ) k-ffield-list)
                          (clojure.string/join ", ")

                          )
        group-by-str [(str source-name "_detected ") "" (str "(group_by " group-by-str ")")]
        ffields (into ffields group-by-str)

        having-key (first group-by-key-list)
        having-vec [(str source-name "_detected") "" (str "(having (= (count " source-name "/" having-key " ) 1 ))")]
        all-fields (into ffields having-vec)

        raw-detect-fields (map (fn [f i]
                                 (if (= i 0)
                                   [(str source-name "_raw_detected stream " source-name "_detected ")
                                    (str (get f :name) " " (get-in f [:schema :type]))
                                    ""
                                    ]
                                   [(str source-name "_raw_detected  ")
                                    (str (get f :name) " " (get-in f [:schema :type]))
                                    ""

                                    ]
                                   )

                                 ) fields (range))
        all-fields (into all-fields cat raw-detect-fields)

        distinct-fields (map (fn [f]
                               [sink-name
                                (if (= (clojure.string/lower-case having-key)
                                       (clojure.string/lower-case (get f :name))
                                       )
                                  ;" key"
                                  (str (get f :name) " " (get-in f [:schema :type]) )
                                  (str (get f :name) " " (get-in f [:schema :type]))
                                  )

                                (str source-name "_raw_detected/" (get f :name))

                                ]

                               ) fields)
        distinct-fields-where [sink-name "" (str "(where (!=null " source-name "_raw_detected/" having-key "))")]
        distinct-fields (into [] cat (conj (into [] distinct-fields) distinct-fields-where))
        all-fields (into all-fields distinct-fields)
        ]
    ;  (clojure.pprint/pprint all-fields #_(partition 3 all-fields) )

    [all-fields]))



(defmethod p/expand-flow "map_data_vault"
  [schema-coll mapping]

  (let [[s-name] (p/get-object-value mapping)
        link-key-name "lhk"
        bk-postfix "_bk"
        ;  hk-prefix "hk_"
        tech-prefix "gdp_"
        ;   gdp-link "skip_hub"

        sat-key-field "gdp_hashdiff"
        link-key-field "lhk"
        hub-key-field "hk"

        process-fn (fn [refined-entity-name]
                     (let [entity-name (clojure.string/replace refined-entity-name s-name "")

                           sat-entity-name (str entity-name "_sat")
                           hub-entity-name (str entity-name "_hub")
                           link-entity-name (str entity-name "_link")

                           ;  rename-key-m {(str hk-prefix entity-name) "hk"}


                           refined-field-list (p/get-property-names schema-coll refined-entity-name)
                           tech-field-list (into [] (filter (fn [v] (clojure.string/starts-with? v tech-prefix))) refined-field-list)

                           ;sat-field-set

                           sat-field-map (into [] (comp
                                                    (remove (fn [f] (contains? #{link-key-name} f)))
                                                    (map (fn [f]
                                                           (let [;target-field (get rename-key-m f f)
                                                                 ;target-field (clojure.string/replace target-field bk-postfix "")
                                                                 target-field (clojure.string/replace f bk-postfix "")
                                                                 target-field (if (or (= target-field sat-key-field)
                                                                                      (= target-field link-key-name)
                                                                                      #_(and (contains? (into #{} refined-field-list) link-key-name)
                                                                                             (= f link-key-name))
                                                                                      )
                                                                                (str target-field " string key ")
                                                                                target-field
                                                                                )]
                                                             [sat-entity-name
                                                              target-field
                                                              (str refined-entity-name "/" f)])))
                                                    cat
                                                    ) refined-field-list)

                           hub-field-list (if (contains? (into #{} refined-field-list) link-key-name)
                                            []
                                            (-> (into []
                                                      (comp
                                                        (filter (fn [v]
                                                                  (or
                                                                    (= v hub-key-field)
                                                                    (clojure.string/ends-with? v bk-postfix))
                                                                  )))
                                                      refined-field-list)
                                                (into tech-field-list)))

                           hub-field-map (into [] (comp
                                                    (remove (fn [f] (contains? #{link-key-name sat-key-field} f)))
                                                    (map (fn [f]
                                                           (let [target-field (clojure.string/replace f bk-postfix "")
                                                                 target-field (if (= target-field hub-key-field)
                                                                                (str target-field " string key ")
                                                                                target-field)]
                                                             [hub-entity-name
                                                              target-field
                                                              (str refined-entity-name "/" f)])))
                                                    cat
                                                    ) hub-field-list)

                           link-field-list (if (contains? (into #{} refined-field-list) link-key-name)
                                             (-> (into [] (filter (fn [v]
                                                                    (or
                                                                      (= v link-key-field)
                                                                      ; (clojure.string/starts-with? v "lhk")
                                                                      (clojure.string/starts-with? v hub-key-field))
                                                                    )) refined-field-list)
                                                 (into tech-field-list))
                                             [])

                           link-field-map (into []
                                                (comp
                                                  (remove (fn [f] (contains? #{sat-key-field} f)))
                                                  (map
                                                    (fn [f]
                                                      (let [
                                                            target-field (if (= f link-key-field)
                                                                           (str f " string key ")
                                                                           f)]
                                                        [link-entity-name target-field (str refined-entity-name "/" f)])))
                                                  cat
                                                  ) link-field-list)]
                       [hub-field-map
                        sat-field-map
                        link-field-map]))]

    (->> (p/get-all-subject-names schema-coll)
         (into [] (comp (filter (fn [v] (clojure.string/ends-with? v s-name)))
                        (map process-fn)
                        cat)))))
