(ns ksql.gen-api
  (:require [clojure.tools.reader.edn :as edn]
            [clojure.tools.logging :as log]
            [cheshire.core :as json]
            [ksql.core :as core]
            [ksql.gen :as gen]
            [ksql.gen.protocol :as p]
            [clojure.walk :as w]
            [ksql.gen :as gen]
            [ksql.gen-connector :as conn]
            [ksql.gen.reader.csv-data-reader :as r]
            [ksql.gen.reader.mapping-reader]                ;; reader plugin

            ))


(defn gen-napping [topic-name edn-data-coll]
  (let [first-event (first edn-data-coll)
        first-event (w/stringify-keys first-event)
        first-event-str (pr-str first-event)]
    [topic-name "_" (str "(from_edn_data " first-event-str "  )")
     topic-name "\"\"" "(value_format 'json')"]))



(defmulti gen-mapping-by-file (fn [_ file-path]
                              ; (println "--" file-path)
                               (let [w (last (clojure.string/split file-path #"\."))]
                                 (clojure.string/lower-case w)
                                 )

                               ))


(defmethod gen-mapping-by-file :default
  [topic-name file-path]
  (let [w (last (clojure.string/split file-path #"\."))]
    (throw (Exception. "now support only json, xml and csv file " {:provided w
                                                                   :expected #{"json" "xml" "csv"}
                                                                   }))
    )

  )


#_(defmulti gen-mapping-by-file (fn [_ file-path]
                                ;  (println "--" (last (clojure.string/split file-path #"\.")))
                                (let [w (last (clojure.string/split file-path #"\."))]
                                  (if (contains? #{"json" "xml" "csv"} w)
                                    w
                                    (throw (Exception. "now support only json, xml and csv file " {:provided w
                                                                                                   :expected #{"json" "xml" "csv"}
                                                                                                   }))))))


(defmethod gen-mapping-by-file "json"
  [topic-name json-file-path]
  (let []
    [topic-name "_" (str "(from_json_file \"" json-file-path "\" )")
     topic-name "_" "(value_format 'json' )" ";"]
    )
  )


(defmethod gen-mapping-by-file "csv"
  [topic-name csv-file-path]
  (let []
    [topic-name "_" (str "(from_csv_file \"" csv-file-path "\" )")
     topic-name "_" "(value_format 'json' )" ";"]
    )
  )


(defmethod gen-mapping-by-file "xml"
  [topic-name xml-file-path]
  (let []
    [topic-name "_" (str "(from_xml_file \"" xml-file-path "\" )")
     topic-name "_" "(value_format 'json' )" ";"]
    )
  )


(comment

  (gen-mapping-by-file "apl" "app/apl/apl_orginal_format.xml")

  )


(defn gen-ksql-by-mapping [mapping]
  (gen/gen-ksql-by-mapping (core/get-context) mapping))


(defn gen-schema-by-mapping [mapping]
  (gen/gen-schema (core/get-context) mapping))


(defn gen-ksql-by-file [topic-name file-path]
  (gen/gen-ksql-by-mapping (core/get-context) topic-name file-path))


(defn gen-ksql [type topic-name v]
  (let [v (condp = type
            "edn" (pr-str v)
            "json" (pr-str (json/parse-string v true))
            "xml" (pr-str (r/convert-xml-to-edn v))
            (throw (Exception. "type does not supported, only supprt file xml, edn, json ")))
        v (clojure.string/replace v "'" "")
        mapping [topic-name "_" (str "(from_edn_data  " (pr-str v) "  )")
                 topic-name "_" "(value_format 'json' )" ";"]]
    (gen-ksql-by-mapping mapping)))


(defn gen-schema [type topic-name v]
  (let [v (condp = type
            "edn" (pr-str v)
            "json" (pr-str (json/parse-string (clojure.string/replace v "'" "") true))
            "xml" (pr-str (r/convert-xml-to-edn v))
            (throw (Exception. "type does not supported, only supprt file xml, edn, json ")))
        mapping [topic-name "_" (str "(from_edn_data  " (pr-str v) "  )")
                 topic-name "_" "(value_format 'json' )" ";"]]
    (into [] (comp (filter (fn [v]
                             (contains? #{"stream" "table"} (get v :type))
                             ))) (gen-schema-by-mapping mapping))))


(defn gen-source-connector [mapping]
  (->> (conn/gen-source-connector-config (core/get-context) mapping)
       (mapv json/generate-string)))


(defn gen-sink-connector [mapping]
  (->> (conn/gen-sink-connector-config (core/get-context) mapping)
       (mapv json/generate-string)))
