(ns ksql.gen.expand-join-impl
  (:require [clojure.tools.reader.edn :as edn]
            [ksql.gen.protocol :as p]))


(def join-name-set #{"left_join" "join" "inner_join"})

(defn join-transoformation? [field]
  (if (contains? join-name-set (get-in field [:transfer_fn 0]))
    true false))

(defn get-entity-name-list [transformation-fn]
  (->> (pr-str transformation-fn)
       (re-seq #"(\w+)/(\w+)")
       (apply concat)
       (filter #(clojure.string/includes? % "/"))
       (map (fn [v]
              (first (clojure.string/split v #"/"))))
       (into [])
       ;(distinct)
       #_(first)))





(comment

  (get-entity-name-list ["join"
                         "id3_zvspolp_policy/fbfncu_policy_id"
                         "id3_poltblp_policy/b4docd_policy_number"])

  )

;;;;;;;;;;;;;;;;
(defn create-join-fields [fields]
  (let [f (last fields)
        join-f (get-in f [:transfer_fn 1])
        f-name (last (clojure.string/split join-f #"/"))]
    {:field_name  f-name
     :type        (get f :type)
     :transfer_fn ["as " join-f]}))


(defn map-join-fields [field-coll-coll]

  (loop [[field-coll & field-coll-coll] field-coll-coll
         out []]

    (if (nil? field-coll)
      out
      (let [w (mapv create-join-fields field-coll-coll)
            previous-fields (->> (or (last out) [])
                                 (remove (fn [m]
                                           (or
                                             (clojure.string/blank? (get m :field_name))
                                             (nil? (get m :name)))))
                                 (into []))
            fields (into previous-fields (butlast field-coll))
            fields-name-set (into #{} (map :field_name) fields)
            ;_ (println "--" fields-name-set "--" (get w :field_name))
            w (into [] (remove (fn [m]
                                 (contains? fields-name-set (get m :field_name))
                                 ) ) w )

            fields (into fields w)

            join-fields (last field-coll)
            fields (conj fields join-fields)]
        (recur field-coll-coll (conj out fields))))))


(defn partition-join [mapping]
  (->> mapping
       (partition-by join-transoformation? )
       (partition-all 2)
       (mapv (fn [w] (into [] (apply concat w))))
       (map-join-fields)))

(defn get-join-entity-name [n-mapping]
  (->> n-mapping
       (filter join-transoformation?)
       (map (fn [m]
              (first (clojure.string/split (get-in m [:transfer_fn 1]) #"/"))))
       (first)))

(def edn-readers {'ksql.gen.protocol.ConstantValue p/map->ConstantValue
                  'ksql.gen.protocol.QuoteStringValue p/map->QuoteStringValue})

(defn replace-name-space
  ([next-mapping previous-field-set f-step]
   (let [source-name (get-join-entity-name next-mapping)
         old-name (str source-name "/")
         f-step-str (str f-step "/")
         n-mapping (-> (pr-str next-mapping)
                       (clojure.string/replace (clojure.string/lower-case old-name)
                                               (clojure.string/lower-case f-step-str))
                       )
         n-mapping (edn/read-string {:readers edn-readers} n-mapping)
         n-mapping (into [] (comp (map (fn [m]
                                         (if (contains? previous-field-set (get m :field_name))
                                           (assoc m :transfer_fn ["as" (str f-step "/" (get m :field_name))])
                                           m)))
                                  (remove nil?)
                                  ) n-mapping)]
     n-mapping))
  ([current-mapping next-mapping previous-field-set f-step]
   (let [f-mapping (into [] (map (fn [m]
                                   (assoc m :name f-step)
                                   )) current-mapping)
         n-mapping (replace-name-space next-mapping previous-field-set f-step)]
     [f-mapping n-mapping])))


(defn create-intermediate-stream-names [mapping-coll]
  (let [mapping (first mapping-coll)
        source-name (get-join-entity-name mapping)
        sink-name (get-in mapping [0 :name])
        total-step (count mapping-coll)
        step-names (mapv (fn [step]
                           (str sink-name "_step" (+ step 1) "of" (- total-step 1) "_" source-name)
                           ) (range (- total-step 1)))]
    (loop [[current-mapping & r-mapping] mapping-coll
           [current-step-name & r-steps] step-names
           previous-step-name nil
           result []]
      (if (nil? current-step-name)
        (let [previous-field-set (into #{} (comp (map :field_name)
                                                 (remove (fn [v] (clojure.string/blank? v)))
                                                 ) (last result))
              f-mapping (replace-name-space current-mapping previous-field-set previous-step-name)]
          (conj result f-mapping))
        (let [next-mapping (first r-mapping)
              current-field-set (into #{} (comp (map :field_name)
                                                (remove (fn [v] (clojure.string/blank? v)))
                                                ) current-mapping)
              [current-mapping next-mapping] (replace-name-space current-mapping next-mapping current-field-set current-step-name)
              r-mapping (into [next-mapping] (rest r-mapping))]
          (recur r-mapping r-steps current-step-name (conj result current-mapping)))))))

#_(defn debug [m]

  (  m)
  m
  )

(defn join-expand [mapping]
  ;(clojure.pprint/pprint mapping)
  ;(  mapping)
  (let [join-fields (into [] (comp (filter join-transoformation?)
                                   (map :transfer_fn)
                                   (map get-entity-name-list)
                                   ) mapping)]
    ;(println "--" join-fields)
    (if (and join-fields
             (< 1 (count join-fields)))
      (let [k (into [] (comp (filter (fn [f]
                                       (contains? #{"key"} (-> f :transfer_fn first ))
                                       ) )) mapping )
            mapping (into [] (comp (remove (fn [f]
                                             (contains? #{"key"} (-> f :transfer_fn first ))
                                             ) )) mapping )
            ]
        ;(  k)
        (->> (partition-join mapping)
             ;(debug)
             (create-intermediate-stream-names)
             (into [] (map (fn [mapping]
                             (into mapping k)
                             ))  )
             )
        )

      [mapping])))




