(ns ksql.data-api
  (:require [clojure.tools.logging :as log]


            [ksql.core :as ksql]
            [ksqldb.client :as client]
            [ksqldb.client.broker-api :as bapi ]
            [ksqldb.client.broker-sedes-config :as bsc]
            [ksql.gen.protocol :as p]

            [ksql.ksqldb-api :as dapi]
            [ksql.gen-api :as gapi]
            ))



(defn push-data-batch
  [strem-name rows]
  (client/push-data-batch (ksql/get-context) strem-name rows))


(defn as-entity-name [f-name]
  (let [w (clojure.string/split f-name #"/")]
    (if-let [t (last w)]
      (first (clojure.string/split t #"\."))
      f-name)))


(defn as-topic-data [model-coll]
  (doall
    (for [w model-coll]
      (let [[ds_file data_file key entity_name] w
            data_file (as-entity-name data_file)

            v {:ds-name     (as-entity-name ds_file)
               :entity_name (or data_file entity_name)
               :key         key}
            k (or entity_name data_file)]
        {:key k :value v}))))


(defn push-edn-event+ [context topic-name edn-data-coll]
  (let [c (bsc/edn-topic-config context topic-name)]
    (doseq [{:keys [key value]} edn-data-coll #_(as-topic-data)]
      (bapi/publish context c key value))))


(defn push-stardog [context model-coll]
  (log/info "Push stardog kafka context " context)
  (let [w (mapv as-topic-data model-coll)]
    (push-edn-event+ context "_pipeline_metadata" w)
    ))




#_(defmulti push-file (fn [_ file-path]

                      (let [w (last (clojure.string/split file-path #"\."))]
                        (clojure.string/lower-case w)
                        )

                      ))


#_(defmethod push-file :default
  [topic-name file-path]
  (let [w (last (clojure.string/split file-path #"\."))]
    (throw (Exception. "now support only json, xml and csv file " {:provided w
                                                                   :expected #{"json" "xml" "csv"}
                                                                   }))
    )

  )

#_(defmethod push-file "json"
  [topic-name json-file-path]
  (log/info " ---------start push file---------- " json-file-path)
  (let [context (ksql/get-context)
        topic-config (bsc/json-topic-config context topic-name)
        input-chan (bapi/publish-async context topic-config)
        total (atom 0)
        mapping [topic-name "_" (str "(from_json_file \"" json-file-path "\" )")
                 topic-name "_" "(value_format 'json' )" ";"
                 ]
        ]
    (p/invoke-dataflow "create-dataflow" context mapping)
    (try
      (with-open [rdr (clojure.java.io/reader json-file-path)]
        (doseq [line (line-seq rdr)]
          (async/>!! input-chan {:value line})
          (swap! total inc))
        (async/>!! input-chan "done!"))
      (catch Exception e
        (do
          (async/>!! input-chan "done!")
          (ex-data e))))
    (log/info "--------- End push file to kafka with " {:file-path json-file-path :total @total})))



#_(defmethod push-file "csv"
  [topic-name csv-file-path]
  (log/info " ---------start push file---------- " csv-file-path)
  (let [context (ksql/get-context)
        topic-config (bsc/json-topic-config context topic-name)
        input-chan (bapi/publish-async context topic-config)
        total (atom 0)
        separator (r/get-separator csv-file-path)
        header (r/read-csv-header (clojure.string/replace csv-file-path "'" ""))
        header (r/format-csv-header header)
        mapping [topic-name "_" (str "(from_csv_file \"" csv-file-path "\" )")
                 topic-name "_" "(value_format 'json' )" ";"
                 ]

        ]
    (p/invoke-dataflow "create-dataflow" context mapping)
    (try
      (with-open [rdr (csv/read-csv (clojure.java.io/reader csv-file-path) :separator separator)  #_(clojure.java.io/reader csv-file-path)]
        (doseq [line (rest rdr)]
          (let [w (zipmap header line)
                w-json (json/generate-string w)]
            (async/>!! input-chan {:value w-json})
            (swap! total inc)))
        (async/>!! input-chan "done!"))
      (catch Exception e
        (do
          (async/>!! input-chan "done!")
          (ex-data e))))
    (log/info "--------- End push file to kafka with " {:file-path csv-file-path :total @total})))



#_(defmethod push-file
  "xml"
  [topic-name xml-file-path]
  (let [context (ksql/get-context)
        topic-config (bsc/json-topic-config context topic-name)
        input-chan (bapi/publish-async context topic-config)
        total (atom 0)
        mapping [topic-name "_" (str "(from_xml_file \"" xml-file-path "\" )" ";")]]
    (p/invoke-dataflow "create-dataflow" context mapping)
    (try
      (let [w (r/convert-xml-file-to-edn xml-file-path)  #_(-> rdr
                                                               xml/parse
                                                               (xmltojson/parse)
                                                               #_(json/generate-string))
            w1 (json/generate-string w)
            ]
        ; (clojure.pprint/pprint w)
        (async/>!! input-chan {:value w1})
        (swap! total inc)
        (async/>!! input-chan "done!")
        )
      #_(with-open [rdr (clojure.java.io/file xml-file-path)]

          (async/>!! input-chan "done!"))
      (catch Exception e
        (do
          (async/>!! input-chan "done!")
          (ex-data e))))
    (log/info "--------- End push file to kafka with " {:file-path xml-file-path :total @total})))






#_(defn undeploy-connector-batch [connector-list]
    (doseq [c connector-list]
      (invoke-kafka "delete-connector" c)))

(comment

  (def client-context {:kafka-rest-url "http://localhost:8082"
                       :schema-url     "http://localhost:8081"
                       :connector-url  "http://localhost:8083"
                       :ksql-url       "http://localhost:8088"
                       :kafka-broker   "localhost:29092"
                       :join-window    "WITHIN 6 MINUTES"
                       :replicas       1
                       :partitions     1
                       })




  (push-stardog
    client-context

    [["tnf_db" "ref_mapping" "global_value"]]

    )


  (ksql/invoke-kafka "show-schemas")

  (ksql/invoke-kafka "describe-schema" "ref_mapping-value")


  (client/consume client-context)


  (clojure.string/split "test.3.json" #"\.")

  )
