(ns ksql.gen.reader.mapping-reader
  (:require [ksql.gen.file-util :as u]
            [ksql.gen.util :as gu]
            [ksql.gen.protocol :as p]
            [clojure.tools.reader.edn :as edn]
            [clojure.tools.logging :as log]))



(defn read-csv-mapping-file [file-name]
  (->> (u/read-csv-file file-name)
       (partition-by (fn [v]
                       (clojure.string/blank? (:name v))))
       ;(remove (fn ) )
       (remove (fn [v]
                 (every? clojure.string/blank? (mapv :name v))
                 #_(= 1 (count v))))))


(comment


  (u/read-csv-file "app/azben/mapping/2test.csv")


  (read-csv-mapping-file "app/azben/mapping/2test.csv")




  (read-csv-mapping-file "app/azben/mapping/2test.csv")

  )



(defn format-transformation-fn [w]


  (if (nil? w)
    (list "null" "")
    (try
      (let [v (clojure.string/trim w)]
        (cond
          (clojure.string/blank? v)
          (list "null" v)

          (clojure.string/starts-with? v "(")
          (->> (edn/read-string v)
               (clojure.walk/postwalk (fn [v1]
                                        (cond (sequential? v1)
                                              (into [] v1)
                                              (gu/is-digit? v1) v1
                                              (string? v1) v1
                                              :else
                                              (str v1)
                                             ))))


          (not (clojure.string/includes? v "/"))
          (list "constant" v)
          :else
          (list "as" v))
        ;     (println "--344" w)
        )
      (catch Exception e
        (do
          (log/error e)
          (p/log-v w)
          ; (println "---" w)
          (throw (ex-info (str "Invalid mapping for " w " please check right ) ") {:mapping w}))
          )
        ))
    )
  )


(comment

  (edn/read-string  "(from_edn_data {:cata [{:book [{:id \"bk101\", :genre \"Computer\", :description \"An in-depth look at creating applications\\n            with XML.\", :title \"XML Developer\"'s Guide\", :author \"Gambardella, Matthew\", :publish_date \"t2000-10-01\", :price \"44.95\"} {:id \"bk102\", :genre \"Fantasy\", :description \"A former architect battles corporate zombies,\\n            an evil sorceress, and her own childhood to become queen\\n            of the world.\", :title \"Midnight Rain\", :author \"Ralls, Kim\", :publish_date \"2000-12-16\", :price \"5.95\"} {:id \"bk103\", :genre \"Fantasy\", :description \"After the collapse of a nanotechnology\\n            society in England, the young survivors lay the\\n            foundation for a new society.\", :title \"Maeve Ascendant\", :author \"Corets, Eva\", :publish_date \"2000-11-17\", :price \"5.95\"} {:id \"bk104\", :genre \"Fantasy\", :description \"In post-apocalypse England, the mysterious\\n            agent known only as Oberon helps to create a new life\\n            for the inhabitants of London. Sequel to Maeve\\n            Ascendant.\", :title \"Oberon'\"s Legacy\", :author \"Corets, Eva\", :publish_date \"2001-03-10\", :price \"5.95\"} {:id \"bk105\", :genre \"Fantasy\", :description \"The two daughters of Maeve, half-sisters,\\n            battle one another for control of England. Sequel to\\n            Oberon\"'s Legacy.\", :title \"The Sundered Grail\", :author \"Corets, Eva\", :publish_date \"2001-09-10\", :price \"5.95\"} {:id \"bk106\", :genre \"Romance\", :description \"When Carla meets Paul at an ornithology\\n            conference, tempers fly as feathers get ruffled.\", :title \"Lover Birds\", :author \"Randall, Cynthia\", :publish_date \"2000-09-02\", :price \"4.95\"} {:id \"bk107\", :genre \"Romance\", :description \"A deep sea diver finds true love twenty\\n            thousand leagues beneath the sea.\", :title \"Splish Splash\", :author \"Thurman, Paula\", :publish_date \"2000-11-02\", :price \"4.95\"} {:id \"bk108\", :genre \"Horror\", :description \"An anthology of horror stories about roaches,\\n            centipedes, scorpions  and other insects.\", :title \"Creepy Crawlies\", :author \"Knorr, Stefan\", :publish_date \"2000-12-06\", :price \"4.95\"} {:id \"bk109\", :genre \"Science Fiction\", :description \"After an inadvertant trip through a Heisenberg\\n            Uncertainty Device, James Salway discovers the problems\\n            of being quantum.\", :title \"Paradox Lost\", :author \"Kress, Peter\", :publish_date \"2000-11-02\", :price \"6.95\"} {:id \"bk110\", :genre \"Computer\", :description \"Microsoft'\"s .NET initiative is explored in\\n            detail in this deep programmer\"'s reference.\", :title \"Microsoft .NET: The Programming Bible\", :author \"O'\"Brien, Tim\", :publish_date \"2000-12-09\", :price \"36.95\"} {:id \"bk111\", :genre \"Computer\", :description \"The Microsoft MSXML3 parser is covered in\\n            detail, with attention to XML DOM interfaces, XSLT processing,\\n            SAX and more.\", :title \"MSXML3: A Comprehensive Guide\", :author \"O\"'Brien, Tim\", :publish_date \"2000-12-01\", :price \"36.95\"} {:id \"bk112\", :genre \"Computer\", :description \"Microsoft Visual Studio 7 is explored in depth,\\n            looking at how Visual Basic, Visual C++, C#, and ASP+ are\\n            integrated into a comprehensive development\\n            environment.\", :title \"Visual Studio 7: A Comprehensive Guide\", :author \"Galos, Mike\", :publish_date \"t2001-04-16\", :price \"49.95\"}]}]} )" )

  (format-transformation-fn "(from_edn_data \"{:cata [{:book [{:id \\\"bk101\\\", :genre \\\"Computer\\\", :description \\\"An in-depth look at creating applications\\\\n            with XML.\\\", :title \\\"XML Developer\"'s Guide\\\", :author \\\"Gambardella, Matthew\\\", :publish_date \\\"2000-10-01\\\", :price \\\"44.95\\\"}]}]}\"  )")



  (format-transformation-fn "(where (= ref_mapping/oe_name 2))")

  (format-transformation-fn "(where (= ref_mapping/oe_name 2))")


  (format-transformation-fn "(from_edn_data \"{:cata [{:book [{:id \\\"bk101\\\", :genre \\\"Computer\\\", :description \\\"An in-depth look at creating applications\\\\n            with XML.\\\", :title \\\"XML Developer\"'s Guide\\\", :author \\\"Gambardella, Matthew\\\", :publish_date \\\"2000-10-01\\\", :price \\\"44.95\\\"} {:id \\\"bk102\\\", :genre \\\"Fantasy\\\", :description \\\"A former architect battles corporate zombies,\\\\n            an evil sorceress, and her own childhood to become queen\\\\n            of the world.\\\", :title \\\"Midnight Rain\\\", :author \\\"Ralls, Kim\\\", :publish_date \\\"2000-12-16\\\", :price \\\"5.95\\\"} {:id \\\"bk103\\\", :genre \\\"Fantasy\\\", :description \\\"After the collapse of a nanotechnology\\\\n            society in England, the young survivors lay the\\\\n            foundation for a new society.\\\", :title \\\"Maeve Ascendant\\\", :author \\\"Corets, Eva\\\", :publish_date \\\"2000-11-17\\\", :price \\\"5.95\\\"} {:id \\\"bk104\\\", :genre \\\"Fantasy\\\", :description \\\"In post-apocalypse England, the mysterious\\\\n            agent known only as Oberon helps to create a new life\\\\n            for the inhabitants of London. Sequel to Maeve\\\\n            Ascendant.\\\", :title \\\"Oberon'\"s Legacy\\\", :author \\\"Corets, Eva\\\", :publish_date \\\"2001-03-10\\\", :price \\\"5.95\\\"} {:id \\\"bk105\\\", :genre \\\"Fantasy\\\", :description \\\"The two daughters of Maeve, half-sisters,\\\\n            battle one another for control of England. Sequel to\\\\n            Oberon\"'s Legacy.\\\", :title \\\"The Sundered Grail\\\", :author \\\"Corets, Eva\\\", :publish_date \\\"2001-09-10\\\", :price \\\"5.95\\\"} {:id \\\"bk106\\\", :genre \\\"Romance\\\", :description \\\"When Carla meets Paul at an ornithology\\\\n            conference, tempers fly as feathers get ruffled.\\\", :title \\\"Lover Birds\\\", :author \\\"Randall, Cynthia\\\", :publish_date \\\"2000-09-02\\\", :price \\\"4.95\\\"} {:id \\\"bk107\\\", :genre \\\"Romance\\\", :description \\\"A deep sea diver finds true love twenty\\\\n            thousand leagues beneath the sea.\\\", :title \\\"Splish Splash\\\", :author \\\"Thurman, Paula\\\", :publish_date \\\"2000-11-02\\\", :price \\\"4.95\\\"} {:id \\\"bk108\\\", :genre \\\"Horror\\\", :description \\\"An anthology of horror stories about roaches,\\\\n            centipedes, scorpions  and other insects.\\\", :title \\\"Creepy Crawlies\\\", :author \\\"Knorr, Stefan\\\", :publish_date \\\"2000-12-06\\\", :price \\\"4.95\\\"} {:id \\\"bk109\\\", :genre \\\"Science Fiction\\\", :description \\\"After an inadvertant trip through a Heisenberg\\\\n            Uncertainty Device, James Salway discovers the problems\\\\n            of being quantum.\\\", :title \\\"Paradox Lost\\\", :author \\\"Kress, Peter\\\", :publish_date \\\"2000-11-02\\\", :price \\\"6.95\\\"} {:id \\\"bk110\\\", :genre \\\"Computer\\\", :description \\\"Microsoft'\"s .NET initiative is explored in\\\\n            detail in this deep programmer\"'s reference.\\\", :title \\\"Microsoft .NET: The Programming Bible\\\", :author \\\"O'\"Brien, Tim\\\", :publish_date \\\"2000-12-09\\\", :price \\\"36.95\\\"} {:id \\\"bk111\\\", :genre \\\"Computer\\\", :description \\\"The Microsoft MSXML3 parser is covered in\\\\n            detail, with attention to XML DOM interfaces, XSLT processing,\\\\n            SAX and more.\\\", :title \\\"MSXML3: A Comprehensive Guide\\\", :author \\\"O\"'Brien, Tim\\\", :publish_date \\\"2000-12-01\\\", :price \\\"36.95\\\"} {:id \\\"bk112\\\", :genre \\\"Computer\\\", :description \\\"Microsoft Visual Studio 7 is explored in depth,\\\\n            looking at how Visual Basic, Visual C++, C#, and ASP+ are\\\\n            integrated into a comprehensive development\\\\n            environment.\\\", :title \\\"Visual Studio 7: A Comprehensive Guide\\\", :author \\\"Galos, Mike\\\", :publish_date \\\"2001-04-16\\\", :price \\\"49.95\\\"}]}]}\" )" )

  )



(defn convert-quote-to-string [v]
  ;(clojure.pprint/pprint v)
  (when v
    (let [v1 (seq v)]
      ; (println "--" v1)
      (loop [[f1 & r] v1
             toggle true
             out []]
       ; (println "--" out)
        (if (nil? f1)
          (apply str out)
          (if (= f1 \')
            (if toggle
              (recur r (not toggle) (conj out "\"'"))
              (recur r (not toggle) (conj out "'\"")))
            (recur r toggle (conj out f1))))))))


(comment

  (format-transformation-fn "(from_edn_data {:f_name \"adsf\", :l_name \"asdf\", :address {:road_no 334}}  )")

  )

(defn tranformation-make-lower-case [v]
  (clojure.walk/postwalk (fn [w1]
                           (if (and
                                 (string? w1)
                                 (not (clojure.string/starts-with? w1 "'"))
                                 (clojure.string/includes? w1 "/"))
                             (clojure.string/lower-case w1)
                             w1)) v))


(defn format-transformation [v]
  (-> v
      (convert-quote-to-string)

      ;(p/log-v)
      (format-transformation-fn)

      (tranformation-make-lower-case)
      )
  )


(comment



  ;(not (not true))

  (->> (seq "'asdf' 'asdf'")
       ;       (apply str)
       )


  ;(convert-quoute-to-string "'asdf asdf' 'asdf'")

  (clojure.string/rep)

  (clojure.string/split "test  test   " #" ")

  )


#_(def entity-xf (map (fn [mapping]
                        (condp = (count mapping)
                          2
                          (let [[f-tocken s-token] mapping]
                            (if (gu/is-transformation? s-token)
                              {:name f-tocken :transfer_fn s-token}
                              {:name f-tocken :field_name s-token}))
                          (zipmap [:name :field_name :transfer_fn :type] mapping))
                        )))

(def processing-xf (comp
                     (map (fn [mapping]
                            (if (map? mapping)
                              mapping
                              (condp = (count mapping)
                                2
                                (let [[f-tocken s-token] mapping]
                                  (if (gu/is-transformation? s-token)
                                    {:name f-tocken :transfer_fn s-token}
                                    {:name f-tocken :field_name s-token}))
                                (zipmap [:name :field_name :transfer_fn :field_type] mapping)))))
                     (map (fn [m]
                            ;(println "--" m )
                            (let [[n t topic_name partition] (if (string? (get m :name))
                                                               (clojure.string/split (get m :name) #" ")
                                                               (get m :name)
                                                               )]
                              ;(println "--" t)
                              (assoc m :name n :stream-type t :topic topic_name :partition partition))))
                     (map (fn [m]
                            (let [[field-name & field-type] (when-let [field-name (get m :field_name)]
                                                              (into [] (remove clojure.string/blank?) (clojure.string/split field-name #" ")))]
                              (if (empty? field-type)
                                (-> m
                                    (update :field_type (fn [v] (if v [v] nil)))
                                    vector)
                                (if
                                  (and (= 2 (count field-type))
                                       (= "key" (second field-type)))
                                  [(assoc m :field_name field-name :field_type (into [] field-type))
                                   (assoc (select-keys m [:name]) :transfer_fn (str "(key " field-name " )"))]
                                  [(assoc m :field_name field-name :field_type (into [] field-type))])))))
                     cat
                     (map (fn [m]
                        ;    (clojure.pprint/pprint m )

                            (if (get m :transfer_fn)
                                    (update m :transfer_fn format-transformation)
                                    m)))
                     (map (fn [m]
                            ;(println "--" m )
                        ;    (clojure.pprint/pprint m )
                            (-> m
                                (update :name clojure.string/lower-case)
                                (update :field_name (fn [v]
                                                      (when v
                                                        (clojure.string/lower-case v)))))))
                     #_(map (fn [m]
                              (let [m (if (get m :doc)
                                        m
                                        (assoc m :doc ""))]
                                m)))))

(defn update-key-set [mapping-coll]
  (let [xf (comp
             (filter (fn [m]
                       (if (and (nil? (get m :field_type))
                                (not= nil (get m :transfer_fn)) ;
                                (contains? #{"key"} (get-in m [:transfer_fn 0])))
                         true false)))
             (map :transfer_fn)
             (filter (fn [v]
                       (= "key" (first v))))
             (map (fn [[t v]] {v t})))
        k-m (into {} xf mapping-coll)

        ]
    (into [] (comp (remove (fn [m]
                             (if (and (nil? (get m :field_type))
                                      (contains? #{"key"} (get-in m [:transfer_fn 0])))
                               true false
                               )
                             ))
                   (map (fn [m]
                          (if (get k-m (get m :field_name))
                            (let [t (if (sequential? (get m :field_type))
                                      (first (get m :field_type))
                                      (or (get m :field_type) "string")
                                      )]
                              (assoc m :field_type [t "key"])
                              )

                            m
                            )

                          ))
                   )

          mapping-coll)
    ))


(defn update-type [mapping-coll]
  (let [xf (comp
             (filter (fn [m]
                       (if (and (nil? (get m :field_type))
                                (not= nil (get m :transfer_fn)) ;
                                (contains? #{"type"} (get-in m [:transfer_fn 0])))
                         true false)))
             (map :transfer_fn)
             (filter (fn [v]
                       (= "type" (first v)))))
        k-m (into {} xf mapping-coll)
        ;_ (println "--" k-m )
        mapping-coll (into [] (comp (remove (fn [m]
                                              (if (and (nil? (get m :field_type))
                                                       (contains? #{"type"} (get-in m [:transfer_fn 0])))
                                                true false
                                                )
                                              ))

                                    )

                           mapping-coll)

        mapping-coll (if (empty? k-m)
                       mapping-coll
                       (update-in mapping-coll [0] (fn [m]
                                                     (assoc m :stream-type (get k-m "type"))
                                                     ))
                       )

        ]
    ;(println "--" k-m )

    mapping-coll
    )

  )


(defn do-process [mapping-coll]
  (let [out (into [] (comp processing-xf) mapping-coll)
        ;out (update-key-set out)
        ;_ (println "--" key-m)
        ;_ (p/log-v "-first ---------test " out )
        ;out (update-type out )


        ;_ (  out1 )
        w (mapv #(select-keys % [:stream-type :topic :partition]) out)

        ;        _ (println "--" w)
        w (reduce (fn [acc v]
                    (merge acc v)
                    ) {} (reverse w))  #_(apply merge-with merge (reverse w))
        ;       _ (println "--out " out)
        [f & r] out
        f (merge f w)

        r (into [] (map (fn [m]
                          (dissoc m :stream-type :topic :partition)
                          )) r)
        ]
    (into [f] r)
    )
  )



(defmethod p/read-req :default
  [_ mapping-coll-coll]
  (->> mapping-coll-coll
       (mapv do-process)))


(defmethod p/read-req :csv
  [_ v]
  (->> (read-csv-mapping-file v)
       (mapv do-process)))


(defn as-triple-vector [w]
  (loop [w w
         result []]
    (if (or (nil? w) (empty? w))
      result
      (let [first-entity-name (ffirst w)
            mapping-coll (into [] (take-while (fn [v] (= (first v) first-entity-name)) w))
            new-w (into [] (drop-while (fn [v]
                                         (= (first v) first-entity-name)) w))]
        (recur new-w (conj result mapping-coll))))))


#_(defn convert-to-mapping [w]
    (loop [w w
           result []]
      (if (or (nil? w) (empty? w))
        result
        (let [first-entity-name (ffirst w)
              mapping-coll (into [] (take-while (fn [v] (= (first v) first-entity-name)) w))
              new-w (into [] (drop-while (fn [v]
                                           (= (first v) first-entity-name)) w))]
          (recur new-w (conj result mapping-coll))))))


(defn convert-triple-from-comma [mapping]
  (let [mapping (into [] (map (fn [v]
                                (when (string? v)
                                  (clojure.string/trim v))
                                )) mapping)]
    (loop [mapping mapping
           result []]
      (if (or (nil? mapping)
              (empty? mapping))
        (as-triple-vector result)
        (let [mapping-coll (into [] (take-while (fn [v]
                                                  (not= v ";")) mapping))
              rest-mapping (doall (rest (drop-while (fn [v]
                                                      (not= v ";")) mapping)))]
          (recur rest-mapping (conj result mapping-coll)))))))



(defmethod p/read-req :comma-separator
  [_ v]
  (if (string? v)
    (->> (str "[" (slurp v) "]")
         (edn/read-string)
         ;(p/log-v )
         (convert-triple-from-comma)
         (mapv do-process)
         ;(p/log-v )
         #_(p/read-req :default))

    (->> (convert-triple-from-comma v)
         (mapv do-process)
         #_(p/read-req :default))))


(defn as-triple-vector2 [w]

  (loop [w w
         result []]
    (if (or (nil? w) (empty? w))
      result
      (let [first-entity-name (first (ffirst w))
            ;_ (println "" first-entity-name)
            mapping-coll (into [] (take-while (fn [v] (= (ffirst v) first-entity-name)) w))
            new-w (into [] (drop-while (fn [v]
                                         (= (ffirst v) first-entity-name)) w))]
        (recur new-w (conj result mapping-coll))))))



(defn convert-triple-from-vector [mapping]
  (->> mapping
       (into [] (map (fn [v]
                       (if (string? v)
                         (clojure.string/trim v)
                         v))))
       (partition-all 3)

       (into [] (comp (map (fn [coll]
                             (into [] (comp
                                        (map (fn [v]
                                               (if (symbol? v) (name v) v)
                                               ))
                                        (remove clojure.string/blank?)) coll)))
                      (map (fn [coll]
                             (-> coll
                                 (update 0 clojure.string/split #" "))))))
       ;  (p/log-v)
       (as-triple-vector2)))


(defn as-compiler-schema [v]
  (->> v
       (into [] (map (fn [v]
                       (if (string? v)
                         (clojure.string/trim v)
                         v))))
       (partition-by (fn [v] (= ";" v)))
       (remove (fn [v] (= (list ";") v)))
       (map (fn [v] (condp = (count v)
                          1 (into (vector "_" "_") v)
                          2 (into (vector "_") v)
                           v
                          ) ))
       ;(p/log-v)
       (into [] (comp (map (fn [v]
                             (convert-triple-from-vector v)
                             ))
                      cat
                      ))
       ;(p/log-v)
       ;(convert-triple-from-vector )
       (mapv do-process)))


(defn is-file [file-name]
  (clojure.string/ends-with? file-name ".edn"))

(defmethod p/read-req :triple
  [_ v]

  ;(println "----------------" v)
  (if (string? v)
    (let [v (if (is-file v)
              (str "[" (slurp v) "]")
              (str "[" v "]"))]
      (->> v
           (edn/read-string)
           ;(p/log-v "from read-req ")
           (as-compiler-schema)))
    (as-compiler-schema v)))




(comment






  (re-matches #"([a-zA-Z]:)?(\\\\[a-zA-Z0-9_.-]+)+\\\\?" "hello.edn")



;  (clojure.string/)

  )


#_(defn read-req [v]
    (if (string? v)
      (->> (read-csv-mapping-file v)
           (mapv (fn [w]
                   (into [] processing-xf w))))
      (->> v
           (mapv (fn [v1]
                   (->> (as-request-mapping v1)
                        (into [] processing-xf)))))))




(comment


  ;(clojure.string/blank? "")

  (partition-all 3 [1 2 3 4 5 6 7 8 9 10 34 56])

  (p/read-req :comma-separator-file "test/change-detect-mapping.edn")

  (p/read-req :triple ["cust_raw" "id integer" ""
                       "cust_raw" "name" ""
                       "cust_raw_enrich" "id" "cust_raw/id"]
              )

  (convert-triple-from-vector ["cust_raw" "id integer" ""
                               "cust_raw" "name" ""
                               "cust_raw_enrich" "id" "cust_raw/id"])

  (convert-triple-from-comma ["cust_raw" "id integer" "; "
                              "cust_raw" "name" ";"
                              "cust_raw_enrich" "(change_key cust_raw)" ";"]
                             )


  (convert-triple-from-comma [["test" "a"]])

  #_(->> [[["raw_bnl_claim2"
            "LOCAL_CLAIM_ID"
            "(replace raw_bnl_claim/LOCAL_CLAIM_ID ',' '')"]
           ["raw_bnl_claim2"
            "EFFECTIVE_LOSS_DATE"
            "(replace raw_bnl_claim/EFFECTIVE_LOSS_DATE '/' '-')"]]]
         (read-req)

         )

  (let [w [["cust_stage" "id integer"]
           ["cust_stage" "name"]
           ["cust_stage" "(key id)"]

           ["cust_raw_enrich" "id" "cust_raw/id"]
           ["cust_raw_enrich" "old_id" "cust_stage_tab/id"]
           ["cust_raw_enrich" "name" "cust_raw/name"]
           ["cust_raw_enrich" "(left_join cust_raw/id cust_stage_tab/id )"]

           ["cust_stage" "id" "cust_raw_enrich/id"]
           ["cust_stage" "name" "cust_raw_enrich/name"]]]

    ;(drop-while (fn [v] (= (first v) "cust_stage") ) w )
    (loop [w w
           result []]
      (if (or (nil? w) (empty? w))
        result
        (let [first-entity-name (ffirst w)
              mapping-coll (into [] (take-while (fn [v] (= (first v) first-entity-name)) w))
              new-w (into [] (drop-while (fn [v]
                                           (= (first v) first-entity-name)) w))
              ]
          ;_ (println new-w)
          (recur new-w (conj result mapping-coll))

          )

        )

      ))


  (ffirst [[1 2 3] [4 5]])

  )


