(ns ksql.gen.schema-gen
  (:require [ksql.gen.file-util :as u]
            [ksql.gen.util :as cu]
            [ksql.gen.protocol :as p]))


(def arvo-p-type #{"string" "varchar" "bytes" "double" "float" "long" "int" "integer" "bigint" "boolean" "decimal" "null"})

(defn arvo-type-map [n]
  (if (contains? arvo-p-type (clojure.string/lower-case (or n "string")))
    n
    "string"))



(defn as-vector [trans-fn]
  (clojure.walk/postwalk (fn [v]
                           (if (list? v)
                             (into [] v)
                             v
                             )) trans-fn))




#_(defn process-fields [mapping]
    (let [source-name (cu/get-source-name2 mapping)
          sink-name (get-in mapping [0 :name])]
      {:sink-name   sink-name
       :source-name source-name
       :fields      mapping}))

#_(defn add-logical-type [m]
    ;(println "--" m)
    (if (get m :type)
      (let [type (get m :type "string")]
        (assoc m :type type #_(arvo-type-map type)

                 ))
      m
      )
    )




(defn as-emitter-schema [schema-coll-m mapping]
  (let [source-name (cu/get-source-name2 mapping)
        sink-name (get-in mapping [0 :name])

        {:keys [topic partition stream-type]} (first mapping)

        main-m {:sink-name   sink-name
                :source-name source-name
                ;  :type        (or stream-type "stream")
                :partitions  partition
                :topic       topic}


        schema-m {}
        ;@todo key come as tranformation fn, need to remove this functionality. key should be attached as field
        key-field (->> mapping
                       (mapv :transfer_fn)
                       (remove nil?)
                       (filter (fn [v] (= "key" (first v))))
                       (first)
                       (second))

        ;_ (println "--" key-field)
        fields (into [] (comp
                          (remove (fn [v] (nil? (:field_name v))))
                          (map (fn [v]
                                 (let [tf (as-vector (get v :transfer_fn))
                                       type (get v :field_type)
                                       ;   _ (println "--type" type)
                                       field_type (if (and (= (get v :field_name) key-field)
                                                     (= 1 (count type))
                                                     )
                                              (conj type "key")
                                              type

                                           )
                                       ;_ (println "--" field_type)
                                       ;type-reverse (reverse type)
                                       schema (loop [[ftype & type-coll] (reverse field_type)
                                                     out {}]
                                                (if (nil? ftype)
                                                  out
                                                  (let [
                                                        ;_ (println "--" ftype "-" (keys schema-coll-m ))
                                                        schema (if-let [w (get schema-coll-m ftype)]
                                                                 (do

                                                                   (select-keys w [:fields :type])
                                                                   )
                                                                 {:type ftype :member_schema nil :fields nil}
                                                                 )
                                                        out (if (empty? out)
                                                              schema
                                                              (assoc out :member_schema schema))]
                                                    (recur type-coll out))))]
                                   ;  (println "--type " schema)
                                   {:name        (get v :field_name)
                                    :source-type (get v :source-type)
                                    :schema      schema  #_{:type type :memberSchema nil}
                                    :transfer_fn tf})))
                          ) mapping)

        join (into [] (comp
                        (filter (fn [v]
                                  (and
                                    (nil? (:field_name v))
                                    (contains? #{"join" "left_join" "outer_join"} (first (get v :transfer_fn [""]))))))
                        (map :transfer_fn)
                        ) mapping)

        schema-m (if (empty? join)
                   schema-m
                   (assoc schema-m :join join))

        ;_ (println mapping)
        where (into [] (comp
                         (filter (fn [v]
                                   (and
                                     (nil? (:field_name v))
                                     (contains? #{"where"} (clojure.string/lower-case
                                                             (or (first (get v :transfer_fn [""])) "")
                                                               )))))
                         (map :transfer_fn)
                         ) mapping)

        where (cond
                (= 1 (count where))
                (first where)
                (< 1 (count where))
                ["where" (into ["and"] (mapv second where))]
                :else [])

        schema-m (if (empty? where)
                   schema-m
                   (assoc schema-m :where where))

        other-m (->> mapping
                     (filter (fn [v] (nil? (:field_name v))))
                     (remove (fn [v]
                               (contains? #{"join" "left_join" "outer_join" "where"} (clojure.string/lower-case (first (get v :transfer_fn [""]))))))
                     (mapv :transfer_fn)
                     (group-by first)
                     ;(-> (dissoc "join" "left_join" "outer_join" "where" ))
                     (mapv (fn [[k v]] {(keyword k) (first v)}))
                     (into {})
                     )



        schema-m (merge schema-m other-m)
        ;_ (println "--" schema-m)

        schema-keys (apply disj (into #{} (keys schema-m)) [:fields :sink-name :source-name :type :where :join])
        schema-m (reduce (fn [acc k]
                           (update acc k (fnil second [k nil]))
                           ) schema-m schema-keys)
        ]


    (-> schema-m
        (assoc :fields fields #_(into [] xf fields))
        (merge main-m)
        ;(assoc :key k )
        (update :type (fn [v]
                        (or (second v) stream-type "stream")

                        ) #_(fnil second "stream" #_["type"]))
        )
    ))




#_(defn convert-mapping-schema-to-stream-schema [mapping-schema]

    (->> mapping-schema
         (reduce (fn [acc v]

                   (let [
                         ;key-name (get-in)
                         m (-> v
                               (select-keys [:sink-name :fields :key])
                               (update :fields (fn [coll]
                                                 (mapv #(select-keys % [:name :schema]) coll))))
                         v (if (:name m)
                             m
                             (assoc m :name (get m :sink-name)))
                         n (get v :sink-name)]
                     (if (get acc n)
                       acc
                       (assoc acc n v)))
                   ) {})
         (vals)
         (into [] (comp (map (fn [m]
                               (assoc m :type p/gen-ksql-stream :key (get-in m [:fields 0 :name]))
                               ))))
         )
    )



#_(defn process-entity-one [data-dir w]
    (let [f-path (when (and (:connector_source w)
                            (not (clojure.string/blank? (:connector_source w))))
                   (str data-dir "/" (get w :connector_ref_name) ".csv"))
          fields (when f-path
                   (let [delimiter (get w :delimiter)
                         separator (if (= delimiter ";") \; \,)]
                     (->> f-path
                          (u/get-csv-header separator)
                          (into #{})
                          (mapv (fn [v]
                                  {:name v, :schema {:type "STRING"}})))))
          w (if fields (assoc w :fields fields) w)]
      (-> w
          (assoc :connector_source_path f-path)
          (update-in [:connector_source] (fn [v]
                                           (if (clojure.string/blank? v)
                                             nil
                                             (->> (clojure.string/split v #" ")
                                                  #_(into [] (map keyword)))
                                             #_(keyword v))))
          (update-in [:name] clojure.string/lower-case)
          (update-in [:key] (fn [v]
                              (let [v (clojure.string/lower-case v)]
                                (if (clojure.string/blank? v)
                                  nil
                                  (let [w (-> (clojure.string/trim v)
                                              (clojure.string/split #" "))]
                                    (if (= 1 (count w))
                                      (first w)
                                      w))))))
          (update-in [:connector_sink] (fn [v]
                                         (if (clojure.string/blank? v)
                                           nil
                                           (->> (clojure.string/split v #" ")

                                                #_(into [] (map keyword)) #_(keyword v))
                                           ))))))

;(clojure.string/split "asdf" #" ")

#_(defn process-entity-batch [data-dir coll]
    (let [xf (comp
               (remove (fn [v] (clojure.string/blank? (get v :name))))
               (map (fn [v] (process-entity-one data-dir v)))
               (map (fn [w] {(get w :name) w})))]
      (into {} xf coll)))

#_(defn process-entity-file [entity-file-name data-dir]
    (process-entity-batch data-dir (u/read-csv-file entity-file-name))
    #_(let [xf (comp
                 (map (fn [v] (process-entity-one data-dir v)))
                 (map (fn [w] {(get w :name) w})))]
        (into {} xf (u/read-csv-file entity-file-name))))


#_(defn gen-data-schema [meta-data-dir data-dir entity-prefix]
    (into {} (map (fn [v]
                    (process-entity-batch data-dir (u/read-csv-file v))
                    )) (u/get-file-list-by-prefix entity-prefix meta-data-dir)))

(comment


  ;(clojure.string/split "test tst " #" ")

  (u/read-csv-file "app/allianz_life/meta-data/entity-mapping.csv")

  (gen-data-schema "app/allianz_life/src" "app/allianz_life/data" "entity-")


  (process-entity-file "app/allianz_life/meta-data/entity-mapping.csv" "app/allianz_life/source")


  (u/read-csv-file "data/meta-data/field-gen.csv")

  (u/read-csv-file "data/meta-data/entity-gen.csv")

  (read-key-map-file "data/config/source.csv")

  (get-file-list ".csv" "data/meta-data")


  (->> (u/read-csv-file "data/meta-data/entity-gen.csv")
       (into [] (gen-schema-from-data-dir "data/source")))

  (-> (model-from-entity-mapping "data/meta-data/entity-gen.csv" "data/source")
      ;(arvo-schema-from-csv)
      )

  )