(ns ksql.gen.expand-macro-impl
  (:require [ksql.gen.protocol :as p]
            [ksql.gen.reader.csv-data-reader :as r]
            [ksql.gen.reader.mapping-reader :as mr]
            [ksql.gen.schema-gen :as sg]
            [ksql.gen.util :as u]
            [cheshire.core :as json]
            [clojure.tools.reader.edn :as edn]))


(defmulti expand-flow-internal (fn [_ mapping-fields] (first (get (first mapping-fields) :transfer_fn))))


(defmethod expand-flow-internal :default
  [_ mapping]
  ;(println "--" mapping)
  [mapping]
  )


(defn map-other-fields [e-name r-mapping]
  (into [] (comp (map (fn [m] ((juxt :field_name :transfer_fn) m) ))
                 (map (fn [[f m]]
                        (let [f (if (= "_" f) "" f)
                              m (if (sequential? m)
                                  (str "( " (clojure.string/join " " m ) " ) ")
                                  m
                                  )
                              ]
                          [f m ]
                          )
                        ))
                 (map (fn [v]
                        (into [e-name] v)
                        ))
                 cat


                 )  r-mapping)
  )


(defmethod p/expand-flow "from_csv_file"
  [_ mapping]

  (let [t-mapping (first mapping)
        [_ file_name] (get t-mapping :transfer_fn)
        n (get t-mapping :name)
        n (if (= "_" n) nil n)
        n (or n (r/get-file-name file_name))

        r-mapping (map-other-fields n (rest mapping))
       ; _ (p/log-v r-mapping)

        header (r/read-csv-header (clojure.string/replace file_name "'" ""))
        header (r/format-csv-header header)
        fields (reduce (fn [acc k]
                         (into acc [n k " "])
                         ) [] header)

        fields (into fields r-mapping)
        fields (into fields [n "" "(value_format 'AVRO')"])
        ;_ (p/log-v fields)
        ]
    [fields]))


(defmethod p/expand-flow "from_csv_folder"
  [_ mapping]
  (let [t-mapping (first mapping)
        [_ csv-folder-name] (get t-mapping :transfer_fn)
        out (r/get-all-file-name csv-folder-name "glob:*.{csv}")]
    (into [] (map (fn [[file-name file-path]]
                    (let [header (r/read-csv-header file-path)
                          header (r/format-csv-header header)
                          out (reduce (fn [acc k]
                                        (into acc [file-name k " "])
                                        ) [] header)

                          r-mapping (map-other-fields file-name (rest mapping))
                          out (into out r-mapping)
                          out (into out [file-name "" "(value_format 'AVRO')"])]
                      out)
                    )) out)))


(comment

  (get-all-file-name "app/itmp/data/source" "glob:*.{json}")


  #_(edn/read-string (pr-str {:f_name "adsf" :l_name "asdf" :address {:road_no 334} }) )

  )


(defn get-type [v]
  ;(println "--" v)
  (cond
    (double? v) "double"
    (number? v) "bigint"
    :else "string"
    )
  )




(defn from-edn-to-mapping [stream-name stream-value]
;  (p/log-v stream-value)

  (let []

    (letfn [(xf [e-type e-name m]
              (let [w (into [] (comp (filter (fn [v] (or (map? (second v))
                                                         (and (sequential? (second v))
                                                              (map? (first (second v)))
                                                              )
                                                         ) #_(coll? (second v))))
                                     (map (fn [v]
                                            ;     (println v)
                                            (xf "struct" (str e-name "_" (name (first v))) (if (sequential? (second v))
                                                                                             (first (second v))
                                                                                             (second v)
                                                                                             ))))
                                     cat
                                     ) m)]
                (into w (comp (map (fn [[index k]]
                                     (let [
                                           ;e-name (if (= "struct" e-type)     (str e-name "_struct")              e-name                                               )
                                           t (cond
                                               (and (sequential? (get m k))
                                                    (map? (first (get m k))))
                                               (str e-name "_" (clojure.string/lower-case (name k)) "_struct" " array")

                                               (and (sequential? (get m k))
                                                    (not (sequential? (first (get m k))))
                                                    )
                                               (str (get-type (first (get m k))) " array")

                                               (map? (get m k))
                                               (str e-name "_" (clojure.string/lower-case (name k)) "_struct")

                                               :else (get-type (get m k)))

                                           e-name (if (= e-type "struct")
                                                    (str e-name "_struct")
                                                    e-name
                                                    )

                                           n (if (= 0 index)
                                               (str e-name " " e-type)
                                               e-name)

                                           ]
                                       [n (str (name k) " " t) ""])))
                              ) (map-indexed vector (keys m)))))]
      (->> (into (xf "stream" stream-name stream-value) [[stream-name "" "(value_format 'json')"]])
           ;(p/log-v)
           (into [] cat))
      )
    )

  )





(comment



  (map-from-json-data-file "test/resources/person.json")

  )





(defmethod p/expand-flow "from_edn_data"
  [_ mapping]
  (let [mapping (first mapping)
        [_ edn-data] (get mapping :transfer_fn)
        n (get mapping :name)
        n (if (= "_" n) nil n)
        edn-data (edn/read-string edn-data)
        w (from-edn-to-mapping n edn-data)]
    [w]))



(defn from-xml-to-mapping-impl [n file-path]
  (let [f-name (or n (r/get-file-name file-path))
        v (r/convert-xml-file-to-edn file-path)
        w (from-edn-to-mapping f-name v)]
    w))



(defmethod p/expand-flow "from_xml_file"
  [_ mapping]
  (let [mapping (first mapping)
        n (get mapping :name)
        n (if (= "_" n) nil n)
        [_ file-path] (get mapping :transfer_fn)
        w (from-xml-to-mapping-impl n file-path)]
    [w]))


(defmethod p/expand-flow "from_xml_folder"
  [_ mapping]
  (let [mapping (first mapping)
        ; n (get mapping :name)
        [_ json-folder-name] (get mapping :transfer_fn)

        out (r/get-all-file-name json-folder-name "glob:*.{xml}")]
    (into [] (comp
               (map (fn [[file-name file-path]]

                      (from-xml-to-mapping-impl file-name file-path)))
               ) out)))


(defn map-from-json-schema-file [file-name json-file-path]
  (let [json-str (slurp json-file-path)
        edn-str (json/parse-string json-str true)
        f-name (or
                 file-name
                 (r/get-file-name json-file-path))
        w (from-edn-to-mapping f-name edn-str)]
    w
    )

  )


(defn map-from-json-data-file [n json-file-name]
  (let [json-str (with-open [rdr (clojure.java.io/reader json-file-name)]
                   (first (line-seq rdr)))
        edn-str (json/parse-string json-str true)
        ;_ (p/log-v edn-str)
        f-name (or n
                   (-> json-file-name
                       (clojure.string/split #"/")
                       (last)
                       (clojure.string/split #"\.")
                       (first)))
        w (from-edn-to-mapping f-name edn-str)
        ;     _ (clojure.pprint/pprint w)

        ]
    ;edn-str
    w
    )

  )


(defmethod p/expand-flow "from_json_file"
  [_ mapping]
  (let [mapping (first mapping)
        ; n (get mapping :name)
        [_ json_file_name] (get mapping :transfer_fn)
        n (get mapping :name)
        n (if (= "_" n) nil n)
        w (map-from-json-data-file n json_file_name)]
    [w]
    ))


(defmethod p/expand-flow "from_json_folder"
  [_ mapping]
  (let [mapping (first mapping)
        ; n (get mapping :name)
        [_ json-folder-name] (get mapping :transfer_fn)
        out (r/get-all-file-name json-folder-name "glob:*.{json}")]
    (into [] (comp
               (map (fn [[file-name file-path]]
                      (map-from-json-data-file file-name file-path)))
               ) out))
  #_(let [mapping (first mapping)
        ; n (get mapping :name)
        [_ json_file_name] (get mapping :transfer_fn)
        n (get mapping :name)
        n (if (= "_" n) nil n)
        w (map-from-json-data-file n json_file_name)]
    [w]
    ))



(defmethod p/expand-flow "from_json_schema_file"
  [_ mapping]

  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ json_file_name] (get mapping :transfer_fn)
        n (get mapping :name)
        n (if (= "_" n) nil n)
        w (map-from-json-schema-file n json_file_name)]
    [w]))


(defmethod p/expand-flow "from_json_schema_folder"
  [_ mapping]
  (let [mapping (first mapping)
        ; n (get mapping :name)
        [_ json-folder-name] (get mapping :transfer_fn)
        out (r/get-all-file-name json-folder-name "glob:*.{json}")]
    (into [] (comp
               (map (fn [[file-name file-path]]
                      (map-from-json-schema-file file-name file-path)))
               ) out)))




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defn flatten-mapping-impl [schema-coll mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)
        fields (into [] (comp (filter (fn [m]
                                        (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                              (remove (fn [m]
                                        (and
                                          (contains? #{"array"} (get-in m [:schema :type]))
                                          (not= "struct" (get-in m [:schema :member_schema :type]))))))
                     fields)
        {:keys [array-list struct-list]} (group-by (fn [m]
                                                     (if (= "array" (get-in m [:schema :type]))
                                                       :array-list
                                                       :struct-list)
                                                     ) fields)
        struct-m (for [w struct-list
                       f (get-in w [:schema :fields])]
                   (let [t (if (= "struct" (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                             (get-in f [:schema :type])
                             )]
                     ;    (println "--" t)
                     [(str source-name "_" (get w :name))
                      (str (get f :name) " " t)
                      (str source-name "/" (get w :name) "->" (get f :name))]
                     )
                   )
        out-mapping (into [] struct-m)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w array-list]
            [(str source-name "_" (get w :name) coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        array-list (for [w array-list
                         f (get-in w [:schema :member_schema :fields])]
                     [
                      ;(get w :name)
                      (str source-name "_" (get w :name))
                      (str (get f :name) " " (get-in f [:schema :type]))
                      (str source-name "_" (get w :name) coll_postfix "/" (get w :name) "->" (get f :name))])
        ;_ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping array-list)]

    ;    (clojure.pprint/pprint out-mapping)
    out-mapping))



(defmethod p/expand-flow "flatten"
  [schema-coll mapping]
  (let [out-mapping (flatten-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))



(defn get-mapping-impl [schema-coll mapping]
  ;(println "--" mapping)
  (let [mapping (first mapping)
        [_ source-name source-ref-name] (get mapping :transfer_fn)
        ;     _ (println "---" source-name)
        sink-name (get mapping :name)
        ;  _ (println "--" sink-name)

        w (reduce (fn [acc v]
                    (if (= (clojure.string/lower-case source-name)
                           (clojure.string/lower-case (get v :sink-name)))
                      (reduced v)
                      acc)
                    ) [] schema-coll)

        ;    _ (when (= "body" source-name) (p/log-v w))
        fields (get w :fields)
        ;   _ (clojure.pprint/pprint fields)
        fields (into [] (comp
                          (filter (fn [m] (= (clojure.string/lower-case source-ref-name)
                                             (clojure.string/lower-case (get m :name)))))
                          (filter (fn [m]
                                    (contains? #{"struct" "array"} (get-in m [:schema :type]))))
                          (remove (fn [m]
                                    (and
                                      (contains? #{"array"} (get-in m [:schema :type]))
                                      (not= "struct" (get-in m [:schema :member_schema :type]))))))
                     fields)
        {:keys [array-list struct-list]} (group-by (fn [m]
                                                     (if (= "array" (get-in m [:schema :type]))
                                                       :array-list
                                                       :struct-list)
                                                     ) fields)
        struct-m (for [w struct-list
                       f (get-in w [:schema :fields])]
                   (let [t (if (= "struct" (get-in f [:schema :type]))
                             (str source-name "_" (get w :name) "_" (get f :name) "_struct")
                             (get-in f [:schema :type])
                             )]
                     ;    (println "--" t)
                     [(str source-name "_" (get w :name))
                      (str (get f :name) " " t)
                      (str source-name "/" (get w :name) "->" (get f :name))]
                     )
                   )
        out-mapping (into [] struct-m)
        ;_ (p/log-v out-mapping)
        coll_postfix "_coll"

        v (for [w array-list]
            [(str sink-name coll_postfix)
             (get w :name)
             (str "(explode " source-name "/" (get w :name) ")")])

        array-list (for [w array-list
                         f (get-in w [:schema :member_schema :fields])]
                     [
                      ;(get w :name)
                  ;    (str source-name "_" (get w :name))
                      sink-name
                      (str (get f :name) " " (get-in f [:schema :type]))
                      (str  sink-name  coll_postfix "/" (get w :name) "->" (get f :name))])

        ;_ (clojure.pprint/pprint array-list)
        out-mapping (into out-mapping v)
        out-mapping (into out-mapping array-list)]

    ;    (clojure.pprint/pprint out-mapping)
    out-mapping))


(defmethod p/expand-flow "get"
  [schema-coll mapping]
  (let [out-mapping (get-mapping-impl schema-coll mapping)
        out-mapping (into [] cat out-mapping)]
    [out-mapping]))


#_(defmethod p/expand-flow "from_json_folder"
    [_ mapping]
    (let [mapping (first mapping)
          ; n (get mapping :name)
          [_ json-folder-name] (get mapping :transfer_fn)
          out (get-all-file-name json-folder-name "glob:*.{json}")]
      (into [] (comp
                 (map (fn [[file-name file-path]]
                        (->> (map-from-json-schema-file file-path)
                             #_(mr/as-compiler-schema))))
                 cat
                 ) out)))



;csv-file-list (get-all-files csv-folder-name "glob:*.{csv}")


(defmethod expand-flow-internal "map_before"
  [schema-coll mapping]
  ;(  mapping)
  (let [mapping (first mapping)
        n (get mapping :name)
        ; n (get mapping :name)
        [_ source-name key-name] (get mapping :transfer_fn)
        schema (u/get-source-schema schema-coll source-name)
        fields (get schema :fields)
        stage-name (str source-name "_stage")
        stage-name-tab (str stage-name "_tab")
        ;statge-enrich (str source-name "_stage")

        stage-mapping-fields (into [] (map (fn [field]
                                             (-> field
                                                 (assoc :name stage-name)
                                                 (assoc :field_name (get field :name))
                                                 (dissoc :schema)
                                                 (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                                 )
                                             )) fields)

        stage-mapping-fields (conj stage-mapping-fields {:name        stage-name
                                                         :transfer_fn ["key" key-name]})

        cust_stage_tab-fields (into [] (map (fn [field]
                                              (-> field
                                                  (assoc :name stage-name-tab)
                                                  (assoc :field_name (get field :name))
                                                  (dissoc :schema)
                                                  (assoc :transfer_fn ["as" (str stage-name "/" (get field :name))])
                                                  )
                                              )) fields)

        cust_stage_tab-fields (into cust_stage_tab-fields [{:name        stage-name-tab
                                                            :transfer_fn ["key" key-name]}
                                                           {:name        stage-name-tab
                                                            :transfer_fn ["type" "table"]}])
        enrich-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name n)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                          )
                                      )) fields)


        enrich-fields_full (into enrich-fields (map (fn [field]
                                                      (-> field
                                                          (assoc :name n)
                                                          (assoc :field_name (str (get field :name) "_before"))
                                                          (dissoc :schema)
                                                          (assoc :transfer_fn ["as" (str stage-name-tab "/" (get field :name))])
                                                          )
                                                      )) fields)

        enrich-fields_full (into enrich-fields_full [{:name        n
                                                      :transfer_fn ["left_join"
                                                                    (str source-name "/" key-name)
                                                                    (str stage-name-tab "/" key-name)
                                                                    ]}
                                                     ])
        insert-fields (into [] (map (fn [field]
                                      (-> field
                                          (assoc :name stage-name)
                                          (assoc :field_name (get field :name))
                                          (dissoc :schema)
                                          (assoc :transfer_fn ["as" (str n "/" (get field :name))])
                                          )
                                      )) fields)]
    [stage-mapping-fields
     cust_stage_tab-fields
     enrich-fields_full
     insert-fields]))






(comment



  (let [grammar-matcher (.getPathMatcher
                          (java.nio.file.FileSystems/getDefault)
                          "glob:*.{csv}")]
    (->> "test/resources"
         clojure.java.io/file
         file-seq
         (filter #(.isFile %))
         (filter #(.matches grammar-matcher (.getFileName (.toPath %))))
         (mapv #(.getName %))
         #_(mapv #(.getAbsolutePath %)))

    )


  (->> (clojure.java.io/file "test/resources")
       (file-seq)
       (filter #(.isFile %))
       ; (first)
       (take 3)
       #_(doall))

  )





(defmethod p/expand-step "lookup"
  [_ _ mapping-field]
  (let [[t lookup-key w] (into [] (get mapping-field :transfer_fn))
        [_ source-key rel-key] (into [] w)]
    (vector
      (assoc mapping-field :transfer_fn (vector "as" lookup-key))
      (assoc mapping-field :transfer_fn (vector "left_join" source-key rel-key) :field_name nil))))


;latest_by_offset

(defmethod p/expand-step "latest_by_offset"
  [schema-coll selectd-fields mapping-field]
  ;(println "--rekey " )
  (let [sink-name (get mapping-field :name)
        [_ source-name key-name] (get mapping-field :transfer_fn)
        schema (u/get-source-schema schema-coll source-name)
        fields (get schema :fields)
        fields (into []
                     (comp

                       (map (fn [field]

                              (-> field
                                  (assoc :name sink-name)
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["latest_by_offset" (str source-name "/" (get field :name))])
                                  )
                              )))
                     fields)
        fields (into fields [{:name        sink-name
                              :transfer_fn ["key" key-name]}
                             {:name        sink-name
                              :transfer_fn ["group_by" key-name]}
                             {:name        sink-name
                              :transfer_fn ["type" "table"]}])]

    fields

    )

  )



(defmethod p/expand-step "rekey"
  [schema-coll selectd-fields mapping-field]
  ;(println "--rekey " )
  (let [sink-name (get mapping-field :name)
        [_ source-name key-name] (get mapping-field :transfer_fn)
        schema (u/get-source-schema schema-coll source-name)
        fields (get schema :fields)
        fields (into []
                     (comp

                       (map (fn [field]

                              (-> field
                                  (assoc :name sink-name)
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])
                                  )
                              )))
                     fields)
        fields (into fields [{:name        sink-name
                              :transfer_fn ["key" key-name]}
                             {:name        sink-name
                              :transfer_fn ["ksql-gen-type" p/gen-ksql-rekey-stream-from-mapping]}])]

    fields

    )

  )

(defmethod p/expand-step "select"
  [schema-coll selectd-fields mapping-field]
  ;(  selectd-fields)
  (let [field-names (rest (get mapping-field :transfer_fn))
        w (mapv (fn [v]
                  (clojure.string/split v #"/")
                  ) field-names)
        ;_ (println "--" w)
        entity-name (distinct (into [] (comp (map first)
                                             ) w))
        field-names (into #{} (distinct (into [] (comp
                                                   (map second)
                                                   (remove nil?)
                                                   (map clojure.string/upper-case)
                                                   ) w)))
        _ (when (< 1 (count entity-name))
            (throw (ex-info "select should be only one entity, found more than one " {:value entity-name})))
        ;_ (println "--fields names" field-names)
        source-name (clojure.string/lower-case (first entity-name))
        schema (u/get-source-schema schema-coll source-name)
        _ (when (nil? schema)
            (let [available-schema (clojure.string/join ",\n " (mapv :sink-name schema-coll))]
              (throw (ex-info (format "source schema is null for %s, available schema %s " source-name, available-schema) {:source mapping-field}))
              )
            )
        ;k (get schema :key)


        ;field-names (conj field-names k)

        fields (if (or
                     (empty? field-names)
                     (contains? field-names "*"))
                 (get schema :fields)
                 (into [] (filter (fn [v]
                                    (contains? field-names (clojure.string/upper-case (get v :name)))
                                    )) (get schema :fields))
                 )



        previous_field (into #{} (comp (map :field_name)
                                       (remove nil?)
                                       (map clojure.string/lower-case)) selectd-fields)


        fields (into []
                     (comp
                       (remove (fn [field]
                                 (contains? previous_field (clojure.string/lower-case (get field :name)))
                                 ))
                       (map (fn [field]

                              (-> field
                                  (assoc :name (get mapping-field :name))
                                  (assoc :field_name (get field :name))
                                  (dissoc :schema)
                                  (assoc :transfer_fn ["as" (str source-name "/" (get field :name))])))))
                     fields)
        ; _ (  fields)

        ]
    ;(println "---------------------" fields)
    ;[[]]
    fields
    )

  )

(defmethod p/expand-step "where"
  [schema-coll mapping mapping-field]
  ;(  mapping-field)
  (let [field (into [] (comp (map :field_name)
                             (remove nil?)
                             (remove clojure.string/blank?)
                             ) mapping)]
    ; (println "--total count " (count field))

    (if (< 0 (count field))
      [mapping-field]
      (let [entity-name-list (->> mapping-field
                                  :transfer_fn
                                  (flatten)
                                  (filter (fn [v] (clojure.string/includes? v "/")))
                                  (map (fn [v]
                                         (first (clojure.string/split v #"/"))
                                         ))
                                  (distinct)
                                  )
            _ (when (< 1 (count entity-name-list))
                (throw (ex-info "select should be only one entity, found more than one " {:value entity-name-list}))
                )
            ;entity-name (first entity-name-list)
            source-name (clojure.string/lower-case (first entity-name-list))
            ; schema (get schema-m source-name)
            schema (u/get-source-schema schema-coll source-name)
            ; _ (  schema)
            fields (mapv (fn [field]
                           (-> field
                               (assoc :name (get mapping-field :name))
                               (assoc :field_name (get field :name))
                               (dissoc :schema)
                               (assoc :transfer_fn ["as" (str source-name "/" (get field :name))]))
                           ) (get schema :fields))

            fields (conj fields mapping-field)
            ;fields
            #_(conj fields {:name  (get mapping-field :name)
                            ; :transfer_fn ["generator-type" p/gen-ksql-stream-from-stream]
                            :topic (:topic schema)
                            })
            ]
        ;(println "--" source-name)
        fields
        )
      )

    )
  )

(comment



  (flatten ["where" ["=" "tnf_party/gender" "'F'" ["and "]]])

  )



(defn replace-this-macro [field-m field]
  ;(println "" field-m)
  (let [

        field (if (= "as" (first field))
                (second field)
                field
                )]
    (clojure.walk/postwalk (fn [v]
                             (if (and (u/is-namespace? v)
                                      (clojure.string/includes? v "this/"))
                               (let [[_ fields-name] (clojure.string/split v #"/")
                                     v (get field-m fields-name)]
                                 (when (nil? v)
                                   (throw (ex-info (get p/msg :100) field)))
                                 v)
                               v)) field)))


(defn expand-this-macro [mapping]
  ;(p/log-v mapping)
  (let []
    (loop [[field & mapping] mapping
           out []]
      ;(p/log-v field)
      (if (nil? field)
        out
        (let [trans (get field :transfer_fn)
              new-trans (if (clojure.string/includes? (pr-str trans) "this/")
                          (let [m (into {} (comp (map (juxt :field_name :transfer_fn) #_(fn [v] (println v) [(second v) (nth 2 v)]))
                                                 (remove (fn [[v n]] (nil? v)))
                                                 ) out)]
                            (replace-this-macro m trans))
                          trans)
              new-field (assoc field :transfer_fn new-trans)]
          (recur mapping (conj out new-field))
          )
        )
      )
    )

  ;mapping
  )




(defn expand-fields-macro-impl [schema-coll mapping]
  (let [mapping mapping]
    (loop [[f & r] mapping
           result []]
      (if (nil? f)
        result
        (let [w (p/expand-step schema-coll result f)
              field-name-set (into #{} (comp (map :field_name)
                                             (remove nil?)
                                             (remove clojure.string/blank?)
                                             ) w)
              result (into [] (remove (fn [v]
                                        (contains? field-name-set (get v :field_name))) result))
              out (into result w)]
          (recur r out))))))


#_(defmethod expand-flow-internal "from_json_file"
    [_ mapping]
    (let [mapping (first mapping)
          ; n (get mapping :name)
          [_ json_file_name] (get mapping :transfer_fn)
          w (map-from-json-schema-file json_file_name)]
      (mr/as-compiler-schema w)))




(defn do-expand-macro [schema-coll mapping]
  (let [mapping-coll (expand-flow-internal schema-coll mapping)
        mapping-coll (into [] (comp (map (fn [v] (p/expand-flow schema-coll v)))
                                    cat
                                    (map (fn [v]
                                           (if (map? (first v))
                                             [v]
                                             (mr/as-compiler-schema v))))
                                    cat
                                    ) mapping-coll)

        ]
    ;(println mapping-coll)
    ;    (p/log-v mapping-coll)
    ;(println "--"  mapping-coll)
    (into [] (comp
               (remove empty?)
               (map (fn [mapping] (expand-fields-macro-impl schema-coll mapping)))
               (map expand-this-macro)
               ) mapping-coll)

    )

  #_(->> (expand-fields-macro-impl schema-coll mapping)
         (vector)
         (mapv expand-this-macro)))