(ns ksql.gen.emitter.ksql.ksql-gen-trans
  (:require [clojure.walk :as w]
            [clojure.zip :as zip]
            [ksql.gen.util :as u]
            [ksql.gen.protocol :as p]))


(defn add-string-quote [v]
  (let [v (clojure.string/trim v)]
    (if (clojure.string/starts-with? v "'")
      v
      (str "'" v "'"))))


(defn replace-forward-slap [v]
  (cond (number? v)
        v
        (clojure.string/includes? v ")") v
        (u/is-namespace? v)
        (clojure.string/replace v "/" ".")
        :else
        v))

(defn is-constant? [v]
  ;(println  v " --type--"  (type v))
  (if (or (clojure.string/includes? v "/")
          (clojure.string/includes? v ".")
          (clojure.string/includes? v "(")
          (number? v)
          )
    (do
      ;(println "--contant ")
      false
      )

    true
    )
  #_(not (clojure.string/includes? v "/")))

#_(defn constant-as-str [v]
    (str "'" v "'"))

(defn map-constant [v]
  (if (is-constant? v)

    (add-string-quote v)
    v
    )
  )





(comment
  ;(replace-forward-slap "test/sdf")

  ; (constant-as-str "asdfasdf")

  (if (clojure.string/starts-with? e-field "'")
    e-field
    (add-string-quote e-field)
    ;(str "'" e-field "'")
    )
  )


(defmethod p/transfer-fn :default
  [f]
  ;(  f)
  ;(println "--f " f)
  (let [[f & udf] f
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " , " udf)
        uf (str " " f "(" uf " ) ")]
    uf))

(comment

  (p/transfer-fn ["split" "asdfsa/asdf"
                  " ifnull(raw_bnl_policy.inception_date , '00/00/0000' ) "
                  "'/'"])

  )


(defmethod p/transfer-fn "as"
  [f]
  (let [[fn e-field] f]
    (replace-forward-slap e-field)))

(defmethod p/transfer-fn "gen_id"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + '_' + " udf)]
    uf))

(defmethod p/transfer-fn "hash"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + " udf)
        uf (str " md5 (  " uf "  ) ")]
    uf))


(defmethod p/transfer-fn "+"
  [f]
  (let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        ; _ (println "---2" udf )
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + " udf)
        ;uf (str "( " uf " ) ")
        ]

    uf))


(defmethod p/transfer-fn "-"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " - " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "/"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " / " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))

(defmethod p/transfer-fn "="
  [f]
 ;  (println "--"f)
  (let [udf (rest f)
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        ;  _ (println "--" first-arg)
        ; _ (println "--" second-argv)
        o (condp = (clojure.string/lower-case second-argv)
            "'null'"
            (str "" first-arg " is null ")
            "null"
            (str "" first-arg " is null ")
            "'nil'"
            (str "" first-arg " is null ")
            "nil"
            (str "" first-arg " is null ")
            (str "" first-arg " = " " " second-argv " "))
        ; uf (clojure.string/join " = " udf)
        ]
    o))

;(split(raw_bnl_policy.inception_date , '/' )[1] )

(defmethod p/transfer-fn "is_null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)

        uf (str " " udf " is null  ")]
    uf))


(defmethod p/transfer-fn "=null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)

        uf (str " " udf " is null  ")]
    uf))


(defmethod p/transfer-fn "is_not_null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)
        uf (str " " udf " is not null  ")]
    uf))


(defmethod p/transfer-fn "!=null"
  [f]
  (let [[f v] f
        udf (map-constant v)
        udf (replace-forward-slap udf)
        uf (str " " udf " is not null  ")]
    uf))


(defmethod p/transfer-fn "index_of"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        _ (when (nil? second-argv)
            (throw (ex-info "index_of index is missing, please provide array index or map key" {:field_name first-arg :index second-argv}))
            )
        ;uf (clojure.string/join " and " udf)
        uf (str " " first-arg "[" second-argv "]  ")]
    uf))

(defmethod p/transfer-fn "and"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " and " udf)
        uf (str "( " uf " ) ")]
    uf))

(defmethod p/transfer-fn "or"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " or " udf)
        uf (str "( " uf " ) ")]
    uf))


(defmethod p/transfer-fn "*"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " * " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))

(defmethod p/transfer-fn "<>"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " <> " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "<"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " < " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn ">"
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " > " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "!="
  [f]
  (let [udf (rest f)
        udf (mapv map-constant udf)
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " != " udf)
        ;uf (str "( " uf " ) ")
        ]
    uf))


(defmethod p/transfer-fn "where"
  [f]
  (str "where " (apply str (rest f)))

  #_(let [udf (rest f)
          udf (mapv map-constant udf)
          udf (mapv replace-forward-slap udf)
          uf (clojure.string/join " != " udf)
          uf (str "( " uf " ) ")]
      uf))


(defmethod p/transfer-fn "cast"
  [f]
  (let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        [first-arg second-argv :as udf] (mapv replace-forward-slap udf)
        ;_ (println "--" second-argv)
        second-argv (clojure.string/replace second-argv "'" "")
        ; _ (println "---2" udf )
        ;udf (mapv replace-forward-slap udf)
        ;uf (clojure.string/join " + " udf)
        ]
    (str "cast (" first-arg " as " second-argv "  ) ")

    ))


(defmethod p/transfer-fn "concat"
  [f]
  (let [udf (rest f)
        ;_ (println "---" udf )
        udf (mapv map-constant udf)
        ; _ (println "---2" udf )
        udf (mapv replace-forward-slap udf)
        uf (clojure.string/join " + " udf)]
    uf))

(defmethod p/transfer-fn "constant"
  [f]
  (let [[fn e-field] f
        w (if (clojure.string/starts-with? e-field "'")
            e-field
            (add-string-quote e-field)
            ;(str "'" e-field "'")
            )
        ]
    (str " constant ( " w " ) ")))

(defmethod p/transfer-fn "null"
  [f]
  (let [[fn e-field] f]
    (str " vnull () ")))



(declare field-transformation)


(comment

  )

(defn case-transfer-fn
  [f]
;  (  f)
  ;(println "--case tranformation " f)
  ; (println (sequential? (last f)) )
  (let [source-field (if (sequential? (second f))
                       (field-transformation (second f))
                       (replace-forward-slap (second f))
                       )
        f (if (sequential? (last f))
            f
            (->
              (into [] (butlast f))
              (into ["else"])
              (conj (last f))

              )

            )
        input-with-else (split-with (complement #{"else" "ELSE"}) f)
        else-block (first (rest (second input-with-else)))
        ;_ (println else-block)
        else-block2 (if (sequential? else-block)
                      (into [] else-block)
                      else-block
                      ) #_(into [] (first else-block))
        ;_ (println else-block2)
        ;_ (println "--" (type else-block2))
        ;_ (  else-block)
        ;  _ (println "--" (number? else-block2))
        else-block (cond (number? else-block2)
                         else-block2
                         (empty? else-block2)
                         "null"
                         (sequential? else-block2)
                         (field-transformation else-block2)
                         :else
                         (let [v (last f)]

                           (cond

                             (number? v)
                             v
                             (and (not (clojure.string/starts-with? v "'"))
                                      (u/is-namespace? v))
                                 (clojure.string/replace v "/" ".")
                                 (u/is-process-string? v)
                                 v
                                 :else
                                 (add-string-quote v)
                                 ;(str "'" v "'")
                                 )
                           )

                         )

        format-v (fn [k]
                   (cond (number? k)
                         k
                         (sequential? k)
                         (field-transformation k)

                         (u/is-process-string? k)
                         k

                         (clojure.string/includes? k "/")
                         k

                         (= k "null")
                         "null"
                         :else
                         (add-string-quote k)
                         ))

        ;_ (println "--" else-block)
        ;f (if (sequential? (last f))          f            (into [] (butlast f)))
        ;_ (println "--" f)
        cases (into [] (drop 2 (first input-with-else)))  #_(into [] (drop 2 f))
        ;_ (println "--" cases)
        case-st (reduce (fn [acc [condition k v]]
                            ; (println "--" v "--" k  "--" (type k) )
                          (if (nil? v)
                            (str acc " WHEN " (field-transformation [condition source-field] )    " THEN " k)
                            (let [
                                  k1 (format-v k)

                                  v1 (format-v v) #_(cond (number? v)
                                           v
                                           (sequential? v)
                                           (field-transformation v)
                                           (u/is-process-string? v)
                                           v

                                           (clojure.string/includes? v "/")
                                           v


                                           :else
                                           (add-string-quote v)
                                           ;(str "'" v "'")
                                           )
                                  k (if (string? k1)
                                      (replace-forward-slap k1)
                                      k1
                                      )
                                  v (if (string? v1)
                                      (replace-forward-slap v1)
                                      v1
                                      )
                                  ]
                              (str acc " WHEN " source-field " " condition "  " k " THEN " v)
                              )
                            )


                          ) "" cases)]
    (str "CASE " case-st " ELSE " else-block " END ")))





(defn field-transformation [input]
  ;    (println "---input " input )

  ;(  input)

  (->> (w/postwalk (fn [w]
                     (if (and (sequential? w)
                              (= "case" (first w)))
                       (str "( " (case-transfer-fn w) " ) ")
                       w)) input)
       (w/postwalk (fn [w]
                     (if (sequential? w)
                       (let [o (p/transfer-fn w)]
                         ;(println "--" (type o) "--" o)
                         o
                         )

                       w))))
  #_(if (= "case" (first input))
      (case-transfer-fn input)
      ))


(defn breadth-first-search [z]
  (letfn [(zip-children [loc]
            (when-let [first-child (zip/down loc)]
              (take-while (comp not nil?)
                          (iterate zip/right first-child))))]
    (loop [ret []
           queue (conj clojure.lang.PersistentQueue/EMPTY z)]
      (if (seq queue)
        (let [[node children] ((juxt zip/node zip-children) (peek queue))]
          (recur (conj ret node) (into (pop queue) children)))
        ret))
    )
  )



(comment

  (breadth-first-search [1 2 3 [4 5 [9 8]]])

  (field-transformation ["replace" "raw_bnl_claim/effective_loss_date" "'/'" "'-'"])

  #_(field-transformation

      [case customer_re/gender [= 'M' 'Male'] [= 'W' 'FEMALE']]
      transformation -- [case customer_re/gender = ('M', 'Male') = ('W', 'FEMALE')]

      )
  )


;(defmulti make-where-str (fn [v] (count v) ))

#_(declare where-transformation2)

#_(defn make-where-str [w]
    (cond (= 2 (count w))
          (str (first w) " " (second w))
          (= 3 (count w))
          (let [[o first-arg second-arg] w
                first-arg (clojure.string/replace first-arg "/" ".")
                second-arg (clojure.string/replace second-arg "/" ".")]
            (condp = (clojure.string/lower-case second-arg)
              "null"
              (str "(" first-arg " is null )")
              "nil"
              (str "(" first-arg " is null )")
              (str "(" first-arg " " o " " second-arg " )")))
          :else
          (let [[f & r] w
                f (str " " f " ")]
            (->> (mapv (fn [v1]
                         (where-transformation2 v1)
                         ) r)
                 (clojure.string/join f)))))


#_(defn where-transformation2 [input]
    (w/postwalk (fn [w]
                  (if (sequential? w)
                    (make-where-str w)
                    w)) input))



(defn where-transformation [input]
  (field-transformation input)
  #_(let [where (first input)]
      (field-transformation (into [] (rest input)))
      )
  #_(w/postwalk (fn [w]
                  (if (sequential? w)
                    (make-where-str w)
                    w)) input))








(comment

  ;(field-transformation ["=" "ref_dem/oe_name" "nil"])

  ;(drop 1 [1 2 3])
  (field-transformation ["where" ["and" ["<" "ref_dem/oe_name" 5]
                                  ["<" "ref_dem/oe_name" 5]
                                  ["<" "ref_dem/oe_name" 5]]])

  (where-transformation ["where" ["<" "ref_dem/oe_name" 5]])

  (where-transformation ["where" ["and"
                                  ["=" "t" ["case"
                                            "net_claim2/INSURERS_GROSS_POLICY_SHARE"
                                            ["=null"  0.0]
                                            "else"
                                            "net_claim2/INSURERS_GROSS_POLICY_SHARE"]]


                                  ["=" "ref_dem/column_name" "'LOCAL_LOSS_CAUSE'"]
                                  ]])


  (where-transformation ["where" ["and"
                                  ["=" "ref_dem/oe_name" "null"]
                                  ["=" "ref_dem/data_category" "'CLAIM'"]
                                  ["=" "ref_dem/column_name" "'LOCAL_LOSS_CAUSE'"]
                                  ]])


  (make-str-where ["where" ["=" "ref_dem/data_category" "'CLAIM'"]])
  )


(defn make-join-type [join-str]
  (condp = join-str
    "left_join" "left join"
    "join" "inner join"
    "outer_join" "outer join"
    "inner join"))


(defn join-transformation-one

  [context entity-schema-m join-input join-window]
    ;(println "--join " join-input)
    ;(   entity-schema-m)
   (let [join-window (or (get context :join-window) join-window)
         [join-type source-entity target-entity join-window-inline] join-input
         join-window (or join-window-inline join-window)
         ;_ (println "--" input)
         join-type (make-join-type join-type)
         target-entity-name (first (clojure.string/split target-entity #"/"))
         source-field-name (clojure.string/replace source-entity #"/" ".")
         target-field-name (clojure.string/replace target-entity #"/" ".")
         ;  _ (println "----------" (keys entity-schema-m))
         ;   _ (  (get-in  entity-schema-m [(clojure.string/upper-case target-entity-name) ] ))
         ;_ (println "----------" (get-in  entity-schema-m [(clojure.string/upper-case target-entity-name) ] ))
         buffer-frame (if (contains? #{"TABLE" "table"}
                                     (get-in entity-schema-m [(clojure.string/lower-case target-entity-name) :type])
                                     )
                        ""
                        join-window

                        )
         ;target-field-name    (str target-entity-name "." "ROWKEY")
         #_(if (= "TABLE"
                  (get-in entity-schema-m [(clojure.string/lower-case target-entity-name) :type]))
             (str target-entity-name "." "ROWKEY")
             target-field-name
             )

         ;    _ (println "--" buffer-frame)
         ]
     (str " " join-type " " target-entity-name " " target-entity-name " " buffer-frame " ON " source-field-name " = " target-field-name)))


(defn join-transformation
  ([context entity-schema-m join-input] (join-transformation context entity-schema-m join-input "WITHIN 5 MINUTES"))
  ([context entity-schema-m join-input join-window]
   ;(println "--join " join-input)
   ;(   entity-schema-m)
   (clojure.string/join " " (mapv (fn [j]
                                    (join-transformation-one context entity-schema-m j join-window)
                                    )  join-input) )

   #_(let [join-window (or (get context :join-window) join-window)
         [join-type source-entity target-entity join-window-inline] join-input
         join-window (or join-window-inline join-window)
         ;_ (println "--" input)
         join-type (make-join-type join-type)
         target-entity-name (first (clojure.string/split target-entity #"/"))
         source-field-name (clojure.string/replace source-entity #"/" ".")
         target-field-name (clojure.string/replace target-entity #"/" ".")
         ;  _ (println "----------" (keys entity-schema-m))
         ;   _ (  (get-in  entity-schema-m [(clojure.string/upper-case target-entity-name) ] ))
         ;_ (println "----------" (get-in  entity-schema-m [(clojure.string/upper-case target-entity-name) ] ))
         buffer-frame (if (contains? #{"TABLE" "table"}
                             (get-in entity-schema-m [(clojure.string/lower-case target-entity-name) :type])
                             )
                        ""
                        join-window

                        )
         ;target-field-name    (str target-entity-name "." "ROWKEY")
         #_(if (= "TABLE"
                  (get-in entity-schema-m [(clojure.string/lower-case target-entity-name) :type]))
             (str target-entity-name "." "ROWKEY")
             target-field-name
             )

         ;    _ (println "--" buffer-frame)
         ]
     (str " " join-type " " target-entity-name " " target-entity-name " " buffer-frame " ON " source-field-name " = " target-field-name))))


(comment

  (join-transformation (list "left_join" "customer_in/id" "address_in/id"))

  (transfer-fn (list "kun"))

  (transfer-fn (list "concat" "test" "f-name" "test2" "lname"))

  (transfer-fn (list "score" "test" "f-name" "test2" "lname"))

  (where-transformation (list "where" (list "and " (list "=" "customer_re/gender" "'M'")
                                            (list "=" "customer_re/gender" "'F'")
                                            )))




  (let [input (list "alias" (list "kun" "customer_re/first_name" "customer_re/last_name") "customer_re/gender")]
    (field-transformation input)

    )

  )