(ns io.datafy.http.viz-model-gen
  (:require [clojure.data.csv :as csv]
            [cheshire.core :as json]
            [clojure.java.io :as io]))


(defn gen-data [dir]
  (for [f (rest (file-seq (io/file dir)))]
    (with-open [reader (io/reader f)]
      (let [f-name (-> (.getName f)
                       (clojure.string/replace-first #"[.][^.]+$" "")
                       (clojure.string/lower-case))
            column-name (->> (first (csv/read-csv reader))
                             (mapv #(clojure.string/split % #","))
                             (apply concat)
                             (map clojure.string/lower-case))]
        (when (> (count column-name) 2)
          {f-name column-name})))))

(defn gen-model [relation m]
  (let [entity-m (atom {})
        counter (atom 1)
        ww (doall (for [[e p] relation]
                    (do
                      (swap! counter inc)
                      (swap! entity-m assoc e @counter)
                      (if p
                        (let [pid (get @entity-m p)]
                          {"id" @counter "name" e "parent" pid "size" (rand-int 1000)})
                        {"id" @counter "name" e "parent" 0 "size" (rand-int 1000)}))))

        wwchild (for [[k v] m
                      :let [pid (get @entity-m k)]
                      v1 v]
                  (do
                    (swap! counter inc)
                    {"id" @counter "name" v1 "parent" (or pid 0) "size" (rand-int 1000)}))
        out (into ww wwchild)]
    (cons {"id" 0 "name" "mvp"} out)))


(defn gen-raw-model []
  (let [m (into {} (remove nil?) (gen-data ".resources/public/data"))
        relation [["event"]
                  ["claim" "event"]
                  ["contract" "event"]
                  ["coverage" "event"]
                  ["party" "event"]
                  ["party_contract" "party"]]
        w (gen-model relation m)
        e (json/generate-string w)]

    e
    ;(spit "example/resources/public/model.json" e :append true)

    ))

(comment

  ;{  "id" 244,       "name" "RandomLayout",   "parent" 231,   "size" 870   }

  (let [m (into {} (remove nil?) (gen-data "./example/conf/raw1/data/canno"))
        relation [["event"]
                  ["claim" "event"]
                  ["contract" "event"]
                  ["coverage" "event"]
                  ["party" "event"]
                  ["party_contract" "party"]]
        w (gen-model relation m)
        e (json/generate-string w)]

       ;w
    (spit "example/resources/public/model.json" e :append true)

    )

  )


