(ns io.datafy.http.server.encoding-util
  (:require [cognitect.transit :as transit])
  (:import [java.io ByteArrayInputStream ByteArrayOutputStream]))


(defn to-transit [v]
  (let [out (ByteArrayOutputStream. 4096)
        writer (transit/writer out :json)
        _ (transit/write writer v)
        w (.toString out)]
    w))

(defn from-transit [v]
  (-> (.getBytes v)
      (ByteArrayInputStream.)
      (transit/reader :json)
      (transit/read)))
