(ns io.datafy.http.server
  (:require [clojure.java.io :as io]
            [clojure.tools.logging :as log]
            [io.pedestal.http.route :as route]
            [io.pedestal.http :as http]
            [io.datafy.http.viz-model-gen :as v]
            [io.datafy.http.route :as ser]))


(defn file-response [r]
  (let [body (try (io/input-stream (io/resource "public/index.html"))
                  (catch Exception e
                    "Ping"))]
    {:status  200
     :headers {"Content-Type" "text/html; charset=utf-8"}
     :body    body}))



(defn model-response [r]
  {:status 200
   :headers {"Content-Type" "application/json; charset=utf-8"}
   :body (v/gen-raw-model)})


(def app-routes (route/expand-routes #{["/" :any file-response :route-name :root-route]
                                       ["/mvp/model" :any model-response :route-name :model-route]
                                       }))




(defn start-server [context {:keys [pedestal root-url]}]
  (let [routes (->> (ser/get-routes context root-url)
                    (into app-routes))
        v {::http/resource-path  "/public"
           ::http/type           :jetty
           ;  ::http/allowed-origins {:allowed-origins (constantly true)}
           ::http/secure-headers {:content-security-policy-settings {:object-src "none"}}
           ::http/port           8890}
        pedestal (if pedestal
                   (merge v pedestal)
                   v)]
    (log/info "Server is starting with " pedestal)
    (-> pedestal
        (assoc ::http/routes routes)
        (http/create-server)
        (http/start))))

(defn stop-server [server]
  (http/stop server))


(defn start-dev
  "The entry-point for 'lein run-dev'"
  [handler & args]
  (let [v (-> {::http/routes (ser/get-routes-test "/r" handler)
               ::http/type   :jetty
               ::http/port   8890}
              (merge {:env                   :dev
                      ::http/join?           false
                      ;    ::http/routes          #(deref #'routes)
                      ::http/secure-headers  nil
                      ;; all origins are allowed in dev mode
                      ::http/allowed-origins {:creds true :allowed-origins (constantly true)}})
              ;; Wire up interceptor chains
              http/default-interceptors
              http/dev-interceptors
              http/create-server
              http/start)]
    v
    #_(reset! server v)))

(defn stop-dev [server]
  (do
    (http/stop server)))

