(ns clj-eden.console.core
  (:require [clj-eden.colls.core :refer [in?]]))

(defn prompt
  "Give a prompt and return non-empty user input optionally with a default message"
  ([msg]
    (print (str msg " "))
    (flush)
    (def response (read-line))
    (if (empty? response)
      (prompt msg)
      response))
  ([msg default]
    (print (str msg " [" default "] "))
    (flush)
    (def response (read-line))
    (if (empty? response)
      default
      response)))

(defn prompt-pw [msg]
  "Prompt for and return a password not echoing"
  (print (str msg " ")) (flush)
  (apply str (.readPassword (System/console))))

(defn prompt-yn [msg]
  "Prompt for an affirmative or negative response returning true or false"
  (defn affirmative [response]
    (in? ["y" "yes" "yep" "sure" "ok" "agreed" "make it so" "yea" "yeah" "no problem" "affirmative"] (.toLowerCase response)))
  (defn negative [response]
    (in? ["n" "no" "nope" "no way" "negative" "nay" "not a chance" "you wish"] (.toLowerCase response)))
  (loop []
    (print (str msg " "))
    (flush)
    (def response (read-line))
    (if (or (affirmative response) (negative response))
      (affirmative response)
      (recur))))
