(ns clj-eden.console.core)

(defn prompt
  "Give a prompt and return non-empty user input optionally with a default message"
  ([msg]
    (print (str msg " "))
    (flush)
    (def response (read-line))
    (if (empty? response)
      (prompt msg)
      response))
  ([msg default]
    (print (str msg " [" default "] "))
    (flush)
    (def response (read-line))
    (if (empty? response)
      default
      response)))

(defn prompt-pw [msg]
  "Prompt for and return a password not echoing"
  (print (str msg " ")) (flush)
  (apply str (.readPassword (System/console))))


