(ns leiningen.new.clj-eden-lib
  "Generate a basic clj-eden-lib project."
  (:require [leiningen.new.templates :refer [renderer year project-name
                                             ->files sanitize-ns name-to-path
                                             multi-segment]]
            [clojure.string :as string]
            [leiningen.core.main :as main]))

(defn clj-eden-lib
  "A clj-eden library project template."
  [name]
  (let [render (renderer "clj-eden-lib")
        artifact-id (last (string/split name #"-"))
        group-id (string/join "-" (butlast (string/split name #"-")))
        core-ns (str group-id "." artifact-id ".core")
        project-clj-name (str group-id "/" artifact-id)
        data {:project-clj-name project-clj-name
              :namespace-dir (string/replace project-clj-name #"-" "_")
              :name name
              :core-ns core-ns
              :group-id group-id
              :artifact-id artifact-id
              :year (year)}]
    (main/info "Generating" name "based on the 'clj-eden-lib' template.")
    (->files data
      ["project.clj" (render "project.clj" data)]
      ["README.md" (render "README.md" data)]
      [".gitignore" (render "gitignore" data)]
      ["src/{{namespace-dir}}/core.clj" (render "core.clj" data)]
      ["test/{{namespace-dir}}/core_test.clj" (render "test.clj" data)]
      ["LICENSE" (render "LICENSE" data)]
      "resources")))
