(ns leiningen.new.clj-eden-lib
  "Generate a basic clj-eden-lib project."
  (:require [leiningen.new.templates :refer [renderer year project-name
                                             ->files sanitize-ns name-to-path
                                             multi-segment]]
            [clojure.string :as string]
            [leiningen.core.main :as main]))

(defn clj-eden-lib
  "A clj-eden library project template."
  [name]
  (let [render (renderer "clj-eden-lib")
        main-ns (multi-segment (sanitize-ns name))
        data {:raw-name name
              :name (project-name name)
              :namespace main-ns
              :sanitized (name-to-path name)
              :year (year)}]
    (main/info "Generating" name "based on the 'clj-eden-lib' template.")
    (->files data
      ["project.clj" (render "project.clj" data)]
      ["README.md" (render "README.md" data)]
      [".gitignore" (render "gitignore" data)]
      ["src/{{name}}/core.clj" (render "core.clj" data)]
      ["test/{{name}}/core_test.clj" (render "test.clj" data)]
      ["LICENSE" (render "LICENSE" data)]
      "resources")))
