(ns utils.team-service
  (:require [utils.http :refer [GET]]))

(defn get-host []
  (System/getenv "CSAPIHOST"))

(defn get-team [token employee-id]
  (:body
    (GET (str "https://" (get-host) "/api/team")
         {:headers      {:Authorization (str "Bearer " token)}
          :query-params {:employeeId employee-id}
          :as           :json
          :insecure?    true})))

(defn get-team-employee-ids [token employee-id]
  (map :id (tree-seq :reports :reports (get-team token employee-id))))
