(ns utils.camel-kebab-interceptor
  (:require [camel-snake-kebab.core :refer :all]
            [camel-snake-kebab.extras :refer [transform-keys]]))

(def casing-interceptor
  {:name :camel-kebab-interceptor
   :enter
         (fn [context]
           (update-in context [:request :body] #(transform-keys ->kebab-case %1)))
   :leave
         (fn [context]
           (update-in context [:response :body] #(transform-keys ->camelCase %1)))})
