(ns ^{:doc "wrapper of slf4j MDC object for purpose of managing thread-local strings for logging"}
utils.mdc
  (:import (org.slf4j MDC)))

(def tenant-id-field "tenantId")
(def user-id-field "userId")
(def request-id-field "requestId")

(defn get-tenant-id []
  (MDC/get tenant-id-field))

(defn put-tenant-id [id]
  (MDC/put tenant-id-field (str id)))

(defn remove-tenant-id []
  (MDC/remove tenant-id-field))

(defn get-user-id []
  (MDC/get user-id-field))

(defn put-user-id [id]
  (MDC/put user-id-field (str id)))

(defn remove-user-id []
  (MDC/remove user-id-field))

(defn get-request-id []
  (MDC/get request-id-field))

(defn put-request-id [id]
  (MDC/put request-id-field (str id)))

(defn remove-request-id []
  (MDC/remove request-id-field))

